/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.common.ec.cache;

import java.util.HashMap;
import java.util.Map;

public class OrganCache {
    private static final OrganCache instance = new OrganCache();
    private Map<String, OrganNode> nodeMap = new HashMap<String, OrganNode>();
    private boolean init;

    private OrganCache() {
    }

    public static OrganCache getInstance() {
        return instance;
    }

    public boolean isInit() {
        return this.init;
    }

    public synchronized void buildOrganNodes(Map<String, OrganNode> nodeMap) {
        if (nodeMap == null) {
            return;
        }
        this.nodeMap = nodeMap;
        this.init = true;
    }

    public int getOrganCount() {
        return this.nodeMap.size();
    }

    public int getAllPersonCount(String orgId) {
        OrganNode organNode = this.getOrganNode(orgId);
        if (organNode == null) {
            return 0;
        }
        return organNode.allPersonCount;
    }

    public int getSubPersonCount(String orgId) {
        OrganNode organNode = this.getOrganNode(orgId);
        if (organNode == null) {
            return 0;
        }
        return organNode.personCount;
    }

    private OrganNode getOrganNode(String orgId) {
        return this.nodeMap.get(orgId);
    }

    public static OrganNode newOrganNode(int personCount, int allPersonCount) {
        return new OrganNode(personCount, allPersonCount);
    }

    public static class OrganNode {
        private int personCount;
        private int allPersonCount = -1;

        private OrganNode(int personCount, int allPersonCount) {
            this.personCount = personCount;
            this.allPersonCount = allPersonCount;
        }
    }
}

