/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.common.ec.dao;

import com.kingdee.bos.Context;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.EmpWorkExperienceBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.OrganBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.OrganPersonInfoBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.PersonBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.PersonSimpleBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.config.EcConfigBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.dao.BaseDaoSupport;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.util.List;
import java.util.Map;

public class EcDao
extends BaseDaoSupport {
    public static PersonBean findPerson(Context ctx, String personId) throws Exception {
        String sql = "select * from T_BD_Person where FID = ?";
        return EcDao.findOne(ctx, PersonBean.class, sql, personId);
    }

    public static PersonSimpleBean findPersonSimple(Context ctx, String personId) throws Exception {
        String sql = "select * from T_BD_Person where FID = ?";
        return EcDao.findOne(ctx, PersonSimpleBean.class, sql, personId);
    }

    public static List<PersonSimpleBean> searchPersonSimple(Context ctx, String word) throws Exception {
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select p.* from T_BD_Person p inner join T_HR_BDEmployeeType t on p.FEmployeeTypeID=t.FID where p.FDeletedStatus=1 and t.FIsInCount = 1 and (p.FNAME_" + l + " like ? or p.FFULLNAMEPINGYIN like ? or p.FSIMPLENAMEPINGYIN like ?) order by p.findex asc, p.FNumber asc";
        word = "%" + word + "%";
        return EcDao.find(ctx, 0, EcConfigBean.getInstance().getSearchPersonMaxSize(), PersonSimpleBean.class, sql, word, word, word);
    }

    public static List<OrganBean> searchOrgan(Context ctx, String word) throws Exception {
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select o.* from T_ORG_Admin o where o.FName_" + l + " like ? and o.FIsSealUp=0 order by o.findex asc, o.FLongNumber asc";
        word = "%" + word + "%";
        return EcDao.find(ctx, 0, EcConfigBean.getInstance().getSearchOrgMaxSize(), OrganBean.class, sql, word);
    }

    public static List<OrganPersonInfoBean> findOrgPersonInfo(Context ctx, String orgId, int firstResult, int maxResult) throws Exception {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid FPersonid, a.FCell FPersonCell, a.FName_").append(l).append(" FPersonName, a.FGender FPersonGender, b.fisprimary fisprimary, c.FName_").append(l).append(" FPositionName, d.FName_").append(l).append(" ForgName");
        sql.append(" from T_BD_Person a ");
        sql.append(" inner join T_HR_BDEmployeeType t on a.FEmployeeTypeID=t.FID");
        sql.append(" inner join t_org_positionmember b on a.fid=b.fpersonid");
        sql.append(" inner join t_org_position c on b.fpositionid=c.fid ");
        sql.append(" inner join t_org_admin d on c.FAdminOrgUnitId=d.fid ");
        sql.append(" where b.fisprimary=1 and d.fid=? and a.FDeletedStatus=1 and  t.FIsInCount = 1 ");
        sql.append(" order by a.findex asc, a.fnumber asc");
        return EcDao.find(ctx, firstResult, maxResult, OrganPersonInfoBean.class, sql.toString(), orgId);
    }

    public static List<EmpWorkExperienceBean> findPersonWorksByPersonId(Context ctx, String personId) throws Exception {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select b.FPersonID personId, c.fid positionId, c.fname_").append(l).append(" positionName, d.fid orgId, d.FName_").append(l).append(" orgName, d.FDisplayName_").append(l).append(" orgDisplayName");
        sql.append(" from t_org_positionmember b ");
        sql.append(" inner join t_org_position c on b.fpositionid=c.fid ");
        sql.append(" inner join t_org_admin d on c.FAdminOrgUnitId=d.fid ");
        sql.append(" where b.FPersonID=? and d.FIsSealUp=0");
        sql.append(" order by b.fisprimary desc,d.FLongNumber asc");
        return EcDao.find(ctx, EmpWorkExperienceBean.class, sql.toString(), personId);
    }

    public static List<OrganBean> findOrgChildren(Context ctx, String parentId) throws Exception {
        String sql = "select * from T_ORG_Admin where FParentID = ? and FIsSealUp=0 order by findex asc, FLongNumber asc";
        return EcDao.find(ctx, OrganBean.class, sql, parentId);
    }

    public static OrganBean findOrgRoot(Context ctx) throws Exception {
        String sql = "select * from T_ORG_Admin where FParentID is null";
        return EcDao.findOne(ctx, OrganBean.class, sql, new Object[0]);
    }

    public static OrganBean findOrgById(Context ctx, String id) throws Exception {
        String sql = "select * from T_ORG_Admin where Fid = ?";
        return EcDao.findOne(ctx, OrganBean.class, sql, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] findPersonImage(Context ctx, String personId) throws Exception {
        String sql = "select FImageData from t_hr_personphoto where FPersonID = ?";
        Map<String, Object> oo = EcDao.findOne(ctx, sql, personId);
        if (oo == null) {
            return null;
        }
        Object object = oo.get("FIMAGEDATA");
        if (object == null) {
            return null;
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            InputStream in = blob.getBinaryStream();
            if (in == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            try {
                while (-1 != (n = in.read(buffer))) {
                    out.write(buffer, 0, n);
                }
            }
            finally {
                in.close();
            }
            return out.toByteArray();
        }
        return null;
    }
}

