/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.common.ec.runner;

import com.kingdee.bos.Context;
import com.kingdee.eas.mobileaccess.hr.common.ec.cache.OrganCache;
import com.kingdee.eas.mobileaccess.hr.common.ec.dao.EcDao;
import com.kingdee.eas.mobileaccess.hr.common.ec.util.OrgPersonService;
import com.kingdee.eas.mobileaccess.hr.sHR.util.ContextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.context.ApplicationContext;

public class EcOrgPersonTask
implements Job {
    private static final Logger logger = Logger.getLogger(EcOrgPersonTask.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ApplicationContext applicationContext = (ApplicationContext)context.getJobDetail().getJobDataMap().get((Object)"applicationContext");
            this.compute(applicationContext);
            logger.info((Object)"Successfully executed [number of computer staff] thread!");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)("Failed to execute [number of computer staff] thread: " + e.getMessage()));
        }
    }

    public void compute(ApplicationContext applicationContext) throws Exception {
        Context ctx = ContextUtils.getContext();
        if (applicationContext == null) {
            throw new RuntimeException("Application context is empty");
        }
        List<Map<String, Object>> allOrg = EcDao.find(ctx, "select Fid, FLongNumber from T_ORG_Admin where FIsSealUp=0");
        if (allOrg == null) {
            logger.warn((Object)"No institutions found");
            return;
        }
        List<Map<String, Object>> list = this.countOrganPerson();
        if (list == null) {
            logger.warn((Object)"Failed to calculate the number of direct employees of all organizations");
            return;
        }
        HashMap<String, Integer> orgMap = new HashMap<String, Integer>();
        for (Map<String, Object> oo : list) {
            String id = String.valueOf(oo.get("FORGID"));
            int count = Integer.parseInt(String.valueOf(oo.get("PERSONCOUNT")));
            orgMap.put(id, count);
        }
        List<String> filterNums = OrgPersonService.getInstance().findFilterOrgLongNumber(ctx);
        HashMap<String, OrganCache.OrganNode> nodeMap = new HashMap<String, OrganCache.OrganNode>();
        for (Map<String, Object> oo : allOrg) {
            String id = String.valueOf(oo.get("FID"));
            String longNumber = String.valueOf(oo.get("FLONGNUMBER"));
            if (OrgPersonService.isFilter(longNumber, filterNums)) continue;
            Integer count = (Integer)orgMap.get(id);
            if (count == null) {
                count = 0;
            }
            int allCount = this.countOrganAllPerson(longNumber, filterNums);
            nodeMap.put(id, OrganCache.newOrganNode(count, allCount));
        }
        OrganCache.getInstance().buildOrganNodes(nodeMap);
    }

    private List<Map<String, Object>> countOrganPerson() throws Exception {
        Context ctx = ContextUtils.getContext();
        StringBuffer sb = new StringBuffer();
        sb.append(" select d.fid FOrgID, count(b.FPersonID) PERSONCOUNT");
        sb.append(" from t_org_positionmember b ");
        sb.append(" inner join t_org_position c on b.fpositionid=c.fid ");
        sb.append(" inner join t_org_admin d on c.FAdminOrgUnitId=d.fid and d.FIsSealUp=0 ");
        sb.append(" inner join T_BD_Person a on b.fpersonid = a.fid ");
        sb.append(" inner join T_HR_BDEmployeeType t on a.FEmployeeTypeID=t.fid ");
        sb.append(" where b.fisprimary=1 and a.FDeletedStatus=1 and t.FIsInCount = 1 ");
        sb.append(" group by d.fid");
        return EcDao.find(ctx, sb.toString());
    }

    private int countOrganAllPerson(String longNumber, List<String> filterNums) throws Exception {
        Context ctx = ContextUtils.getContext();
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select count(b.FPersonID)");
        sb.append(" from t_org_positionmember b ");
        sb.append(" inner join t_org_position c on b.fpositionid=c.fid ");
        sb.append(" inner join t_org_admin d on c.FAdminOrgUnitId=d.fid and d.FIsSealUp=0");
        sb.append(" inner join T_BD_Person a on b.fpersonid = a.fid ");
        sb.append(" inner join T_HR_BDEmployeeType t on a.FEmployeeTypeID=t.fid ");
        sb.append(" where b.fisprimary=1 and a.FDeletedStatus=1 and t.FIsInCount = 1 ");
        sb.append(" and d.flongnumber like ? ");
        params.add(longNumber + "%");
        List<String> subNums = OrgPersonService.findSubFilterLongNumber(longNumber, filterNums);
        int size = subNums.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                sb.append(" and d.flongnumber not like ? ");
                params.add(subNums.get(i) + "%");
            }
        }
        return EcDao.count(ctx, sb.toString(), params.toArray());
    }
}

