/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.common.ec2.bo;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.EmpWorkExperienceBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.OrganBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.OrganPersonInfoBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.PersonBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.PersonSimpleBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.PersonphotoBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.cache.OrganCache;
import com.kingdee.eas.mobileaccess.hr.common.ec.config.EcConfigBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.json.PersonInfoJson;
import com.kingdee.eas.mobileaccess.hr.common.ec.util.EcCommonUtil;
import com.kingdee.eas.mobileaccess.hr.common.ec.util.OrgPersonService;
import com.kingdee.eas.mobileaccess.hr.common.ec.vo.OrgInfo;
import com.kingdee.eas.mobileaccess.hr.common.ec.vo.OrgInfo2;
import com.kingdee.eas.mobileaccess.hr.common.ec.vo.OrgPersonVo;
import com.kingdee.eas.mobileaccess.hr.common.ec.vo.OrgPositionVo;
import com.kingdee.eas.mobileaccess.hr.common.ec.vo.PersonContactVo;
import com.kingdee.eas.mobileaccess.hr.common.ec2.dao.EcDao;
import com.kingdee.eas.mobileaccess.hr.sHR.context.MobileUserContext;
import com.kingdee.eas.mobileaccess.hr.sHR.filter.PersonCoditionFilter;
import com.kingdee.eas.mobileaccess.hr.sHR.util.MobileUserManager;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class EcBo {
    public static byte[] findPersonPhoto(Context ctx, String personId) throws Exception {
        return EcDao.findPersonImage(ctx, personId);
    }

    public static List<PersonphotoBean> findPersonPhoto(Context ctx, String[] personId) throws Exception {
        return EcDao.findPersonImage(ctx, personId);
    }

    public static PersonSimpleBean getPersonSimpleInfo(Context ctx, String personId) throws Exception {
        return EcDao.findPersonSimple(ctx, personId);
    }

    public static OrganBean getMyMainOrgInfo(Context ctx) throws Exception {
        MobileUserContext context = MobileUserManager.getMobileUserContext();
        String personId = context.getPersonId();
        OrganBean org = EcDao.findPersonMainOrg(ctx, personId);
        if (org == null) {
            throw new Exception(EASResource.getString((String)"com.kingdee.shr.base.syssetting.ShrmobileResource", (String)"notfound_org_info", (Locale)ctx.getLocale()));
        }
        return org;
    }

    public static OrganBean getOrg(Context ctx, String orgId) throws Exception {
        return EcDao.findOrgById(ctx, orgId);
    }

    public static OrgInfo getOrgInfo(Context ctx, String orgId) throws Exception {
        OrganBean org;
        OrgInfo orgTree = null;
        List<Object> childOrgs = null;
        if (StringUtils.isEmpty((String)orgId)) {
            org = EcBo.findRootOrgByConfig(ctx);
            if (org == null && (org = EcDao.findOrgRoot(ctx)) == null) {
                throw new Exception(EASResource.getString((String)"com.kingdee.shr.base.syssetting.ShrmobileResource", (String)"notfound_parent_org_info", (Locale)ctx.getLocale()));
            }
            childOrgs = new ArrayList<OrganBean>();
            childOrgs.add(org);
            orgTree = new OrgInfo("", "", "");
            orgTree.setParentId("");
        } else {
            org = EcDao.findOrgById(ctx, orgId);
            if (org == null) {
                String strExcMsg = EASResource.getString((String)"com.kingdee.shr.base.syssetting.ShrmobileResource", (String)"notfound_org_forid", (Locale)ctx.getLocale());
                throw new Exception(MessageFormat.format(strExcMsg, orgId));
            }
            orgId = org.getId();
            orgTree = new OrgInfo(orgId, org.getName(), "");
            if (EcBo.isMyTopAuthOrgById(ctx, orgId)) {
                orgTree.setParentId("");
            } else {
                orgTree.setParentId(org.getParentId());
            }
            childOrgs = EcDao.findOrgChildrenByConfig(ctx, orgId);
        }
        ArrayList<OrgInfo2> children = new ArrayList<OrgInfo2>();
        orgTree.setChildren(children);
        if (childOrgs != null && !childOrgs.isEmpty()) {
            UserInfo userInfo = MobileUserManager.getMobileUserContext().getUserInfo();
            boolean showOrgPersonCount = EcCommonUtil.showOrgPersonCount(userInfo);
            for (OrganBean organBean : childOrgs) {
                if (EcCommonUtil.filterOrgByConfig(organBean)) continue;
                String subOrgId = organBean.getId();
                String name = organBean.getName();
                OrgInfo2 e = new OrgInfo2(subOrgId, name, "");
                if (showOrgPersonCount) {
                    e.setPersonCount(OrganCache.getInstance().getAllPersonCount(subOrgId) + "");
                } else {
                    e.setPersonCount("");
                }
                children.add(e);
            }
        }
        OrgInfo.OrgTopPerson orgTopPerson = orgTree.createOrgTopPerson();
        orgTree.setPerson(orgTopPerson);
        ArrayList<OrgPersonVo> list = new ArrayList<OrgPersonVo>();
        orgTopPerson.setTop(list);
        orgTopPerson.setHasMore(false);
        if (!StringUtils.isEmpty((String)orgId)) {
            int topCount = 4;
            int n = OrganCache.getInstance().getSubPersonCount(orgId);
            orgTopPerson.setHasMore(n > topCount);
            List<OrganPersonInfoBean> orgPerson = EcBo.getOrgPerson(ctx, orgId, 0, topCount);
            if (orgPerson != null && orgPerson.size() > 0) {
                for (OrganPersonInfoBean oo : orgPerson) {
                    if (oo == null) continue;
                    OrgPersonVo vo = new OrgPersonVo();
                    vo.setGender(oo.getGender());
                    vo.setId(oo.getId());
                    vo.setName(oo.getName());
                    if (EcCommonUtil.filterPersonMobile(oo.getNumber())) {
                        vo.setMobile("");
                    } else {
                        vo.setMobile(oo.getMobile());
                    }
                    vo.setPositionName(oo.getPositionName());
                    list.add(vo);
                }
            }
        }
        return orgTree;
    }

    public static List<OrgInfo2> getAncestor(Context ctx, String orgId) throws Exception {
        if (EcBo.isMyTopAuthOrgById(ctx, orgId)) {
            return null;
        }
        OrganBean org = EcDao.findOrgById(ctx, orgId);
        if (org == null) {
            return null;
        }
        ArrayList<OrgInfo2> parents = new ArrayList<OrgInfo2>();
        EcBo.iteratorOrgParents(ctx, org.getParentId(), parents);
        Collections.reverse(parents);
        return parents;
    }

    public static List<OrganPersonInfoBean> getOrgPerson(Context ctx, String orgId, int from, int pageSize) throws Exception {
        return EcDao.findOrgPersonInfo(ctx, orgId, from, pageSize);
    }

    public static List<OrganPersonInfoBean> getOrgAllPerson(Context ctx, String orgId, int from, int pageSize) throws Exception {
        OrganBean org = EcDao.findOrgById(ctx, orgId);
        String longNumber = org.getLongCode();
        return EcDao.findOrgAllPersonInfo(ctx, longNumber, from, pageSize);
    }

    public static List<OrgPersonVo> searchPerson(Context ctx, String word) throws Exception {
        List<Map<String, Object>> results;
        List<String> filterNums;
        int size;
        if (word == null || word.trim().length() == 0) {
            return null;
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select DISTINCT p.fid personid, p.FName_").append(l).append(" personName, p.FGender personGender, p.FCell mobile, p.FBackupCell mobile2, c.FName_").append(l).append(" positionName, d.FName_").append(l).append(" orgName, d.FDisplayName_").append(l).append(" orgDisplayName,p.fIndex pindex, p.FNumber FNumber");
        sql.append(" from T_BD_Person p");
        sql.append(" inner join T_HR_BDEmployeeType t on p.FEmployeeTypeID=t.FID");
        sql.append(" inner join t_org_positionmember b on p.fid=b.fpersonid and b.fisprimary=1 ");
        sql.append(" inner join t_org_position c on b.fpositionid=c.fid ");
        sql.append(" inner join t_org_admin d on c.FAdminOrgUnitId=d.fid ");
        sql.append(" where t.fisincount=1 AND p.FDeletedStatus=1 ");
        if (Pattern.matches("\\d+", word)) {
            sql.append(" and (p.FCell like ? or p.FOfficePhone like ? or p.FEmail like ?) ");
            String likeWord = word + "%";
            params.add(likeWord);
            params.add(likeWord);
            params.add(likeWord);
        } else if (Pattern.matches("[a-zA-Z]+", word)) {
            sql.append(" and (p.FFullNamePingYin like ? or p.FSimpleNamePingYin like ? or lower(p.FEmail) like ?) ");
            String lowerWord = word.toLowerCase() + "%";
            params.add(lowerWord);
            params.add(lowerWord);
            params.add(lowerWord);
        } else if (Pattern.matches("[\u4e00-\u9fa5]+\\w*", word)) {
            sql.append(" and p.FName_").append(l).append(" like ? ");
            params.add("%" + word + "%");
        } else {
            sql.append(" and lower(p.FEmail) like ? ");
            params.add(word.toLowerCase() + "%");
        }
        sql.append(" and ");
        sql.append(PersonCoditionFilter.mergeEmpTypeFilter("t"));
        OrganBean rootOrg = EcBo.findRootOrgByConfig(ctx);
        if (rootOrg != null) {
            sql.append(" and d.FLongNumber like ?");
            params.add(rootOrg.getLongCode() + "%");
        }
        if ((size = (filterNums = OrgPersonService.getInstance().findFilterOrgLongNumber(ctx)).size()) > 0) {
            for (int i = 0; i < size; ++i) {
                sql.append(" and d.FLongNumber not like ? ");
                params.add(filterNums.get(i) + "%");
            }
        }
        if ((results = EcDao.find(ctx, sql.toString(), params.toArray())) == null) {
            return null;
        }
        ArrayList<OrgPersonVo> list = new ArrayList<OrgPersonVo>();
        for (Map<String, Object> o : results) {
            String orgDisplayName;
            String orgName = o.get("ORGNAME") == null ? null : o.get("ORGNAME").toString();
            if (EcCommonUtil.filterOrgByName(orgName)) continue;
            String personid = o.get("PERSONID") == null ? null : o.get("PERSONID").toString();
            String personName = o.get("PERSONNAME") == null ? null : o.get("PERSONNAME").toString();
            String personGender = o.get("PERSONGENDER") == null ? null : o.get("PERSONGENDER").toString();
            String positionName = o.get("POSITIONNAME") == null ? null : o.get("POSITIONNAME").toString();
            String string = orgDisplayName = o.get("ORGDISPLAYNAME") == null ? null : o.get("ORGDISPLAYNAME").toString();
            String mobile = o.get("MOBILE") != null ? o.get("MOBILE").toString() : (o.get("MOBILE2") != null ? o.get("MOBILE2").toString() : "");
            int gender = 0;
            if (personGender != null) {
                try {
                    gender = Integer.parseInt(personGender);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            OrgPersonVo person = new OrgPersonVo();
            person.setId(personid);
            person.setName(personName);
            person.setGender(gender);
            if (EcCommonUtil.filterPersonMobile(o.get("FNUMBER") == null ? null : o.get("FNUMBER").toString())) {
                person.setMobile("");
            } else {
                person.setMobile(mobile);
            }
            person.setOrgName(EcCommonUtil.getOrgActualDisplayName(orgName, orgDisplayName));
            person.setPositionName(positionName);
            list.add(person);
        }
        return list;
    }

    private String getString(Context ctx, Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public static List<String> findPersonMobile(Context ctx, String[] personId) throws Exception {
        List<Map<String, Object>> mobiles = EcDao.findPersonMobile(ctx, personId);
        ArrayList<String> list = new ArrayList<String>();
        for (Map<String, Object> o : mobiles) {
            Object mobile = o.get("FCELL");
            if (mobile == null) {
                mobile = o.get("FBACKUPCELL");
            }
            if (mobile == null) {
                mobile = "";
            }
            list.add(String.valueOf(mobile));
        }
        return list;
    }

    public static PersonInfoJson getPerson(Context ctx, String personId) throws Exception {
        PersonBean p = EcDao.findPerson(ctx, personId);
        if (p == null) {
            String strExcMsg = EASResource.getString((String)"com.kingdee.shr.base.syssetting.ShrmobileResource", (String)"notfound_member_id", (Locale)ctx.getLocale());
            throw new Exception(MessageFormat.format(strExcMsg, personId));
        }
        PersonInfoJson person = new PersonInfoJson();
        person.setId(p.getId());
        person.setName(p.getName());
        person.setGender(p.getGender());
        if (!EcCommonUtil.filterPersonMobile(p.getNumber())) {
            person.addContact(EASResource.getString((String)"com.kingdee.shr.base.syssetting.ShrmobileResource", (String)"mobile", (Locale)ctx.getLocale()), p.getMobile(), PersonContactVo.ContactType.MOBILE);
        }
        person.addContact(EASResource.getString((String)"com.kingdee.shr.base.syssetting.ShrmobileResource", (String)"telephone", (Locale)ctx.getLocale()), p.getOfficeTel(), PersonContactVo.ContactType.TELEPHONE);
        person.addContact(EASResource.getString((String)"com.kingdee.shr.base.syssetting.ShrmobileResource", (String)"email", (Locale)ctx.getLocale()), p.getEmail(), PersonContactVo.ContactType.EMAIL);
        OrganBean org = EcDao.findPersonMainOrg(ctx, personId);
        if (org != null) {
            person.setOrgName(org.getName());
            person.setOrgId(org.getId());
        }
        person.setPosition(EcBo.findPersonWorks(ctx, personId));
        return person;
    }

    public static List<OrgPositionVo> findPersonWorks(Context ctx, String personId) throws Exception {
        ArrayList<OrgPositionVo> position = new ArrayList<OrgPositionVo>();
        List<EmpWorkExperienceBean> works = EcDao.findPersonWorksByPersonId(ctx, personId);
        if (works != null && works.size() > 0) {
            for (EmpWorkExperienceBean w : works) {
                if (w == null) continue;
                String orgName = EcCommonUtil.getOrgActualDisplayName(w);
                position.add(new OrgPositionVo(w.getOrgId(), orgName, w.getPositionName()));
            }
        }
        return position;
    }

    private static void iteratorOrgParents(Context ctx, String parentOrgId, List<OrgInfo2> parents) throws Exception {
        if (parentOrgId == null) {
            return;
        }
        OrganBean org = EcDao.findOrgById(ctx, parentOrgId);
        if (org == null) {
            return;
        }
        parents.add(new OrgInfo2(org.getId(), org.getName(), ""));
        if (EcBo.isMyTopAuthOrgById(ctx, parentOrgId)) {
            return;
        }
        EcBo.iteratorOrgParents(ctx, org.getParentId(), parents);
    }

    private static boolean isMyTopAuthOrgById(Context ctx, String orgId) {
        String rootOrgId = EcConfigBean.getInstance().getRootOrgId();
        if (rootOrgId != null) {
            return rootOrgId.equals(orgId);
        }
        return false;
    }

    private static OrganBean findRootOrgByConfig(Context ctx) throws Exception {
        String rootOrgId = EcConfigBean.getInstance().getRootOrgId();
        if (rootOrgId == null) {
            return null;
        }
        OrganBean rootOrg = EcDao.findOrgById(ctx, rootOrgId);
        if (rootOrg == null) {
            String strExcMsg = EASResource.getString((String)"com.kingdee.shr.base.syssetting.ShrmobileResource", (String)"notfound_org_byid", (Locale)ctx.getLocale());
            throw new Exception(MessageFormat.format(strExcMsg, rootOrgId));
        }
        return rootOrg;
    }

    public static List<OrgInfo2> searchOrg(Context ctx, String word) throws Exception {
        List<OrganBean> organs = null;
        OrganBean rootOrg = EcBo.findRootOrgByConfig(ctx);
        if (rootOrg != null) {
            String longCode = rootOrg.getLongCode();
            organs = EcDao.searchOrgan(ctx, word, longCode, true);
        } else {
            organs = EcDao.searchOrgan(ctx, word, null, true);
        }
        if (organs == null || organs.size() == 0) {
            return null;
        }
        ArrayList<OrgInfo2> list = new ArrayList<OrgInfo2>();
        for (OrganBean org : organs) {
            if (EcCommonUtil.filterOrgByConfig(org)) continue;
            list.add(new OrgInfo2(org.getId(), org.getName(), EcCommonUtil.getOrgActualDisplayName(org)));
        }
        return list;
    }

    public static int countAllLateJoinPerson(Context ctx, String longNumber) throws Exception {
        int count;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select count(distinct b.FPersonID)");
        sb.append(" from t_org_positionmember b ");
        sb.append(" inner join t_org_position c on b.fpositionid=c.fid ");
        sb.append(" inner join t_org_admin d on c.FAdminOrgUnitId=d.fid and d.FIsSealUp=0");
        sb.append(" inner join T_BD_Person a on b.fpersonid = a.fid ");
        sb.append(" inner join T_HR_BDEmployeeType t on a.FEmployeeTypeID=t.fid ");
        sb.append(" where b.fisprimary=1 and a.FDeletedStatus=1 and t.FIsInCount = 1 ");
        sb.append(" and d.flongnumber like ? ");
        params.add(longNumber + "%");
        Date addMonth = DateTimeUtils.addMonth((Date)new Date(), (int)-3);
        Timestamp timestamp = new Timestamp(addMonth.getTime());
        sb.append(" and b.FLastUpdateTime>? ");
        params.add(timestamp);
        List<String> filterNums = OrgPersonService.getInstance().findFilterOrgLongNumber(ctx);
        List<String> subNums = OrgPersonService.findSubFilterLongNumber(longNumber, filterNums);
        int size = subNums.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                sb.append(" and d.flongnumber not like ? ");
                params.add(subNums.get(i) + "%");
            }
        }
        if ((count = EcDao.count(ctx, sb.toString(), params.toArray())) == -1) {
            count = 0;
        }
        return count;
    }

    public static List<OrganPersonInfoBean> findAllLateJoinPerson(Context ctx, String orgId, int from, int pageSize) throws Exception {
        String orgAllPersonOrderBy;
        OrganBean org = EcDao.findOrgById(ctx, orgId);
        if (org == null) {
            String strExcMsg = EASResource.getString((String)"com.kingdee.shr.base.syssetting.ShrmobileResource", (String)"notfound_org_forid", (Locale)ctx.getLocale());
            throw new Exception(MessageFormat.format(strExcMsg, orgId));
        }
        String longNumber = org.getLongCode();
        ArrayList<Object> params = new ArrayList<Object>();
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sb = new StringBuffer();
        sb.append("select a.fid FPersonid, a.FCell FPersonCell, a.FNumber FPersonNumber, a.FName_").append(l).append(" FPersonName, a.FGender FPersonGender, c.FName_").append(l).append(" FPositionName, d.FDisplayName_").append(l).append(" FOrgDisplayName, d.FName_").append(l).append(" FOrgName");
        sb.append(" from t_org_positionmember b ");
        sb.append(" inner join t_org_position c on b.fpositionid=c.fid ");
        sb.append(" inner join t_org_admin d on c.FAdminOrgUnitId=d.fid and d.FIsSealUp=0");
        sb.append(" inner join T_BD_Person a on b.fpersonid = a.fid ");
        sb.append(" inner join T_HR_BDEmployeeType t on a.FEmployeeTypeID=t.fid ");
        sb.append(" where b.fisprimary=1 and a.FDeletedStatus=1 and t.FIsInCount = 1 ");
        sb.append(" and d.flongnumber like ? ");
        params.add(longNumber + "%");
        Date addMonth = DateTimeUtils.addMonth((Date)new Date(), (int)-3);
        Timestamp timestamp = new Timestamp(addMonth.getTime());
        sb.append(" and b.FLastUpdateTime>? ");
        params.add(timestamp);
        List<String> filterNums = OrgPersonService.getInstance().findFilterOrgLongNumber(ctx);
        List<String> subNums = OrgPersonService.findSubFilterLongNumber(longNumber, filterNums);
        int size = subNums.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                sb.append(" and d.flongnumber not like ? ");
                params.add(subNums.get(i) + "%");
            }
        }
        if (!StringUtils.isEmpty((String)(orgAllPersonOrderBy = EcCommonUtil.getOrgAllPersonOrderBy("a", "c", "d")))) {
            sb.append(" order by ");
            sb.append(orgAllPersonOrderBy);
        }
        return EcDao.find(ctx, from, pageSize, OrganPersonInfoBean.class, sb.toString(), params.toArray());
    }

    public static List<OrganPersonInfoBean> getPersonSmryList(Context ctx, String personIds) throws Exception {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid FPersonid, a.FCell FPersonCell, a.FNumber FPersonNumber, a.FName_").append(l).append(" FPersonName, a.FGender FPersonGender, c.FName_").append(l).append(" FPositionName, d.FName_").append(l).append(" FOrgName");
        sql.append(" from T_BD_Person a ");
        sql.append(" left outer join  t_org_positionmember b on a.fid=b.fpersonid and  b.fisprimary=1 ");
        sql.append(" left outer join t_org_position c on b.fpositionid=c.fid ");
        sql.append(" left outer join t_org_admin d on c.FAdminOrgUnitId=d.fid ");
        sql.append(" inner join T_HR_BDEmployeeType t on a.FEmployeeTypeID=t.FID");
        sql.append(" where a.fid in ( ").append(personIds).append("  )  ");
        String orgPersonOrderBy = EcCommonUtil.getOrgPersonOrderBy("a", "c");
        if (!StringUtils.isEmpty((String)orgPersonOrderBy)) {
            sql.append(" order by ");
            sql.append(orgPersonOrderBy);
        }
        return EcDao.find(ctx, OrganPersonInfoBean.class, sql.toString(), new Object[0]);
    }
}

