/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.common.team.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.mobileaccess.hr.common.team.app.AdminOwnerInfo;
import com.kingdee.eas.mobileaccess.hr.common.team.app.AdminResponserInfo;
import com.kingdee.eas.mobileaccess.hr.common.team.app.GenerateSubAdminCount;
import com.kingdee.eas.mobileaccess.hr.common.team.app.ResponseAdminInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class GenerateSubAdminAndOwner {
    public AdminOwnerInfo getSubAdminAndOwner(Context ctx, String adminId, String userId) throws BOSException {
        AdminOwnerInfo result = this.getOwnerAdminInfo(ctx, adminId);
        result.setChildren(this.getSubAdminDetailCount(ctx, adminId, result.getLongNumber()));
        result.setSubAdminCount(this.getSubAdminCount(ctx, result.getLongNumber()));
        int ownerPersonCount = this.getOwnerPersonCount(ctx, adminId);
        String count = "";
        if (ownerPersonCount != 0) {
            count = "" + ownerPersonCount;
        }
        result.setSubPersonCount(count);
        if (result.getParentId() != null) {
            int parentPersonCount = this.getAdminTotalCount(ctx, result.getParentId(), result.getParentLongNumber());
            result.setParentPersonCount("" + parentPersonCount);
        }
        result.setHrInfoPermission(this.getHasAdminPermission(ctx, result.getLongNumber(), userId, result));
        if (!result.isHrInfoPermission()) {
            result.setChildren(null);
            result.setParentId("");
        }
        this.countTotalPerson(result);
        return result;
    }

    public AdminOwnerInfo getSubAdminAndOwnerWithNoPermission(Context ctx, String adminId, String userId) throws BOSException {
        AdminOwnerInfo result = this.getOwnerAdminInfo(ctx, adminId);
        result.setChildren(this.getSubAdminDetailCount(ctx, adminId, result.getLongNumber()));
        result.setSubAdminCount(this.getSubAdminCount(ctx, result.getLongNumber()));
        int ownerPersonCount = this.getOwnerPersonCount(ctx, adminId);
        String count = "";
        if (ownerPersonCount != 0) {
            count = "" + ownerPersonCount;
        }
        result.setSubPersonCount(count);
        if (result.getParentId() != null) {
            int parentPersonCount = this.getAdminTotalCount(ctx, result.getParentId(), result.getParentLongNumber());
            result.setParentPersonCount("" + parentPersonCount);
        }
        result.setHrInfoPermission(this.getHasAdminPermission(ctx, result.getLongNumber(), userId, result));
        this.countTotalPerson(result);
        return result;
    }

    private void countTotalPerson(AdminOwnerInfo result) {
        int totalCount = 0;
        if (result.getChildren() != null && result.getChildren().size() > 0) {
            for (int i = 0; i < result.getChildren().size(); ++i) {
                ResponseAdminInfo responseAdminInfo = (ResponseAdminInfo)result.getChildren().get(i);
                if (StringUtils.isEmpty((String)responseAdminInfo.getPersonCount())) continue;
                totalCount += Integer.parseInt(responseAdminInfo.getPersonCount());
            }
        }
        if (!StringUtils.isEmpty((String)result.getSubPersonCount())) {
            totalCount += Integer.parseInt(result.getSubPersonCount());
        }
        result.setPersonCount("" + totalCount);
    }

    private boolean getHasAdminPermission(Context ctx, String longnumber, String userId, AdminOwnerInfo ownAdminInfo) throws BOSException {
        ArrayList subAdmins = GenerateSubAdminCount.getResponseAdmin(ctx, userId);
        for (int i = 0; i < subAdmins.size(); ++i) {
            ResponseAdminInfo responseAdminInfo = (ResponseAdminInfo)subAdmins.get(i);
            if (!this.fromIstoSub(longnumber, responseAdminInfo.getLongNumber())) continue;
            if (this.isTopAdmin(longnumber, subAdmins)) {
                ownAdminInfo.setParentId("");
            }
            return true;
        }
        return false;
    }

    private boolean isTopAdmin(String longnumber, ArrayList subAdmins) {
        for (int i = 0; i < subAdmins.size(); ++i) {
            ResponseAdminInfo responseAdminInfo = (ResponseAdminInfo)subAdmins.get(i);
            if (!longnumber.equals(responseAdminInfo.getLongNumber())) continue;
            return true;
        }
        return false;
    }

    private boolean fromIstoSub(String from, String to) {
        if (from.equals(to)) {
            return true;
        }
        return from.indexOf(to + "!") >= 0;
    }

    private int getOwnerPersonCount(Context ctx, String adminId) throws BOSException {
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)GenerateSubAdminCount.getInervicePersonCountSql(" WHERE adminorg.fid = ? "), (Object[])new Object[]{adminId});
        return this.getCountFromRowSet(rowSet);
    }

    private int getCountFromRowSet(IRowSet rowSet) {
        try {
            if (rowSet.next()) {
                return rowSet.getInt("count");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private int getSubAdminCount(Context ctx, String longnumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(*) count from t_org_admin where flongnumber like ?  and FIsSealUp = 0 ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{longnumber + "!%"});
        return this.getCountFromRowSet(rowSet);
    }

    private AdminOwnerInfo getOwnerAdminInfo(Context ctx, String adminId) throws BOSException {
        AdminOwnerInfo ownerInfo = new AdminOwnerInfo();
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select admin.fid fid,parentAdmin.fid fparentid,parentAdmin.fname_").append(l).append(" fparentName,parentAdmin.flongnumber fparentLongNumber,admin.fname_").append(l).append(" fname,admin.flongnumber flongnumber,");
        sql.append(" person.fid personid,person.fname_").append(l).append(" personName,person.fgender gender from t_org_admin admin ");
        sql.append(" left join t_org_positionmember pm on pm.fpositionid=admin.FResponPositionID ");
        sql.append(" left join t_bd_person person on person.fid = pm.fpersonid ");
        sql.append(" left join t_org_admin parentAdmin on parentAdmin.fid = admin.fparentid ");
        sql.append("  where admin.fid = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{adminId});
        try {
            if (rowSet.next()) {
                ownerInfo.setId(rowSet.getString("fid"));
                ownerInfo.setParentId(rowSet.getString("fparentid"));
                ownerInfo.setParentLongNumber(rowSet.getString("fparentLongNumber"));
                ownerInfo.setParentName(rowSet.getString("fparentName"));
                ownerInfo.setName(rowSet.getString("fname"));
                ownerInfo.setLongNumber(rowSet.getString("flongnumber"));
                AdminResponserInfo adminResponserInfo = new AdminResponserInfo();
                adminResponserInfo.setId(rowSet.getString("personid"));
                adminResponserInfo.setName(rowSet.getString("personName"));
                adminResponserInfo.setGender(rowSet.getInt("gender"));
                ownerInfo.setManager(adminResponserInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ownerInfo;
    }

    private int getAdminTotalCount(Context ctx, String adminId, String longnumber) throws BOSException {
        String inervicePersonCountSql = GenerateSubAdminCount.getInervicePersonCountSql(" WHERE adminorg.FLongNumber = '" + longnumber + "' or adminorg.FLongNumber like  '" + longnumber + "!%' and adminorg.FIsSealUp = 0");
        StringBuffer resultSql = GenerateSubAdminCount.getSubAdminPersonCountSql(ctx, inervicePersonCountSql, " where admin.fid='" + adminId + "' ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)resultSql.toString());
        try {
            if (rowSet.next()) {
                int personCount = rowSet.getInt("count");
                return personCount;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private ArrayList getSubAdminDetailCount(Context ctx, String adminId, String longnumber) throws BOSException {
        ResponseAdminInfo responseAdminInfo;
        String inervicePersonCountSql = GenerateSubAdminCount.getInervicePersonCountSql(" WHERE adminorg.FLongNumber like  '" + longnumber + "!%' and adminorg.FIsSealUp = 0");
        StringBuffer resultSql = GenerateSubAdminCount.getSubAdminPersonCountSql(ctx, inervicePersonCountSql, " where admin.fparentid='" + adminId + "' ");
        ArrayList<ResponseAdminInfo> subAdminList = new ArrayList<ResponseAdminInfo>();
        String l = LocaleUtils.getShortCode((Context)ctx);
        String subAdminSQl = "select fid,fname_" + l + " as fname,flongnumber from t_org_admin where fparentid= ? and FIsSealUp = 0 order by fsortcode,flongnumber ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)subAdminSQl, (Object[])new Object[]{adminId});
        HashMap<String, ResponseAdminInfo> subAdminMap = new HashMap<String, ResponseAdminInfo>();
        try {
            while (rowSet.next()) {
                responseAdminInfo = new ResponseAdminInfo();
                responseAdminInfo.setId(rowSet.getString("fid"));
                responseAdminInfo.setName(rowSet.getString("fname"));
                responseAdminInfo.setLongNumber(rowSet.getString("flongnumber"));
                subAdminList.add(responseAdminInfo);
                subAdminMap.put(rowSet.getString("fid"), responseAdminInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        rowSet = DbUtil.executeQuery((Context)ctx, (String)resultSql.toString());
        try {
            while (rowSet.next()) {
                responseAdminInfo = (ResponseAdminInfo)subAdminMap.get(rowSet.getString("fid"));
                responseAdminInfo.setPersonCount(rowSet.getString("count"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return subAdminList;
    }
}

