/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.common.team.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.emp.PersonPhotoCollection;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.mobileaccess.hr.sHR.util.SessionUtils;
import com.kingdee.util.StringUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;

public class PersonUtil {
    public static Map generatePhotoURL(HttpServletRequest request, Set personIds) throws BOSException, NoSuchAlgorithmException, IOException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("imageData"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personIds, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        Context ctx = SessionUtils.getCtx();
        PersonPhotoCollection personPhotoCollection = PersonPhotoFactory.getLocalInstance((Context)ctx).getPersonPhotoCollection(viewInfo);
        HashMap<String, String> personPhotoURLMap = new HashMap<String, String>();
        PersonPhotoInfo personPhotoInfo = null;
        String url = null;
        String personId = null;
        int size = personPhotoCollection.size();
        for (int i = 0; i < size; ++i) {
            personPhotoInfo = personPhotoCollection.get(i);
            url = PersonUtil.generatePhotoURL(request, personPhotoInfo.getImageData());
            if (StringUtils.isEmpty((String)url)) continue;
            personId = personPhotoInfo.getPerson().getId().toString();
            personPhotoURLMap.put(personId, url);
            personIds.remove(personId);
        }
        return personPhotoURLMap;
    }

    public static String generatePhotoURL(HttpServletRequest request, byte[] imageData) throws IOException, NoSuchAlgorithmException {
        if (imageData == null) {
            return null;
        }
        byte[] reducedImageData = PersonUtil.reducePhoto(imageData);
        ByteArrayInputStream bais = new ByteArrayInputStream(reducedImageData);
        BufferedInputStream bis = new BufferedInputStream(bais);
        byte[] data = new byte[bis.available()];
        bais.read(data, 0, data.length);
        bais.close();
        String url = null;
        if (data != null) {
            url = PersonUtil.getUrl(request, data);
        }
        return url;
    }

    private static String getUrl(HttpServletRequest request, byte[] data) throws NoSuchAlgorithmException, IOException {
        String fileName = "hr/personPhoto";
        String path = request.getRealPath("/");
        File file = new File(path + fileName);
        if (!file.exists() || file.isFile()) {
            file.mkdir();
        }
        String photoName = PersonUtil.MD5_32(new String(data));
        String url = fileName + "/" + photoName + ".gif";
        File photoFile = new File(path + url);
        if (!photoFile.exists()) {
            photoFile.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(photoFile);
            outputStream.write(data);
            outputStream.flush();
            outputStream.close();
        }
        return PersonUtil.getWebAppURL(request) + url;
    }

    private static byte[] reducePhoto(byte[] imageData) throws IOException {
        int nheight;
        int nwidth;
        double height;
        BufferedImage read = ImageIO.read(new ByteArrayInputStream(imageData));
        if (read == null) {
            return imageData;
        }
        double width = read.getWidth();
        double bi = width / (height = (double)read.getHeight());
        if (bi < 0.8) {
            nwidth = 48;
            nheight = (int)(48.0 * (1.0 / bi));
        } else {
            nheight = 60;
            nwidth = (int)(60.0 * bi);
        }
        Image scaledInstance = read.getScaledInstance(nwidth, nheight, 16);
        BufferedImage tag = new BufferedImage(nwidth, nheight, 1);
        tag.getGraphics().drawImage(scaledInstance, 0, 0, null);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)tag, "JPEG", output);
        byte[] byteArray = output.toByteArray();
        return byteArray;
    }

    private static StringBuffer getWebAppURL(HttpServletRequest request) {
        StringBuffer prefixUrl = new StringBuffer();
        prefixUrl.append(request.getScheme());
        prefixUrl.append("://");
        prefixUrl.append(request.getServerName());
        prefixUrl.append(":");
        prefixUrl.append(request.getServerPort());
        prefixUrl.append(request.getContextPath());
        prefixUrl.append("/");
        return prefixUrl;
    }

    private static String MD5_32(String var) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        StringBuffer strbuf = new StringBuffer();
        md5.update(var.getBytes(), 0, var.length());
        byte[] digest = md5.digest();
        for (int i = 0; i < digest.length; ++i) {
            strbuf.append(PersonUtil.byte2Hex(digest[i]));
        }
        return strbuf.toString();
    }

    private static String byte2Hex(byte b) {
        int value = (b & 0x7F) + (b < 0 ? 128 : 0);
        return (value < 16 ? "0" : "") + Integer.toHexString(value).toLowerCase();
    }
}

