/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.sHR.util;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSAUtils {
    public static KeyPair genKeyPair() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(1024);
        return kpg.genKeyPair();
    }

    public static PrivateKey restorePrivateKey(byte[] bytes) throws Exception {
        PKCS8EncodedKeySpec pkcs = new PKCS8EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(pkcs);
    }

    public static PublicKey restorePublicKey(byte[] bytes) throws Exception {
        X509EncodedKeySpec pkcs = new X509EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(pkcs);
    }

    public static byte[] encrypt(byte[] src, PublicKey pubKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, pubKey);
        return cipher.doFinal(src);
    }

    public static byte[] deEncrypt(byte[] dest, PrivateKey prvKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, prvKey);
        return cipher.doFinal(dest);
    }

    public static byte[] sign(byte[] src, PrivateKey prvKey) throws Exception {
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initSign(prvKey);
        sig.update(src);
        return sig.sign();
    }

    public static boolean verifySign(byte[] src, byte[] dest, PublicKey pubKey) throws Exception {
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initVerify(pubKey);
        sig.update(src);
        return sig.verify(dest);
    }

    public static void main(String[] args) {
        try {
            KeyPair kp = RSAUtils.genKeyPair();
            PublicKey pub1 = kp.getPublic();
            PrivateKey prv1 = kp.getPrivate();
            byte[] pubbts1 = pub1.getEncoded();
            byte[] prvbts1 = prv1.getEncoded();
            System.out.println("pubkey format=" + pub1.getFormat());
            System.out.println("prvkey format=" + prv1.getFormat());
            PublicKey pub2 = RSAUtils.restorePublicKey(pubbts1);
            PrivateKey prv2 = RSAUtils.restorePrivateKey(prvbts1);
            String src = "this is a test";
            byte[] signed = RSAUtils.sign(src.getBytes(), prv1);
            boolean v = RSAUtils.verifySign(src.getBytes(), signed, pub2);
            System.out.println("v=" + v);
            byte[] encrypt = RSAUtils.encrypt(src.getBytes(), pub1);
            String src2 = new String(RSAUtils.deEncrypt(encrypt, prv2));
            System.out.println("src2=" + src2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

