/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.WebContext;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.base.myeas.IMyEasInvokeEntry;
import com.kingdee.eas.base.myeas.MyEasInvokeEntryFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.util.LoginUtil;
import com.kingdee.shr.base.syssetting.context.IContextProvider;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.context.ShrWebContextUtil;
import com.kingdee.shr.base.syssetting.context.WebContextUtil;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.SystemContextUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jasig.cas.client.authentication.AttributePrincipal;

public class DefaultContextProvider
implements IContextProvider {
    protected Logger logger = Logger.getLogger(DefaultContextProvider.class);

    @Override
    public SHRContext getSHRContext(ServletContext context, ServletRequest req, ServletResponse res) throws SHRWebException {
        AttributePrincipal principal;
        SHRContext ctx = new SHRContext(context, req, res);
        HttpServletRequest request = (HttpServletRequest)req;
        Context userCtx = WebContextUtil.getEasContext(request);
        if (userCtx == null && (principal = (AttributePrincipal)request.getUserPrincipal()) != null) {
            Map attributes = principal.getAttributes();
            userCtx = LoginUtil.createEasContext((String)request.getRemoteUser(), (Map)attributes, (HttpServletRequest)request);
            if (userCtx != null) {
                String userId = userCtx.getCaller().toString();
                String skin = this.getUserSkin(request, userId);
                ctx.getSessionContext().put("skin", skin);
            }
        }
        if (userCtx != null) {
            ctx.getSessionContext().put("WafLocale", userCtx.getLocale());
            if (userCtx.get((Object)"dbType") == null) {
                String value = SystemContextUtil.getDbTypeByDataCenter((String)userCtx.getAIS());
                userCtx.put((Object)"dbType", (Object)value);
                System.out.println("bos Context's dbType is null, set context dbType again. dbType value:" + value + ",stackTrace:" + Thread.currentThread().getStackTrace());
            }
            ContextUtils.setLocaleToThread((Locale)userCtx.getLocale());
        }
        ShrWebContextUtil.initRpcParams(userCtx);
        ctx.setContext(userCtx);
        ctx.getSessionContext().put("context", ctx.getContext());
        ctx.setSupportMultiLang(this.checkSupportMultiLang());
        request.getSession().setAttribute("shr_context", (Object)ctx);
        return ctx;
    }

    private boolean checkSupportMultiLang() {
        String supportMultiLangValue = SHRContext.getInstance().getServletContext().getInitParameter("com.kingdee.bos.webframework.SUPPORT_MULTILANG");
        if (supportMultiLangValue != null && supportMultiLangValue.length() <= 0) {
            return false;
        }
        boolean isSupportMultiLang = Boolean.parseBoolean(supportMultiLangValue);
        return isSupportMultiLang;
    }

    private String getUserSkin(HttpServletRequest request, String userId) {
        String skin = "waf";
        try {
            Context easContext = WebContextUtil.getEasContext(request);
            IMyEasInvokeEntry iMyEas = MyEasInvokeEntryFactory.getRemoteInstance();
            HashMap map = iMyEas.getMyEasSetting(userId);
            String uiStyleID = (String)map.get("uiStyle");
            String skinPath = WebContextUtil.getSkinPath(uiStyleID);
            if ("/skin/02".equals(skinPath) || "/skin/03".equals(skinPath) || "/skin/04".equals(skinPath)) {
                // empty if block
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("user skin path:" + skinPath));
            }
        }
        catch (EASBizException e) {
            this.logger.error((Object)"get user skin error!", (Throwable)e);
        }
        catch (BOSException e) {
            this.logger.error((Object)"get user skin error!", (Throwable)e);
        }
        return skin;
    }
}

