/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.component.commonquery;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.SelectException;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;

public class CommonQueryHelper {
    private static Logger logger = Logger.getLogger(CommonQueryHelper.class);

    public static SelectItem[] getLeftBracketItems(String enumClassName) {
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        selectItemList.add(new SelectItem((Object)"BLANK", ""));
        List enumList = MetaDataUtil.getEnumList((String)enumClassName);
        for (Enum enumElement : enumList) {
            String name = enumElement.getName();
            String alias = enumElement.getAlias();
            SelectItem selectItem = new SelectItem((Object)name, alias);
            selectItemList.add(selectItem);
        }
        return selectItemList.toArray(new SelectItem[0]);
    }

    public static QueryInfo getQueryInfo(Context ctx, IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getQuery(queryPK);
    }

    public static QueryInfo getQueryInfo(Context ctx, String query) throws SHRWebException {
        try {
            QueryInfo info = CommonQueryHelper.getQueryInfo(ctx, (IMetaDataPK)MetaDataPK.create((String)query));
            return info;
        }
        catch (Exception e) {
            String errorMsg = MessageFormat.format("queryPk={0}", query);
            logger.error((Object)errorMsg, (Throwable)e);
            throw new SHRWebException(errorMsg, e);
        }
    }

    public static BOSUuid getCurrentUserId(Context ctx) {
        return ContextUtil.getCurrentUserInfo((Context)ctx).getId();
    }

    public static BOSUuid getOrgID(Context ctx, QueryInfo queryInfo) {
        BOSUuid orgID = null;
        try {
            String orgType = null;
            if (CommonQueryHelper.getOrgType(queryInfo) != null) {
                orgType = CommonQueryHelper.getOrgType(queryInfo).getName();
            }
            if (orgType != null) {
                if ("Admin".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentAdminUnit((Context)ctx).getId();
                } else if ("ControlUnit".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
                } else if ("NONE".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
                }
            } else {
                orgID = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            orgID = null;
        }
        return orgID;
    }

    public static String getOrgIDString(Context ctx, QueryInfo queryInfo) {
        try {
            BOSUuid id = CommonQueryHelper.getOrgID(ctx, queryInfo);
            if (id != null) {
                return id.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static OrgType getOrgType(QueryInfo queryInfo) {
        OrgType orgType = null;
        try {
            EntityObjectInfo eo;
            String orgTypeStr;
            SubObjectInfo main = queryInfo.getMainObject();
            if (main instanceof SubQueryInfo) {
                main = ((SubQueryInfo)main).getQueryRef().getMainObject();
            }
            if ((orgTypeStr = (eo = ((SubEntityInfo)main).getEntityRef()).getExtendedProperty("OrgType")) != null) {
                if ("Admin".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Admin;
                } else if ("ControlUnit".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.ControlUnit;
                } else if ("HRO".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.HRO;
                } else if ("NONE".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.NONE;
                }
            } else {
                orgType = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            orgType = null;
        }
        return orgType;
    }

    public static EntityViewInfo getQuerySolutionViewInfo(String queryName, String parentPageName, BOSUuid orgID, BOSUuid userID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("queryObjectName", (Object)queryName));
        filter.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentPageName));
        filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)String.valueOf(1)));
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        FilterItemInfo filterItemInfo = new FilterItemInfo("owner", (Object)userID);
        filter.getFilterItems().add(filterItemInfo);
        filter.setMaskString(" #0 AND #1 AND #2 AND #3 AND #4  ");
        viewInfo.setFilter(filter);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.getSorter().decode("order by name");
        viewInfo.setSorter(sorterItemCollection);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)CommonQueryHelper.getSelectorItemCollection());
        return viewInfo;
    }

    private static SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.id"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        return sic;
    }

    public static QuerySolutionInfo getDefaultSolution(QuerySolutionCollection col) {
        if (col == null) {
            return null;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            if (!col.get(i).getSolutionType().getValue().equals("10")) continue;
            return col.get(i);
        }
        return null;
    }

    public static QuerySolutionInfo addNewDefaultSolution(Context ctx, String queryObjectName, BOSUuid orgID, String parentPageName, boolean isDefault) throws Exception {
        QuerySolutionInfo solutionInfo = CommonQueryHelper.createSysDefaultSolutionInfo(ctx, queryObjectName, orgID, parentPageName);
        solutionInfo.setIsUserDefaultSolu(isDefault);
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        iQuerySolution.addnew((CoreBaseInfo)solutionInfo);
        return solutionInfo;
    }

    public static QuerySolutionInfo createSysDefaultSolutionInfo(Context ctx, String queryObjectName, BOSUuid orgID, String parentPageName) throws Exception {
        QuerySolutionInfo solutionInfo = new QuerySolutionInfo();
        solutionInfo.setId(BOSUuid.create((String)"F93E381C"));
        solutionInfo.setOwner(CommonQueryHelper.getCurrentUserId(ctx));
        solutionInfo.setQueryObjectName(queryObjectName);
        solutionInfo.setOrgID(orgID);
        solutionInfo.setShareType(ShareTypeEnum.USER_LEVEL);
        solutionInfo.setParentUIName(parentPageName);
        QueryPanelCollection queryPanelCol = new QueryPanelCollection();
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        queryPanelCol.add(queryPanelInfo);
        solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
        solutionInfo.setName(CommonQueryHelper.getMessage("defaultSolution"));
        solutionInfo.setName(CommonQueryHelper.getMessage("defaultSolution"), new Locale("l1"));
        solutionInfo.setName(CommonQueryHelper.getMessage("defaultSolution"), new Locale("l2"));
        solutionInfo.setName(CommonQueryHelper.getMessage("defaultSolution"), new Locale("l3"));
        solutionInfo.setRowCount(-1);
        solutionInfo.setIsUserDefaultSolu(true);
        solutionInfo.setSolutionType(SolutionTypeEnum.SYSTEM_SOLUTION);
        return solutionInfo;
    }

    public static void justOneDefaultSolutionVisible(QuerySolutionCollection soluctionCol) {
        if (soluctionCol != null) {
            int defalutSCount = 0;
            for (int i = 0; i < soluctionCol.size(); ++i) {
                QuerySolutionInfo solutionInfo = soluctionCol.get(i);
                if (solutionInfo.getSolutionType() != SolutionTypeEnum.SYSTEM_SOLUTION || ++defalutSCount <= 1) continue;
                soluctionCol.remove(solutionInfo);
                --defalutSCount;
                --i;
            }
        }
    }

    public static QuerySolutionInfo getNeedDisplaySolution(QuerySolutionCollection col, BOSUuid userID) {
        QuerySolutionInfo defaultSolution = null;
        QuerySolutionInfo userDefaultSolution = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            if (col.get(i).getSolutionType().getValue().equals("10")) {
                defaultSolution = col.get(i);
            }
            if (!col.get(i).isIsUserDefaultSolu()) continue;
            userDefaultSolution = col.get(i);
        }
        if (userDefaultSolution != null && userID.equals((Object)userDefaultSolution.getOwner())) {
            return userDefaultSolution;
        }
        return defaultSolution;
    }

    public static ArrayList getConditionList(QueryInfo queryInfo) {
        ArrayList<QueryFieldInfo> target = new ArrayList<QueryFieldInfo>();
        PropertyUnitCollection propertyUnitCol = queryInfo.getUnits();
        int size = propertyUnitCol.size();
        for (int i = 0; i < size; ++i) {
            if (!(propertyUnitCol.get(i) instanceof QueryFieldInfo)) continue;
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)propertyUnitCol.get(i);
            boolean isFilter = false;
            String temp = queryFieldInfo.getExtendedProperty("isCommonQueryFilter");
            if (temp != null && !temp.trim().equalsIgnoreCase("")) {
                isFilter = Boolean.valueOf(temp);
            }
            if (!isFilter) continue;
            target.add(queryFieldInfo);
        }
        return target;
    }

    public static CompareType convert(String compareOp) {
        return CompareType.getEnum((String)compareOp);
    }

    public static EntityViewInfo MergeCommonQuery(EntityViewInfo mergeFilter, EntityViewInfo fromFilter) throws Exception {
        if (mergeFilter == null) {
            return fromFilter;
        }
        if (FilterUtility.hasFilterItem((FilterInfo)mergeFilter.getFilter())) {
            mergeFilter.getFilter().mergeFilter(fromFilter.getFilter(), "AND");
        } else {
            FilterInfo filterInfo = fromFilter.getFilter();
            mergeFilter.setFilter((FilterInfo)filterInfo.clone());
        }
        return mergeFilter;
    }

    public static String getMessage(String key) throws SHRWebException {
        try {
            String res = "";
            for (Class clz = CommonQueryHelper.class; clz != null; clz = clz.getSuperclass()) {
                ResourceBundle resBundle = CommonQueryHelper.getResourceBundle(clz.getName());
                if (resBundle == null) continue;
                try {
                    res = resBundle.getString(key);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return res;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static ResourceBundle getResourceBundle(String className) throws SHRWebException {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(className, CommonQueryHelper.getLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resourceBundle;
    }

    public static Locale getLocale() throws SHRWebException {
        return SHRContext.getInstance().getContext().getLocale();
    }

    public static PropertyUnitInfo getPropertyUnitInfo(Context ctx, String queryPk, String fieldName) throws SHRWebException {
        if (StringUtils.isEmpty((String)queryPk) || StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        QueryInfo queryInfo = null;
        PropertyUnitInfo qfi = null;
        try {
            queryInfo = CommonQueryHelper.getQueryInfo(ctx, queryPk);
            if (null == queryInfo) {
                return null;
            }
            QuerySelect select = new QuerySelect(queryPk);
            String[] queryItems = new String[]{"displayName", "returnType", "isSelector", "isFilter", "isSorter"};
            select.selectHeaderSelectorFields().propertyUnitSelect().select(new String[]{"*"}, queryItems, ctx.getOriginLocale()).extendPropertySelect().select("*");
            PropertyUnitCollection puc = queryInfo.getUnits();
            int total = puc.size();
            for (int i = 0; i < total; ++i) {
                qfi = puc.get(i);
                if (!fieldName.equals(qfi.getName())) continue;
                return qfi;
            }
        }
        catch (SelectException e) {
            throw new SHRWebException(e);
        }
        return null;
    }

    public static PropertyRefInfo getPropertyRefInfo(Context ctx, String queryPk, String fieldName) throws SHRWebException {
        if (StringUtils.isEmpty((String)queryPk) || StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        QueryInfo queryInfo = null;
        PropertyUnitInfo qfi = null;
        PropertyRefInfo propertyRefInfo = null;
        try {
            queryInfo = CommonQueryHelper.getQueryInfo(ctx, queryPk);
            if (null == queryInfo) {
                return null;
            }
            QuerySelect select = new QuerySelect(queryPk);
            String[] queryItems = new String[]{"displayName", "returnType", "isSelector", "isFilter", "isSorter"};
            select.selectHeaderSelectorFields().propertyUnitSelect().select(new String[]{"*"}, queryItems, ctx.getOriginLocale()).extendPropertySelect().select("*");
            PropertyUnitCollection puc = queryInfo.getUnits();
            int total = puc.size();
            for (int i = 0; i < total; ++i) {
                qfi = puc.get(i);
                if (!fieldName.equals(qfi.getName())) continue;
                if (queryInfo instanceof UnionQueryInfo) {
                    if (null != qfi.getPropertyRefs().get(0).getRefUnit()) {
                        if (null != qfi.getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0) && null != qfi.getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0).getSubEntity() && null != qfi.getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0).getRefProperty()) {
                            propertyRefInfo = qfi.getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0);
                        } else if (null != qfi.getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0) && null != qfi.getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0).getRefUnit() && null != qfi.getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0).getSubEntity()) {
                            propertyRefInfo = qfi.getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0);
                        }
                    }
                } else {
                    propertyRefInfo = queryInfo instanceof JoinQueryInfo ? qfi.getPropertyRefs().get(0) : qfi.getPropertyRefs().get(0);
                }
                return propertyRefInfo;
            }
        }
        catch (SelectException e) {
            throw new SHRWebException(e);
        }
        return null;
    }
}

