/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.component.commonquery;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;

public class CommonQueryUtils {
    protected static final String F7_TYPE = "F7";
    public static final String TextType = "0";
    public static final String EnumType = "1";
    public static final String DateType = "2";
    public static final String F7Type = "3";
    public static final String IntType = "4";
    protected static final String SIMPLE_ENTITY_TYPE = "SIMPLE_ENTITY";
    private static final String DEFAULT_F7_QUERY = "defaultF7Query";
    private static final String F7_DISPLAY_FORMAT = "displayFormat";
    private static final String F7_EDIT_FORMAT = "editFormat";
    private static final String F7_COMMIT_FORMAT = "commitFormat";

    public static boolean isEnumType(String typeName) {
        return typeName.equalsIgnoreCase(DataType.ENUM.getName());
    }

    public static boolean isBooleanType(String typeName) {
        return typeName.equalsIgnoreCase(DataType.BOOLEAN.getName());
    }

    public static boolean isIntType(String typeName) {
        return typeName.equals(DataType.SHORT.getName()) || typeName.equals(DataType.INTEGER.getName()) || typeName.equals(DataType.LONG.getName()) || typeName.equals(DataType.FLOAT.getName()) || typeName.equals(DataType.DOUBLE.getName()) || typeName.equals(DataType.DECIMAL.getName());
    }

    public static boolean isDateType(String typeName) {
        return typeName.equalsIgnoreCase(DataType.DATE.getName()) || typeName.equalsIgnoreCase(DataType.TIMESTAMP.getName()) || typeName.equalsIgnoreCase(DataType.TIME.getName());
    }

    public static boolean isF7Type(String typeName) {
        return typeName.equalsIgnoreCase(F7_TYPE);
    }

    public static boolean isSimpleEntityType(String typeName) {
        return typeName.equalsIgnoreCase(SIMPLE_ENTITY_TYPE);
    }

    public static String getf7(Context ctx, String f7ConditonValue, QueryInfo mainQueryInfo, String entityName) {
        PropertyUnitCollection propertyUnitCollection = mainQueryInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo)) continue;
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i);
            if (!f7ConditonValue.toLowerCase().equalsIgnoreCase(queryFieldInfo.getName())) continue;
            String defaultF7 = CommonQueryUtils.getDefaultF7Query(queryFieldInfo);
            if (defaultF7 == null || defaultF7.trim().equalsIgnoreCase("")) {
                defaultF7 = CommonQueryUtils.getDefaultF7Query(ctx, (IMetaDataPK)new MetaDataPK(entityName));
            }
            return defaultF7;
        }
        return "";
    }

    public static String getDefaultF7Query(QueryFieldInfo queryFieldInfo) {
        return queryFieldInfo.getExtendedProperty(DEFAULT_F7_QUERY);
    }

    public static String getDefaultF7Query(Context ctx, IMetaDataPK entityPK) {
        return CommonQueryUtils.getEntity(ctx, entityPK).getExtendedProperty(DEFAULT_F7_QUERY);
    }

    public static EntityObjectInfo getEntity(Context ctx, IMetaDataPK entityPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getEntity(entityPK);
    }

    public static String getF7DisplayFormat(QueryInfo queryInfo, String queryFieldName) {
        String defaultFormat = "$number$;$name$";
        QueryFieldInfo queryFieldInfo = CommonQueryUtils.getQueryFieldInfo(queryInfo, queryFieldName);
        String textField = queryFieldInfo.getExtendedProperty(F7_DISPLAY_FORMAT);
        if (textField == null || textField.trim().equalsIgnoreCase("")) {
            textField = defaultFormat;
        }
        return textField;
    }

    public static String getF7EditFormat(QueryInfo queryInfo, String queryFieldName) {
        QueryFieldInfo queryFieldInfo = CommonQueryUtils.getQueryFieldInfo(queryInfo, queryFieldName);
        String textField = queryFieldInfo.getExtendedProperty(F7_EDIT_FORMAT);
        if (textField == null || textField.trim().equalsIgnoreCase("")) {
            textField = "$" + CommonQueryUtils.getEntityPropertyName(queryInfo, queryFieldName) + "$";
        }
        return textField;
    }

    protected static String getEntityPropertyName(QueryInfo queryInfo, String queryFieldName) {
        return QueryUtils.getEntityPropertyName((QueryInfo)queryInfo, (String)queryFieldName);
    }

    public static String getF7CommitFormat(QueryInfo queryInfo, String queryFieldName) {
        String defaultFormat = "$number$;$name$";
        QueryFieldInfo queryFieldInfo = CommonQueryUtils.getQueryFieldInfo(queryInfo, queryFieldName);
        String textField = queryFieldInfo.getExtendedProperty(F7_COMMIT_FORMAT);
        if (textField == null || textField.trim().equalsIgnoreCase("")) {
            textField = defaultFormat;
        }
        return textField;
    }

    protected static QueryFieldInfo getQueryFieldInfo(QueryInfo queryInfo, String queryFieldName) {
        QueryFieldInfo queryFieldInfo = new QueryFieldInfo();
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo) || !(queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i)).getName().equalsIgnoreCase(queryFieldName)) continue;
            return queryFieldInfo;
        }
        return queryFieldInfo;
    }

    public static Object getEnumValue(Enum enumValue) {
        Object value = null;
        if (enumValue instanceof BooleanEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof IntEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof FloatEnum) {
            value = String.valueOf(((FloatEnum)enumValue).getValue());
        } else if (enumValue instanceof DoubleEnum) {
            value = String.valueOf(((DoubleEnum)enumValue).getValue());
        } else if (enumValue instanceof LongEnum) {
            value = String.valueOf(((LongEnum)enumValue).getValue());
        } else if (enumValue instanceof StringEnum) {
            value = ((StringEnum)enumValue).getValue();
        }
        return value;
    }
}

