/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.context;

import com.kingdee.bos.Context;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ShrWebContextUtil {
    private static Logger logger = Logger.getLogger(ShrWebContextUtil.class);
    public static final String LOCAL_RPC_ADDRESS = "tcp://127.0.0.1:";
    public static final String APP_SERVER_TYPE_APUSIC = "apusic";
    private static final String RPCURL = "RPCUrl";

    public static void initRpcParams(Context ctx) {
        if (ctx == null) {
            return;
        }
        String sessionid = ctx.getContextID();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("*************now init rp params:sessionid:" + ctx.get((Object)"SessionId") + ",contextId:" + ctx.getContextID() + ",rpcUrl:" + System.getProperty(RPCURL)));
        }
        ShrWebContextUtil.initRpcInnerParams(ctx, sessionid);
    }

    public static void initRpcInnerParams(Context ctx, String sessionid) {
        HashMap<String, String> envContext = new HashMap<String, String>();
        if (System.getProperty(RPCURL) != null) {
            envContext.put("URL", System.getProperty(RPCURL));
        } else {
            String serverType = System.getProperty("APP_SERVER_TYPE");
            if (serverType != null && serverType.equalsIgnoreCase(APP_SERVER_TYPE_APUSIC)) {
                envContext.put("URL", "[LOCAL]");
            } else {
                envContext.put("URL", LOCAL_RPC_ADDRESS + ORMRPConfig.getTcpConnectionPort());
            }
        }
        if (envContext.get("URL").equals("[LOCAL]")) {
            envContext.put("BOSCTX", (String)ctx);
        } else {
            envContext.put("SESSIONID", sessionid);
        }
        GeniusBOSFactory.setEnvContext(envContext);
    }
}

