/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.context;

import com.kingdee.bos.Context;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.eas.cp.common.web.util.WebContext;
import com.kingdee.eas.portal.web.configuration.PortalConfig;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class WebContextUtil {
    private static Logger logger = Logger.getLogger(WebContextUtil.class);
    public static final String LOCAL_RPC_ADDRESS = "tcp://127.0.0.1:";
    public static final String APP_SERVER_TYPE_APUSIC = "apusic";
    private static final String RPCURL = "RPCUrl";
    public static final String SSO_LOGOUT_TURN = "easssologout";
    public static final String EAS_SESSIONID_PARMNAME = "easSessionId";
    public static final String EAS_SESSIONID_KEY = "SessionId";
    private static final String SKINPATHITEM = "defaultColorStyle";
    private static final String SKINPATH = "skinPath";
    private static final String DEFAULTPATH = "/skin/01";
    private static final String SIMPLE_STRING = "_simple";

    public static Context getEasContext(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Context ctx = (Context)session.getAttribute("pureWebContext");
        if (ctx != null) {
            return ctx;
        }
        return WebContextUtil.getRealSHRContext(request);
    }

    public static Context getRealSHRContext(HttpServletRequest request) {
        long currentTime = System.currentTimeMillis();
        WebContext webContext = WebContextUtil.getWebContext(request);
        Context ctx = null;
        if (webContext != null) {
            String sessionID = webContext.getSessionId();
            try {
                ctx = SessionManager.getInstance().getSession(sessionID).getContext();
            }
            catch (Exception e) {
                logger.info((Object)("[SessionManager.getInstance().getSession(sessionID).getContext() exception , message is : " + e.getMessage()));
            }
        } else {
            logger.info((Object)" getWebContext by session.getAttribute(easWebContextSessionId), webContext return null");
        }
        return ctx;
    }

    public static WebContext getWebContext(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebContext webContext = (WebContext)session.getAttribute("easWebContextSessionId");
        return webContext;
    }

    public static void initRpcParams(Context ctx) {
        if (ctx == null) {
            return;
        }
        String sessionid = ctx.getContextID();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("*************now init rp params:sessionid:" + ctx.get((Object)EAS_SESSIONID_KEY) + ",contextId:" + ctx.getContextID() + ",rpcUrl:" + System.getProperty(RPCURL)));
        }
        WebContextUtil.initRpcInnerParams(ctx, sessionid);
    }

    public static void initRpcInnerParams(Context ctx, String sessionid) {
        HashMap<String, String> envContext = new HashMap<String, String>();
        if (System.getProperty(RPCURL) != null) {
            envContext.put("URL", System.getProperty(RPCURL));
        } else {
            String serverType = System.getProperty("APP_SERVER_TYPE");
            if (serverType != null && serverType.equalsIgnoreCase(APP_SERVER_TYPE_APUSIC)) {
                envContext.put("URL", "[LOCAL]");
            } else {
                envContext.put("URL", LOCAL_RPC_ADDRESS + ORMRPConfig.getTcpConnectionPort());
            }
        }
        if (envContext.get("URL").equals("[LOCAL]")) {
            envContext.put("BOSCTX", (String)ctx);
        } else {
            envContext.put("SESSIONID", sessionid);
        }
        GeniusBOSFactory.setEnvContext(envContext);
    }

    public static String getSkinPath(String uiStyleID) {
        String skinPath = "";
        if (StringUtils.isEmpty((String)uiStyleID)) {
            return WebContextUtil.getDefaultSkinPathFull();
        }
        skinPath = uiStyleID.equals("01b278d3-00fd-1000-e000-0005c0a813b2A8506915") ? "/skin/02" : (uiStyleID.equals("01b278d3-00fd-1000-e000-0004c0a813b2A8506915") ? "/skin/03" : (uiStyleID.equals("01b278d3-00fd-1000-e000-0006c0a813b2A8506915") ? DEFAULTPATH : (uiStyleID.equals("01b278d3-00fd-1000-e000-0003c0a813b2A8506915") ? "/skin/04" : WebContextUtil.getDefaultSkinPath())));
        return skinPath;
    }

    public static String getDefaultSkinPathFull() {
        String defaultSkinPath = null;
        ConfigurationItem configItem = PortalConfig.getConfiguration().getConfigItem(SKINPATHITEM);
        defaultSkinPath = configItem == null ? DEFAULTPATH : configItem.getProperty(SKINPATH);
        if (StringUtils.isEmpty((String)defaultSkinPath)) {
            defaultSkinPath = DEFAULTPATH;
        }
        if (defaultSkinPath.indexOf(SIMPLE_STRING) >= 0) {
            defaultSkinPath = DEFAULTPATH;
        }
        return defaultSkinPath;
    }

    public static String getDefaultSkinPath() {
        String defaultSkinPath = null;
        ConfigurationItem configItem = PortalConfig.getConfiguration().getConfigItem(SKINPATHITEM);
        if (configItem == null) {
            defaultSkinPath = DEFAULTPATH;
        }
        if (configItem != null) {
            defaultSkinPath = configItem.getProperty(SKINPATH);
        }
        defaultSkinPath = !StringUtils.isEmpty((String)defaultSkinPath) ? DEFAULTPATH : DEFAULTPATH;
        return defaultSkinPath;
    }
}

