/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.core.view;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.action.WebAction;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.IMetadataSupport;
import com.kingdee.shr.base.syssetting.core.WebPageController;
import com.kingdee.shr.base.syssetting.core.view.IEditController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.util.FieldPermissionHelper;
import com.kingdee.shr.base.syssetting.util.NetCtrlHelper;
import com.kingdee.shr.base.syssetting.util.NumberRuleHelper;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

public abstract class EditController
extends WebPageController
implements IEditController,
IMetadataSupport {
    protected Logger logger = Logger.getLogger(this.getClass());
    protected static final String MODEL_ATTRIBUTE_KEY = "model";
    public static final String UI_OPERATEPARAM_KEY = "operateState";
    public static final String UI_STATUS_ADDNEW = "addnew";
    public static final String UI_STATUS_EDIT = "edit";
    public static final String UI_STATUS_VIEW = "view";
    public static final String FIELD_PERMISSION_SCRIPT = "fieldPermissionProcessScript";

    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String redirectUrl;
        String operateStatus = request.getParameter(UI_OPERATEPARAM_KEY);
        String modelID = request.getParameter("modelID");
        if (modelID == null) {
            String billId;
            modelID = billId = request.getParameter("billId");
        }
        if (!(operateStatus != null && operateStatus.length() > 0 || modelID != null && modelID.length() > 0)) {
            operateStatus = UI_STATUS_ADDNEW;
        }
        if (operateStatus == null || operateStatus.length() <= 0) {
            redirectUrl = request.getRequestURI();
            redirectUrl = redirectUrl + "?";
            redirectUrl = redirectUrl + "method=initalize";
            redirectUrl = redirectUrl + "&operateState=";
            redirectUrl = redirectUrl + (modelID == null ? UI_STATUS_ADDNEW : UI_STATUS_VIEW);
            redirectUrl = redirectUrl + "&billId=" + URLEncoder.encode(modelID);
            redirectUrl = redirectUrl + "&conversationid=" + this.getConversationID();
            try {
                response.sendRedirect(SHRCheck.checkUrlParamsForSendRedirect((String)redirectUrl));
            }
            catch (Exception exception) {
                throw new SHRWebException(exception);
            }
            return null;
        }
        request.setAttribute(UI_OPERATEPARAM_KEY, (Object)operateStatus);
        redirectUrl = super.initalizeAction(request, response, modelMap);
        HashMap actionSet = this.getActionManager().getActionSet();
        for (String key : actionSet.keySet()) {
            WebAction webAction = (WebAction)actionSet.get(key);
            if (key.equalsIgnoreCase("save") || key.equalsIgnoreCase("submit") || key.equalsIgnoreCase("saveAndAddNew")) {
                if (operateStatus.equalsIgnoreCase(UI_STATUS_VIEW)) {
                    webAction.setVisible(false);
                    continue;
                }
                webAction.setVisible(true);
                continue;
            }
            if (!key.equalsIgnoreCase(UI_STATUS_EDIT)) continue;
            if (!operateStatus.equalsIgnoreCase(UI_STATUS_VIEW)) {
                webAction.setVisible(false);
                continue;
            }
            webAction.setVisible(true);
        }
        this.doFieldPermission(request, (IObjectValue)this.getEditModel(request, response, modelMap));
        return redirectUrl;
    }

    @Override
    protected void initalizeCompnentActionBind() throws SHRWebException {
    }

    protected String getMainOrgId() {
        String orgId;
        OrgUnitInfo mainOrg = this.getMainOrgInfo();
        String string = orgId = mainOrg == null ? "" : mainOrg.getString("id");
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        return orgId;
    }

    @Override
    public String loadAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        CoreBaseInfo infoObj = this.initModel(request, response, modelMap);
        modelMap.addAttribute(MODEL_ATTRIBUTE_KEY, (Object)infoObj);
        return super.loadAction(request, response, modelMap);
    }

    @Override
    public String closeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        CoreBaseInfo editModel;
        String modelID = request.getParameter("modelID");
        if ((modelID == null || modelID.length() <= 0) && (editModel = this.getEditModel(request, response, modelMap)) != null && editModel.getId() != null) {
            modelID = editModel.getId().toString();
        }
        try {
            if (modelID != null && modelID.length() > 0) {
                NetCtrlHelper.releaseObjIDForUpdate(modelID);
            }
        }
        catch (BOSException bosException) {
            throw new ShrWebBizException(bosException.getMessage());
        }
        return super.closeAction(request, response, modelMap);
    }

    protected CoreBaseInfo initModel(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        String status = request.getParameter(UI_OPERATEPARAM_KEY);
        String modelID = request.getParameter("modelID");
        if (modelID == null) {
            modelID = request.getParameter("billId");
        }
        if (modelID == null && status == null) {
            status = UI_STATUS_ADDNEW;
        }
        CoreBaseInfo model = (CoreBaseInfo)modelMap.get((Object)MODEL_ATTRIBUTE_KEY);
        if (status.equalsIgnoreCase(UI_STATUS_ADDNEW)) {
            model = this.createNewModel(request, response, modelMap);
            this.setAutoNumber((IObjectValue)model, this.getMainOrgId());
        } else {
            if (status.equalsIgnoreCase(UI_STATUS_EDIT)) {
                try {
                    System.out.println("start get data:" + System.currentTimeMillis());
                    model = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(modelID), this.getSelectors());
                    System.out.println("end get data:" + System.currentTimeMillis());
                    NetCtrlHelper.requestObjIDForUpdate(model.getId().toString());
                }
                catch (EASBizException e) {
                    throw new ShrWebBizException(e);
                }
                catch (BOSException e) {
                    throw new SHRWebException(e);
                }
            }
            if (status.equalsIgnoreCase(UI_STATUS_VIEW)) {
                try {
                    model = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(modelID), this.getSelectors());
                }
                catch (EASBizException e) {
                    throw new ShrWebBizException(e);
                }
                catch (BOSException e) {
                    throw new SHRWebException(e);
                }
            }
        }
        this.getSession().put(MODEL_ATTRIBUTE_KEY, model);
        return model;
    }

    protected void setAutoNumber(IObjectValue model, String mainOrgID) throws SHRWebException, ShrWebBizException {
        NumberRuleHelper.codingNumber(model, model, mainOrgID);
    }

    @Override
    public String previewItemAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, @ModelAttribute(value="model") CoreBaseInfo model) throws SHRWebException, ShrWebBizException {
        return null;
    }

    @Override
    public String nextItemAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, @ModelAttribute(value="model") CoreBaseInfo model) throws SHRWebException, ShrWebBizException {
        return null;
    }

    @Override
    public String editAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, @ModelAttribute(value="model") CoreBaseInfo model) throws SHRWebException, ShrWebBizException {
        return null;
    }

    protected void beforeSubmit(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, CoreBaseInfo model) throws ShrWebBizException {
    }

    protected void afterSubmit(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, @ModelAttribute(value="model") CoreBaseInfo model) throws ShrWebBizException {
    }

    @Override
    public String submitAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, @ModelAttribute(value="model") CoreBaseInfo model) throws SHRWebException, ShrWebBizException {
        CoreBaseInfo editModel = model;
        try {
            this.verifyModel(model);
            this.beforeSubmit(request, response, modelMap, editModel);
            IObjectPK objectPK = this.getBizInterface().submit(editModel);
            editModel.setId(BOSUuid.read((String)objectPK.toString()));
            this.afterSubmit(request, response, modelMap, editModel);
            JSONUtils.SUCCESS(model.getId().toString());
        }
        catch (Exception e) {
            JSONUtils.ERROR(e.getMessage(), e);
        }
        return null;
    }

    protected void beforeSave(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, CoreBaseInfo model) throws ShrWebBizException {
    }

    protected void afterSave(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, CoreBaseInfo model) throws ShrWebBizException {
    }

    protected void verifyModel(CoreBaseInfo model) throws ShrWebBizException, SHRWebException {
    }

    @Override
    public String saveAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, @ModelAttribute(value="model") CoreBaseInfo model) throws SHRWebException, ShrWebBizException {
        try {
            this.verifyModel(model);
            this.beforeSave(request, response, modelMap, model);
            IObjectPK objectPK = this.getBizInterface().save(model);
            model.setId(BOSUuid.read((String)objectPK.toString()));
            this.afterSave(request, response, modelMap, model);
            this.getSession().put(MODEL_ATTRIBUTE_KEY, model);
            JSONUtils.SUCCESS(model.getId().toString());
        }
        catch (EASBizException exception) {
            JSONUtils.ERROR(exception.getMessage(), (Exception)((Object)exception));
        }
        catch (BOSException exception) {
            JSONUtils.ERROR(exception.getMessage(), (Exception)((Object)exception));
        }
        return null;
    }

    @Override
    public String addNewAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, CoreBaseInfo model) throws SHRWebException, ShrWebBizException {
        return null;
    }

    @Override
    public String saveAndAddNewAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, @ModelAttribute(value="model") CoreBaseInfo model) throws SHRWebException, ShrWebBizException {
        return null;
    }

    @Override
    public String printAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, @ModelAttribute(value="model") CoreBaseInfo model) throws SHRWebException, ShrWebBizException {
        return null;
    }

    @Override
    public String exitAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, @ModelAttribute(value="model") CoreBaseInfo model) throws SHRWebException, ShrWebBizException {
        this.getSessionManager().releaseControllerSession(this.getMetadataPK().toString());
        return this.closeAction(request, response, modelMap);
    }

    protected SelectorItemCollection getSelectors() throws SHRWebException {
        SelectorItemCollection selector = new SelectorItemCollection();
        return selector;
    }

    @Override
    public String showListAction() throws SHRWebException, ShrWebBizException {
        return "redirect:" + this.getListURL() + "?" + "method" + "=" + "initalize";
    }

    protected CoreBaseInfo createNewModel(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        Class modelClass = this.getModelType();
        if (modelClass != null) {
            try {
                modelClass.asSubclass(CoreBaseInfo.class);
                return (CoreBaseInfo)modelClass.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    @ModelAttribute(value="model")
    private CoreBaseInfo setupModel(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        CoreBaseInfo editModel = this.getEditModel(request, response, modelMap);
        if (editModel != null) {
            return editModel;
        }
        Class modelClass = this.getModelType();
        if (modelClass != null) {
            try {
                modelClass.asSubclass(CoreBaseInfo.class);
                return (CoreBaseInfo)modelClass.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public CoreBaseInfo getEditModel(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        if (this.getSession().containsKey(MODEL_ATTRIBUTE_KEY)) {
            return (CoreBaseInfo)this.getSession().get(MODEL_ATTRIBUTE_KEY);
        }
        return null;
    }

    @RequestMapping(params={"method=getEntryData"})
    public String getEntryData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        GridDataEntity gridDataEntity = new GridDataEntity();
        String entryName = request.getParameter("entry");
        int rows = Integer.parseInt(request.getParameter("rows"));
        int page = Integer.parseInt(request.getParameter("page"));
        String[] columnModel = request.getParameter("columnModel").split(",");
        AbstractObjectCollection entryColl = (AbstractObjectCollection)this.getEditModel(request, response, modelMap).get(entryName);
        ArrayList records = new ArrayList();
        for (int nIndex = 0; nIndex < entryColl.size(); ++nIndex) {
            CoreBaseInfo info = (CoreBaseInfo)entryColl.getObject(nIndex);
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (String column : columnModel) {
                Object value = null;
                if (info.get(column) != null) {
                    value = info.get(column);
                }
                row.put(column, value);
            }
            records.add(row);
        }
        gridDataEntity.setTotal(1L);
        gridDataEntity.setRecords(entryColl.size());
        gridDataEntity.setRows(records);
        gridDataEntity.setPage(page);
        JSONUtils.writeJson(response, gridDataEntity);
        return null;
    }

    @Override
    public String getImageField(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String property, String imageType) throws SHRWebException, ShrWebBizException {
        if (property == null) {
            return null;
        }
        byte[] fieldContent = this.getImageFieldBytes(request, response, modelMap, property);
        response.setContentType("image/JPEG");
        ServletOutputStream output = null;
        try {
            if (response != null) {
                output = response.getOutputStream();
                ByteArrayInputStream byteInputStream = new ByteArrayInputStream(fieldContent);
                BufferedInputStream bufferInputStream = new BufferedInputStream(byteInputStream);
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                byte[] temp = new byte[1024];
                int size = 0;
                while ((size = bufferInputStream.read(temp)) != -1) {
                    out.write(temp, 0, size);
                }
                bufferInputStream.close();
                byte[] content = out.toByteArray();
                output.write(content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SHRWebException(e);
        }
        finally {
            try {
                if (output != null) {
                    output.flush();
                    output.close();
                }
            }
            catch (Exception ex) {
                this.logger.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    protected byte[] getImageFieldBytes(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String field) throws SHRWebException, ShrWebBizException {
        if (field == null) {
            return null;
        }
        Object fieldValue = this.getEditModel(request, response, modelMap).get(field);
        if (fieldValue instanceof byte[]) {
            return (byte[])fieldValue;
        }
        return null;
    }

    private void doFieldPermission(HttpServletRequest request, IObjectValue model) throws ShrWebBizException, SHRWebException {
        BOSObjectType bizObjectType = model.getBOSType();
        IObjectPK userPK = SHRContext.getInstance().getContext().getCaller();
        ObjectUuidPK orgPK = new ObjectUuidPK(this.getMainOrgInfo().getId());
        StringBuffer fieldPermissionScript = FieldPermissionHelper.doFieldPermission(bizObjectType, userPK, (IObjectPK)orgPK);
        request.setAttribute(FIELD_PERMISSION_SCRIPT, (Object)fieldPermissionScript.toString());
    }

    protected abstract ICoreBase getBizInterface() throws SHRWebException;

    protected abstract String getListURL();

    protected abstract Class getModelType() throws SHRWebException;
}

