/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.permission.button;

import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.api.service.SHRDataPermissionModel;
import com.kingdee.shr.base.permission.api.service.SHRDataPermissionService;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.permission.button.ButtonDataPermissionModelFactory;
import com.kingdee.shr.base.syssetting.util.WafUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.ReflectionUtils;

public abstract class SHRButtonDataPermissionHelper {
    public static void checkButtonDataPermission(HttpServletRequest request) throws SHRWebException {
        String method = request.getParameter("method");
        if (StringUtils.isEmpty((String)method) || "addNew".equals(method)) {
            return;
        }
        String currentRequestPermItemId = (String)request.getAttribute("permItemId");
        if (StringUtils.isEmpty((String)currentRequestPermItemId)) {
            return;
        }
        Context ctx = SHRContext.getInstance().getContext();
        String uipk = request.getParameter("uipk");
        if (StringUtils.isEmpty((String)uipk)) {
            return;
        }
        UIViewInfo viewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
        if (null == viewInfo) {
            return;
        }
        List<SHRDataPermissionModel> model = ButtonDataPermissionModelFactory.build(ctx, viewInfo, request);
        if (null == model || model.isEmpty()) {
            return;
        }
        if (!SHRButtonDataPermissionHelper.invokeBizCheckButtonDataPermission(request)) {
            try {
                SHRDataPermissionService.checkCurrentUserDataPermission((Context)ctx, (String)currentRequestPermItemId, model);
            }
            catch (EASBizException e) {
                throw new SHRWebException(e);
            }
        }
    }

    private static boolean invokeBizCheckButtonDataPermission(HttpServletRequest request) throws SHRWebException {
        String handler = SHRButtonDataPermissionHelper.getHandler(request);
        String methodName = SHRButtonDataPermissionHelper.assembleBizCheckDataPermissionMethodName(request);
        boolean flag = false;
        if (StringUtils.isEmpty((String)handler) || StringUtils.isEmpty((String)methodName)) {
            return flag;
        }
        try {
            Class clazz = MsfClassLoaderFactory.forName((String)handler);
            Method method = ReflectionUtils.findMethod((Class)clazz, (String)methodName, (Class[])new Class[]{HttpServletRequest.class});
            if (null != method) {
                Object object = ReflectionUtils.invokeMethod((Method)method, clazz.newInstance(), (Object[])new Object[]{request});
                flag = Boolean.valueOf(object.toString());
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    private static String assembleBizCheckDataPermissionMethodName(HttpServletRequest request) {
        String methodName = WafUtils.getRequestAction(request);
        if (!StringUtils.isEmpty((String)methodName)) {
            String buttonName = methodName.substring(0, 1).toUpperCase().concat(methodName.substring(1));
            return "check" + buttonName + "DataPermission";
        }
        return "";
    }

    private static String getHandler(HttpServletRequest request) throws SHRWebException {
        UIViewInfo uiViewInfo;
        String handler = request.getParameter("handler");
        if (!StringUtils.isEmpty((String)handler)) {
            return handler;
        }
        String uipk = SHRButtonDataPermissionHelper.getUIPK(request);
        if (!StringUtils.isEmpty((String)uipk) && (uiViewInfo = UIViewUtil.getCurrentUIViewInfo((ServletRequest)request)) != null) {
            return uiViewInfo.getHandler();
        }
        return null;
    }

    private static String getUIPK(HttpServletRequest request) {
        return request.getParameter("uipk");
    }
}

