/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.sensitive;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.app.complexquery.QueryFieldInfo;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.sensitive.IDataSensitiveEngineService;
import com.kingdee.shr.base.syssetting.sensitive.ShrSensitiveServiceFactory;
import com.kingdee.shr.base.syssetting.sensitive.ShrSensitiveServiceUtil;
import com.kingdee.shr.base.syssetting.sensitive.rule.SensitiveRuleBuilderFactory;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataSensitiveEngineService
implements IDataSensitiveEngineService {
    private Context ctx;

    public DataSensitiveEngineService(Context ctx) {
        this.ctx = ctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, String> getSensitiveInfo(String uipk) throws SHRWebException {
        UIViewInfo viewInfo = UIViewUtil.getUIViewInfoByUIPK(this.ctx, uipk);
        HashMap<String, String> sensitive = new HashMap();
        if (!"dynamicList".equals(viewInfo.getType())) return this.searchSensitiveFields(viewInfo);
        try {
            List<QueryFieldInfo> fields = ShrSensitiveServiceUtil.getFieldRanges(this.ctx, viewInfo);
            this.searchSensitiveFields(fields, sensitive);
            Map<String, Map<String, Object>> result = ShrSensitiveServiceFactory.getInstance().getIShrSensitiveService().getPropertySensitive(this.ctx, uipk);
            if (null == result) return sensitive;
            if (result.isEmpty()) return sensitive;
            Iterator<Map.Entry<String, Map<String, Object>>> iterator = result.entrySet().iterator();
            while (iterator.hasNext()) {
                Map<String, Object> value;
                Map.Entry<String, Map<String, Object>> entry = iterator.next();
                if (sensitive.containsKey(entry.getKey()) || !ShrSensitiveServiceUtil.isSensitive(value = entry.getValue())) continue;
                sensitive.put(entry.getKey().toLowerCase(), (String)value.get("name"));
            }
            return sensitive;
        }
        catch (EASBizException e) {
            throw new ShrWebBizException("Data Sensitive Error: ", e);
        }
        catch (BOSException e) {
            throw new SHRWebException("Data Sensitive Error: ", e);
        }
    }

    @Override
    public void convertSensitiveData(List<Map<String, Object>> rows, String uipk) throws SHRWebException {
        try {
            if (UserNantionalUtil.isShrSensitiveRuleOpen((Context)this.ctx)) {
                Map<String, String> sensitiveRule = this.getSensitiveInfo(uipk);
                this.convertDataBySensitiveRule(rows, sensitiveRule);
            }
        }
        catch (EASBizException e) {
            throw new ShrWebBizException("Data Sensitive Error: ", e);
        }
        catch (BOSException e) {
            throw new SHRWebException("Data Sensitive Error: ", e);
        }
    }

    private void searchSensitiveFields(List<QueryFieldInfo> sensitiveFields, Map<String, String> sensFields) {
        for (QueryFieldInfo field : sensitiveFields) {
            Map sensitiveRuleMap;
            List children = field.getChildren();
            if (null != children && !children.isEmpty()) {
                this.searchSensitiveFields(children, sensFields);
                continue;
            }
            if (StringUtils.isEmpty((String)field.getField()) || null == field.getExtendOptions() || null == field.getExtendOptions().get("sensitiveRule") || !ShrSensitiveServiceUtil.isSensitive(sensitiveRuleMap = (Map)field.getExtendOptions().get("sensitiveRule"))) continue;
            sensFields.put(field.getField().toLowerCase(), (String)sensitiveRuleMap.get("name"));
        }
    }

    @Override
    public void convertDataBySensitiveRule(List<Map<String, Object>> rows, Map<String, String> sensitiveRule) throws BOSException, EASBizException {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        if (sensitiveRule.isEmpty()) {
            return;
        }
        int total = rows.size();
        for (int n = 0; n < total; ++n) {
            Map<String, Object> row = rows.get(n);
            for (Map.Entry<String, Object> entry : row.entrySet()) {
                String key0;
                String key = entry.getKey();
                if (StringUtils.isEmpty((String)key) || !sensitiveRule.containsKey(key0 = key.toLowerCase())) continue;
                Object oldValue = row.get(key);
                String newValue = SensitiveRuleBuilderFactory.getRuleValue((Context)this.ctx, (String)sensitiveRule.get(key0), (Object)oldValue);
                row.put(key, newValue);
            }
        }
    }

    private Map<String, String> searchSensitiveFields(UIViewInfo viewInfo) {
        HashMap<String, String> sensFields = new HashMap<String, String>();
        for (FieldInfo fieldInfo : viewInfo.getFields()) {
            if (null == fieldInfo || !ShrSensitiveServiceUtil.isSensitive(fieldInfo.getSensitiveRule())) continue;
            sensFields.put(fieldInfo.getName().toLowerCase(), (String)fieldInfo.getSensitiveRule().get("name"));
        }
        return sensFields;
    }
}

