/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.FileUploadProgressListener;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.web.util.UrlParamEncryptHelper;
import com.kingdee.shr.common.util.XssFilterUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.log4j.Logger;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsFileUploadSupport;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class AjaxMultipartResolver
extends CommonsMultipartResolver {
    private static ThreadLocal<FileUploadProgressListener> progressListener = new ThreadLocal();
    private static Logger logger = Logger.getLogger(AjaxMultipartResolver.class);
    private static final String CONFIG_FILE_NAME = "shrMimeTypes.properties";
    private static long maxUploadSize = 0x40000000L;
    private static final String FORBIDDEN_CHARS = "\\/:*?\"<>|";
    private static Set<String> allowedFileTypes = new HashSet<String>();
    private static Map<String, String> extensionToMimeType = new HashMap<String, String>();
    private static Set<String> excludeFileTypes = new HashSet<String>();
    private static Properties properties = null;
    private final String ENCRYPT_KEYS = "encryptKeys";

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        progressListener.set(new FileUploadProgressListener(request));
        return super.resolveMultipart(request);
    }

    protected FileUpload newFileUpload(FileItemFactory fileItemFactory) {
        FileUpload newFileUpload = super.newFileUpload(fileItemFactory);
        newFileUpload.setProgressListener((ProgressListener)progressListener.get());
        return newFileUpload;
    }

    private CommonsFileUploadSupport.MultipartParsingResult paramHandler(List<FileItem> fileItems, String encoding) {
        CommonsFileUploadSupport.MultipartParsingResult multipartParsingResult = super.parseFileItems(fileItems, encoding);
        Map multipartParameters = multipartParsingResult.getMultipartParameters();
        try {
            String encryptKeysEnCodeValue;
            String[] encryptKeysValue = (String[])multipartParameters.get("encryptKeys");
            if (null != encryptKeysValue && !StringUtils.isEmpty((String)(encryptKeysEnCodeValue = encryptKeysValue[0]))) {
                Object[] encryptKeysDecodeValues = this.getEncryptKeys(encryptKeysEnCodeValue);
                int len = 0;
                if (null != encryptKeysDecodeValues) {
                    len = encryptKeysDecodeValues.length;
                }
                if (len > 0) {
                    multipartParameters.put("encryptKeys", new String[]{StringUtils.arrayToString((Object[])encryptKeysDecodeValues, (String)",")});
                }
                for (int i = 0; i < len; ++i) {
                    String key = encryptKeysDecodeValues[i];
                    String[] multipartParameterEncryptValue = (String[])multipartParameters.get(key);
                    if (null == multipartParameterEncryptValue) continue;
                    multipartParameters.put(key, new String[]{XssFilterUtil.stripXSS((String)UrlParamEncryptHelper.decodeValue(multipartParameterEncryptValue[0]), (String)"file")});
                }
            }
        }
        catch (SHRWebException e) {
            e.printStackTrace();
        }
        return new CommonsFileUploadSupport.MultipartParsingResult(multipartParsingResult.getMultipartFiles(), multipartParameters, multipartParsingResult.getMultipartParameterContentTypes());
    }

    private String[] getEncryptKeys(String encryptKeys) {
        String[] arry = null;
        if (!StringUtils.isEmpty((String)encryptKeys)) {
            try {
                if (encryptKeys.startsWith("encryptKeys:")) {
                    encryptKeys = UrlParamEncryptHelper.decodeValue(encryptKeys.substring("encryptKeys".length() + 1));
                }
                arry = encryptKeys.split(",");
            }
            catch (SHRWebException e) {
                logger.error((Object)e);
                e.printStackTrace();
            }
        }
        return arry;
    }

    protected CommonsFileUploadSupport.MultipartParsingResult parseFileItems(List<FileItem> fileItems, String encoding) {
        CommonsFileUploadSupport.MultipartParsingResult t = this.paramHandler(fileItems, encoding);
        StringBuilder sBuilderSizeMsg = new StringBuilder(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "illegal_file_size", maxUploadSize / 0x100000L + "M") + "[");
        StringBuilder sBuilderTypeMsg = new StringBuilder(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "no_allowed_file_type") + "[");
        for (FileItem fileItem : fileItems) {
            if (fileItem.isFormField()) continue;
            String fileName = fileItem.getName();
            XssFilterUtil.stripXSS((String)fileName, (String)"file");
            if (!this.isValidFilename(fileName)) {
                throw new IllegalArgumentException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "Illegal_character_input") + "[" + fileName + "]");
            }
            if (fileItem.getSize() > maxUploadSize) {
                sBuilderSizeMsg.append(fileName).append(";");
            }
            if (this.isFileTypeAllowed(fileItem)) continue;
            sBuilderTypeMsg.append(fileName).append(";");
        }
        this.assembleMsg(sBuilderSizeMsg, sBuilderTypeMsg);
        return t;
    }

    private static void excludedFileTypes(String excludedFileTypes) {
        String[] fileTypes;
        for (String fileType : fileTypes = excludedFileTypes.split(",")) {
            if (!allowedFileTypes.contains(fileType)) continue;
            allowedFileTypes.remove(fileType);
            extensionToMimeType.remove(fileType);
        }
    }

    private boolean isValidFilename(String filename) {
        for (char c : FORBIDDEN_CHARS.toCharArray()) {
            if (filename.indexOf(c) < 0) continue;
            return false;
        }
        return true;
    }

    private boolean isFileTypeAllowed(FileItem fileItem) {
        String fileName = fileItem.getName();
        String mimeType = fileItem.getContentType();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("fileName:" + fileName + " mimeType:" + mimeType));
        }
        if (StringUtils.isEmpty((String)fileName) || StringUtils.isEmpty((String)mimeType)) {
            return false;
        }
        String extension = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase(Locale.ENGLISH);
        boolean isExcludeFielTypes = excludeFileTypes.contains(extension);
        if (isExcludeFielTypes) {
            return true;
        }
        if (!extensionToMimeType.containsKey(extension) || !allowedFileTypes.contains(extension)) {
            return false;
        }
        boolean isAllowedMimeType = extensionToMimeType.get(extension).contains(mimeType);
        if (!isAllowedMimeType) {
            logger.error((Object)("fileName:" + fileName + " mimeType:" + mimeType));
        }
        return isAllowedMimeType;
    }

    private void assembleMsg(StringBuilder sBuilderSizeMsg, StringBuilder sBuilderTypeMsg) {
        if (sBuilderSizeMsg.indexOf(";") > -1 && sBuilderTypeMsg.indexOf(";") > -1) {
            sBuilderSizeMsg = this.setMsg(sBuilderSizeMsg);
            sBuilderTypeMsg = this.setMsg(sBuilderTypeMsg);
            sBuilderSizeMsg.append("\n").append((CharSequence)sBuilderTypeMsg);
            throw new IllegalArgumentException(sBuilderSizeMsg.toString());
        }
        if (sBuilderSizeMsg.indexOf(";") > -1 && sBuilderTypeMsg.indexOf(";") <= -1) {
            sBuilderSizeMsg = this.setMsg(sBuilderSizeMsg);
            throw new IllegalArgumentException(sBuilderSizeMsg.toString());
        }
        if (sBuilderSizeMsg.indexOf(";") <= -1 && sBuilderTypeMsg.indexOf(";") > -1) {
            sBuilderTypeMsg = this.setMsg(sBuilderTypeMsg);
            throw new IllegalArgumentException(sBuilderTypeMsg.toString());
        }
    }

    private StringBuilder setMsg(StringBuilder sb) {
        return sb.deleteCharAt(sb.length() - 1).append("]");
    }

    private static String getConfigPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getShrPropertiesPath()).append(File.separator).append(CONFIG_FILE_NAME);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        excludeFileTypes.add("doc");
        excludeFileTypes.add("docx");
        excludeFileTypes.add("xls");
        excludeFileTypes.add("xlsx");
        excludeFileTypes.add("xlsm");
        excludeFileTypes.add("csv");
        excludeFileTypes.add("ppt");
        excludeFileTypes.add("pptx");
        allowedFileTypes.add("txt");
        allowedFileTypes.add("pdf");
        allowedFileTypes.add("doc");
        allowedFileTypes.add("docx");
        allowedFileTypes.add("xls");
        allowedFileTypes.add("xlsx");
        allowedFileTypes.add("xlsm");
        allowedFileTypes.add("ppt");
        allowedFileTypes.add("pptx");
        allowedFileTypes.add("rft");
        allowedFileTypes.add("rtf");
        allowedFileTypes.add("jpg");
        allowedFileTypes.add("png");
        allowedFileTypes.add("bmp");
        allowedFileTypes.add("gif");
        allowedFileTypes.add("jpeg");
        allowedFileTypes.add("tiff");
        allowedFileTypes.add("tif");
        allowedFileTypes.add("rar");
        allowedFileTypes.add("zip");
        allowedFileTypes.add("dat");
        allowedFileTypes.add("hrl");
        allowedFileTypes.add("key");
        allowedFileTypes.add("msg");
        allowedFileTypes.add("cad");
        allowedFileTypes.add("avi");
        allowedFileTypes.add("btw");
        allowedFileTypes.add("rmvb");
        allowedFileTypes.add("wps");
        allowedFileTypes.add("et");
        allowedFileTypes.add("dps");
        allowedFileTypes.add("vsd");
        allowedFileTypes.add("mod");
        allowedFileTypes.add("dwg");
        allowedFileTypes.add("prn");
        allowedFileTypes.add("lic");
        allowedFileTypes.add("csv");
        allowedFileTypes.add("ttf");
        allowedFileTypes.add("ttc");
        allowedFileTypes.add("otf");
        allowedFileTypes.add("eot");
        allowedFileTypes.add("woff");
        extensionToMimeType.put("txt", "text/plain");
        extensionToMimeType.put("pdf", "application/pdf");
        extensionToMimeType.put("doc", "application/msword,application/wps-office.doc");
        extensionToMimeType.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document,application/wps-office.docx");
        extensionToMimeType.put("xls", "application/vnd.ms-excel/application,octet-stream,application/wps-office.xls");
        extensionToMimeType.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/octet-stream,application/wps-office.xlsx");
        extensionToMimeType.put("xlsm", "application/vnd.ms-excel.sheet.macroEnabled.12,application/octet-stream,application/wps-office.xlsm");
        extensionToMimeType.put("ppt", "application/vnd.ms-powerpoint,application/wps-office.ppt");
        extensionToMimeType.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation,application/wps-office.pptx");
        extensionToMimeType.put("rft", "application/rtf,application/octet-stream");
        extensionToMimeType.put("rtf", "application/rtf,application/msword,application/octet-stream");
        extensionToMimeType.put("jpg", "image/jpeg");
        extensionToMimeType.put("png", "image/png");
        extensionToMimeType.put("bmp", "image/bmp");
        extensionToMimeType.put("gif", "image/gif");
        extensionToMimeType.put("jpeg", "image/jpeg");
        extensionToMimeType.put("tiff", "image/tiff");
        extensionToMimeType.put("tif", "image/tiff");
        extensionToMimeType.put("rar", "application/x-rar-compressed,application/octet-stream,application/x-compressed,application/vnd.rar");
        extensionToMimeType.put("zip", "application/zip,application/x-zip-compressed,application/x-compressed,application/octet-stream");
        extensionToMimeType.put("dat", "application/octet-stream");
        extensionToMimeType.put("hrl", "application/octet-stream");
        extensionToMimeType.put("key", "application/vnd.apple.keynote,application/octet-stream");
        extensionToMimeType.put("msg", "application/vnd.ms-outlook,application/octet-stream");
        extensionToMimeType.put("cad", "application/vnd.visio,application/octet-stream");
        extensionToMimeType.put("btw", "application/btw,application/octet-stream");
        extensionToMimeType.put("avi", "video/avi,video/x-msvideo,application/octet-stream");
        extensionToMimeType.put("rmvb", "application/vnd.rn-realmedia-vbr,application/octet-stream");
        extensionToMimeType.put("wps", "application/vnd.ms-works,application/octet-stream,application/kswps");
        extensionToMimeType.put("et", "application/vnd.ms-excel,application/octet-stream");
        extensionToMimeType.put("dps", "application/vnd.ms-works,application/octet-stream");
        extensionToMimeType.put("vsd", "application/vnd.visio,application/vnd.ms-visio.viewer");
        extensionToMimeType.put("mod", "video/mpeg,application/octet-stream");
        extensionToMimeType.put("dwg", "image/vnd.dwg,application/octet-stream");
        extensionToMimeType.put("prn", "application/prn,application/octet-stream");
        extensionToMimeType.put("lic", "application/x-ms-license,application/octet-stream");
        extensionToMimeType.put("csv", "text/csv,application/vnd.ms-excel");
        extensionToMimeType.put("ttf", "font/ttf,application/x-font-ttf,application/octet-stream");
        extensionToMimeType.put("ttc", "font/ttc,font/collection,application/x-font-ttc,application/ttc,application/octet-stream");
        extensionToMimeType.put("otf", "font/otf,application/x-font-otf,application/x-font-opentype,application/octet-stream");
        extensionToMimeType.put("eot", "application/vnd.ms-fontobject,application/octet-stream");
        extensionToMimeType.put("woff", "font/woff,application/x-font-woff,application/font-woff,application/octet-stream");
        String configFile = AjaxMultipartResolver.getConfigPath();
        FileInputStream input = null;
        try {
            File file = new File(configFile);
            if (file.exists()) {
                properties = new Properties();
                input = new FileInputStream(configFile);
                properties.load(input);
                for (String key : properties.stringPropertyNames()) {
                    String value = properties.getProperty(key);
                    if ("maxUploadSize".equals(key)) {
                        maxUploadSize = Long.parseLong(value) * 1024L * 1024L;
                        continue;
                    }
                    if ("excludedFileTypes".equals(key)) {
                        AjaxMultipartResolver.excludedFileTypes(value);
                        continue;
                    }
                    allowedFileTypes.add(key);
                    extensionToMimeType.put(key, value);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"Init params error!");
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.error((Object)"FileInputStream is not closed!");
                }
            }
        }
    }
}

