/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.shr.base.syssetting.IBaseItemRelationHR;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.BaseItemRelationHRUtil;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SHRBasicItemUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;

public class BaseItemRelationHRInterfaceUtil {
    public static IBaseItemRelationHR getIBaseItemRelationHR(UIViewInfo uiViewInfo) throws SHRWebException {
        if (null == uiViewInfo) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "view_not_found"));
        }
        SHRBasicItemInfo shrBasicItemInfo = SHRBasicItemUtil.getSHRBasicItemInfoByEntityName(uiViewInfo.getEntityName());
        if (null == shrBasicItemInfo) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "ctrl_stra_not_defend"));
        }
        String message = MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "bizorg_entity_not_defend"), shrBasicItemInfo.getName());
        if (StringUtils.isEmpty((String)shrBasicItemInfo.getRelationHREntity())) {
            throw new ShrWebBizException(message);
        }
        EntityObjectInfo entityObjectInfo = MetaDataUtil.getEntityObjectByEntityName(shrBasicItemInfo.getRelationHREntity());
        if (null == entityObjectInfo) {
            throw new ShrWebBizException(message);
        }
        if (!BaseItemRelationHRUtil.isSHRBaseItemRelationHR((EntityObjectInfo)entityObjectInfo.getBaseEntity())) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "bizorg_entity_defend_error"), shrBasicItemInfo.getName()));
        }
        try {
            return (IBaseItemRelationHR)MetaDataUtil.getBizInterface(shrBasicItemInfo.getRelationHREntity());
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    public static IBaseItemRelationHR getIBaseItemRelationHR(String baseInfoId) throws SHRWebException {
        EntityObjectInfo baseEntityObjectInfo = MetaDataUtil.getEntityObject(baseInfoId);
        SHRBasicItemInfo shrBasicItemInfo = SHRBasicItemUtil.getSHRBasicItemInfoByEntityName(baseEntityObjectInfo.getFullName());
        if (null == shrBasicItemInfo) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "ctrl_stra_not_defend"));
        }
        String message = MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "bizorg_entity_not_defend"), shrBasicItemInfo.getName());
        if (StringUtils.isEmpty((String)shrBasicItemInfo.getRelationHREntity())) {
            throw new ShrWebBizException(message);
        }
        EntityObjectInfo entityObjectInfo = MetaDataUtil.getEntityObjectByEntityName(shrBasicItemInfo.getRelationHREntity());
        if (null == entityObjectInfo) {
            throw new ShrWebBizException(message);
        }
        if (!BaseItemRelationHRUtil.isSHRBaseItemRelationHR((EntityObjectInfo)entityObjectInfo.getBaseEntity())) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "bizorg_entity_defend_error"), shrBasicItemInfo.getName()));
        }
        try {
            return (IBaseItemRelationHR)MetaDataUtil.getBizInterface(shrBasicItemInfo.getRelationHREntity());
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }
}

