/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.biz.trans.AssignatePersonsInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.monitor.WfProcessDiagram;
import com.kingdee.bos.workflow.participant.ParticipantBlock;
import com.kingdee.bos.workflow.participant.ParticipantCase;
import com.kingdee.bos.workflow.participant.ParticipantUnit;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WfServiceUtil {
    public static final String IS_SET_POST_ACTIVITIES_PERSON = "isSetPostActivitiesPerson";

    private WfServiceUtil() {
    }

    public static List wfIsSetNextPerson(CoreBaseInfo coreBaseInfo, Map<String, Object> nextPersMsgResult, Context ctx) throws SHRWebException {
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            return WfServiceUtil.wfIsSetNextPerson(svc, coreBaseInfo, nextPersMsgResult, ctx);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
            throw new SHRWebException(e);
        }
    }

    public static List wfIsSetNextPerson(IEnactmentService svc, CoreBaseInfo coreBaseInfo, Map<String, Object> nextPersMsgResult, Context ctx) throws SHRWebException {
        try {
            if (svc.findSubmitProcDef(coreBaseInfo.getBOSType(), ctx.getCaller().toString()) == null) {
                return null;
            }
            AssignatePersonsInfo assignatePersons = svc.checkPostActivitiesPersonsResult((IObjectValue)coreBaseInfo, ctx.getCaller().toString(), null, null, null);
            if (assignatePersons == null || assignatePersons.getProcDefId() == null) {
                return null;
            }
            if (assignatePersons.isSetNextPersonBeforeSubmit()) {
                ExtendedAttributeCollection eac;
                int i;
                ProcessDefInfo processDefInfo = svc.getProcessDefInfo(assignatePersons.getProcDefId());
                ProcessDef processDef = svc.getProcessDefByDefineHashValue(processDefInfo.getMd5HashValue());
                WfProcessDiagram diag = new WfProcessDiagram();
                HashMap[] acts = diag.findDirectNextManpownerActivities(processDef);
                boolean isShowAllEmptyActivity = false;
                boolean isShowAllManpowerActivities = false;
                boolean isShowAllEmptyManpowerActivites = false;
                ArrayList startActivityList = diag.getStartActivities();
                if (startActivityList != null && startActivityList.size() > 0 && startActivityList.get(0) != null && startActivityList.get(0) instanceof ManpowerActivityDef) {
                    ManpowerActivityDef start = (ManpowerActivityDef)startActivityList.get(0);
                    isShowAllEmptyActivity = start.isShowAllEmptyManpowerActivites();
                    isShowAllManpowerActivities = start.isShowAllManpowerActivities();
                    isShowAllEmptyManpowerActivites = start.isShowAllEmptyManpowerActivites();
                }
                if (isShowAllManpowerActivities || isShowAllEmptyManpowerActivites) {
                    acts = diag.findNextManpownerActivities(processDef);
                }
                LinkedList<HashMap[]> stack = new LinkedList<HashMap[]>();
                ArrayList manActsList = new ArrayList();
                ArrayList approveActsList = new ArrayList();
                stack.add(acts);
                while (stack.size() > 0) {
                    HashMap[] activities = (HashMap[])stack.remove(0);
                    for (i = 0; i < activities.length; ++i) {
                        HashMap act = activities[i];
                        HashMap<String, ActivityDef> actMap = new HashMap<String, ActivityDef>();
                        ActivityDef actDef = (ActivityDef)act.get("actDef");
                        if (actDef instanceof ManpowerActivityDef) {
                            if (actDef instanceof ApproveActivityDef) {
                                actMap.put(actDef.getID(), actDef);
                                approveActsList.add(actMap);
                                continue;
                            }
                            actMap.put(actDef.getID(), actDef);
                            manActsList.add(actMap);
                            continue;
                        }
                        HashMap[] tmp = (HashMap[])act.get("subActivities");
                        if (tmp == null || tmp.length <= 0) continue;
                        stack.add(tmp);
                    }
                }
                approveActsList.addAll(manActsList);
                ArrayList nextPers = new ArrayList();
                int size = approveActsList.size();
                for (i = 0; i < size; ++i) {
                    HashMap act = (HashMap)approveActsList.get(i);
                    Iterator iter = act.entrySet().iterator();
                    Map.Entry entry = iter.next();
                    List participants = WfServiceUtil.getIncludeperson((ManpowerActivityDef)entry.getValue());
                    HashMap<String, Object> record = new HashMap<String, Object>();
                    List personList = svc.getPersonsByDefParticipants(((ProcessDef)((ManpowerActivityDef)entry.getValue()).getContainer()).getHashValue(), entry.getKey().toString(), participants, ctx.getCaller().toString(), (IObjectValue)coreBaseInfo);
                    if (isShowAllEmptyManpowerActivites && null != personList && personList.size() > 0) continue;
                    String key = ParticipantUtils.createDesignatePerformerKey((ActivityDef)((ManpowerActivityDef)entry.getValue()));
                    record.put("key", key);
                    record.put("name", ((ManpowerActivityDef)entry.getValue()).getName(ctx.getLocale()));
                    record.put("isAllPersonAsPerformer", ((ManpowerActivityDef)entry.getValue()).isAllPersonAsPerformer());
                    record.put("procDefHash", ((ProcessDef)((ManpowerActivityDef)entry.getValue()).getContainer()).getHashValue());
                    record.put("person", WfServiceUtil.extUserInfo(personList, ctx));
                    nextPers.add(record);
                }
                boolean mustDesignateDirectActivityPerformer = false;
                boolean mustDesignateAllActivityPerformer = false;
                ExtendedAttributeCollection extendedAttributeCollection = eac = processDef != null ? processDef.getExtendedAttributes() : null;
                if (eac != null) {
                    if (eac.get("mustDesignateDirectActivityPerformer") != null) {
                        mustDesignateDirectActivityPerformer = "true".equals(eac.get("mustDesignateDirectActivityPerformer").getValue());
                    }
                    if (eac.get("mustDesignateAllActivityPerformer") != null) {
                        mustDesignateAllActivityPerformer = "true".equals(eac.get("mustDesignateAllActivityPerformer").getValue());
                    }
                }
                try {
                    String paramItemValue = ParamManager.getParamValue((Context)ctx, null, (String)"MUST_SET_ALL_NEXT_PERSONS");
                    if (!StringUtils.isEmpty((String)paramItemValue) && Boolean.valueOf(paramItemValue).booleanValue()) {
                        mustDesignateDirectActivityPerformer = true;
                    }
                }
                catch (EASBizException e) {
                    Logger.error((Throwable)e);
                }
                if (null != processDef) {
                    nextPersMsgResult.put(IS_SET_POST_ACTIVITIES_PERSON, processDef.getProcessHeader().isSetPostActivitiesPerson());
                }
                nextPersMsgResult.put("mustDesignateDirectActivityPerformer", mustDesignateDirectActivityPerformer);
                nextPersMsgResult.put("mustDesignateAllActivityPerformer", mustDesignateAllActivityPerformer);
                nextPersMsgResult.put("WFISSETNEXTPERSON", assignatePersons.isSetNextPersonBeforeSubmit());
                return nextPers;
            }
            nextPersMsgResult.put("WFISSETNEXTPERSON", assignatePersons.isSetNextPersonBeforeSubmit());
            return null;
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
            throw new SHRWebException(e);
        }
    }

    private static List getIncludeperson(ManpowerActivityDef actDef) {
        ParticipantBlock block = new ParticipantBlock((ActivityDef)actDef);
        List caseList = block.getChildren();
        ArrayList<String> list = new ArrayList<String>();
        int n = caseList.size();
        for (int i = 0; i < n; ++i) {
            ParticipantCase pCase = (ParticipantCase)caseList.get(i);
            List unitList = pCase.getChildren();
            int m = unitList.size();
            for (int j = 0; j < m; ++j) {
                ParticipantUnit pUnit = (ParticipantUnit)unitList.get(j);
                ParticipantDef def = pUnit.getIncludeParticpant().getParticpantDefWrapper().getParticipantDef();
                if (def == null) continue;
                list.add(def.getID());
            }
        }
        return list;
    }

    private static List<Map<String, Object>> extUserInfo(List<Person> personList, Context ctx) throws BOSException {
        if (null == personList) {
            return null;
        }
        ArrayList<Map<String, Object>> personListNew = new ArrayList<Map<String, Object>>();
        for (Person personEntity : personList) {
            HashMap<String, String> personMap = new HashMap<String, String>();
            personMap.put("employeeId", personEntity.getEmployeeId());
            personMap.put("employeeName", personEntity.getEmployeeName(ctx.getLocale()));
            personMap.put("userId", personEntity.getUserId());
            personMap.put("userName", personEntity.getUserName(ctx.getLocale()));
            try {
                PersonCollection personColl;
                UserInfo userInfo;
                if (!StringUtils.isEmpty((String)personEntity.getUserId()) && null != (userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(personEntity.getUserId())))) {
                    personMap.put("number", userInfo.getNumber());
                    personMap.put("userName", userInfo.getName(ctx.getLocale()));
                }
                if (!StringUtils.isEmpty((String)personEntity.getEmployeeId()) && (personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(" where id='" + personEntity.getEmployeeId() + "'")) != null && personColl.size() > 0) {
                    PersonInfo personInfo = personColl.get(0);
                    personMap.put("number", personInfo.getNumber());
                    personMap.put("employeeName", personInfo.getName(ctx.getLocale()));
                }
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            personListNew.add(personMap);
        }
        return personListNew;
    }
}

