/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.CloudUserFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.util.CloudParamUtil;
import com.kingdee.eas.cp.eip.sso.util.TransferUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/clubService"})
public class ClubServiceController {
    private static Logger logger = Logger.getLogger(ClubServiceController.class);

    @RequestMapping(value={"/loginClub"})
    public String loginClubAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException, BOSException {
        Map<String, String> authParams = this.getAuthParams();
        if (authParams == null || authParams.get("authCode") == null) {
            return this.locateDefaultPage(request);
        }
        Map<String, String> cloudConfig = this.getCloudConfig();
        String clubUrl = this.getClubServerUrl(cloudConfig);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("auth_code", authParams.get("authCode"));
        params.put("callback", this.assembleCallbackUrl(SHRContext.getInstance().getContext(), authParams, clubUrl));
        String nextUrl = DynamicUtil.assembleUrl(clubUrl + "/club/auth/login", params);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("login club url: " + nextUrl));
        }
        return "redirect:" + nextUrl;
    }

    private String locateDefaultPage(HttpServletRequest request) {
        return "redirect:/shr/pages/nonet.html";
    }

    private String assembleCallbackUrl(Context ctx, Map<String, String> authParams, String clubUrl) throws SHRWebException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", authParams.get("uid"));
        params.put("productid", authParams.get("productId"));
        params.put("prod_inst_code", authParams.get("prodInstId"));
        params.put("mods", JSONUtils.convertObjectToJson(ctx, this.getMods()));
        String callbackUrl = DynamicUtil.assembleUrl(clubUrl + "/club/erppush/index", params);
        return callbackUrl;
    }

    private List<Map<String, String>> getMods() {
        ArrayList<Map<String, String>> mods = new ArrayList<Map<String, String>>();
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("code", "SHR_1001");
        item.put("desc", URLEncoder.encode(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "homepage")));
        mods.add(item);
        return mods;
    }

    @RequestMapping(value={"/getUnReadNews"})
    public void getUnreadNewsAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        this.getUnreadNews(request, response);
    }

    private void getUnreadNews(HttpServletRequest request, HttpServletResponse response) {
        try {
            String unreadCount = "0";
            if (!this.isDefaultUser()) {
                Map<String, String> authParams = this.getAuthParams();
                if (authParams == null) {
                    JSONUtils.ERROR("get auth code fail");
                    return;
                }
                unreadCount = this.getUnreadNewsFromCound(authParams.get("uid"), authParams.get("productId"), authParams.get("prodInstId"), authParams.get("authCode"));
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("unReadCount", unreadCount);
            JSONUtils.writeJson(response, data);
        }
        catch (Exception e) {
            logger.error((Object)"get cloud community unread message failed ", (Throwable)e);
            JSONUtils.ERROR("getUnreadNews fail");
        }
    }

    private boolean isDefaultUser() {
        Context ctx = SHRContext.getInstance().getContext();
        String userNumber = ContextUtil.getCurrentUserInfo((Context)ctx).getNumber();
        if (StringUtils.isEmpty((String)userNumber)) {
            return false;
        }
        return false;
    }

    private String getAccessToken(String uid, String prodInstId) throws Exception {
        String accessToken = "";
        long t1 = System.currentTimeMillis();
        Map<String, String> cloudConfig = this.getCloudConfig();
        String cloudUrl = this.getCloudServerUrl(cloudConfig);
        String client_id = this.getCloudClientId(cloudConfig);
        String client_secret = this.getCloudClientsecret(cloudConfig);
        String url = cloudUrl + "/clouderp/access_token";
        String s = client_id + client_secret + uid + prodInstId + t1;
        String signiture = TransferUtil.sha1((String)s);
        String returnValue = this.getMessage(url = url + "?client_id=" + client_id + "&uid=" + URLEncoder.encode(uid, "utf-8") + "&prod_inst_code=" + URLEncoder.encode(prodInstId, "utf-8") + "&timestamp=" + t1 + "&signiture=" + signiture);
        if (!StringUtils.isEmpty((String)returnValue)) {
            try {
                JSONObject responseData = JSONObject.parseObject((String)returnValue);
                Integer errCode = responseData.getInteger("errcode");
                if (errCode == 0 && responseData.get((Object)"data") != null) {
                    JSONObject data = responseData.getJSONObject("data");
                    accessToken = data.getString("access_token");
                }
            }
            catch (Exception e) {
                logger.info((Object)("[  JSONObject.parseObject error ] returnValue value is " + returnValue));
            }
        }
        return accessToken;
    }

    private String getAuthCodeByAccessToken(String accessToken) throws Exception {
        JSONObject responseData;
        Integer errCode;
        Map<String, String> cloudConfig = this.getCloudConfig();
        String cloudUrl = cloudConfig.get("cloud.server.url");
        String authCode = "";
        String url = cloudUrl + "/auth/user/auth_code?access_token=" + accessToken;
        String returnValue = this.getMessage(url);
        if (!StringUtils.isEmpty((String)returnValue) && (errCode = (responseData = JSONObject.parseObject((String)returnValue)).getInteger("errcode")) == 0 && responseData.get((Object)"data") != null) {
            JSONObject data = responseData.getJSONObject("data");
            authCode = data.getString("auth_code");
        }
        return authCode;
    }

    private String getUnreadNewsFromCound(String uid, String productId, String prodInsId, String authCode) throws Exception {
        String unreadCount = "0";
        Map<String, String> cloudConfig = this.getCloudConfig();
        String clubUrl = this.getClubServerUrl(cloudConfig);
        String url = clubUrl + "/club/erppush/news?uid=" + uid + "&productid=" + productId + "&prod_inst_code=" + prodInsId + "&auth_code=" + authCode;
        String returnValue = this.getMessage(url);
        if (!StringUtils.isEmpty((String)returnValue)) {
            try {
                JSONObject responseData = JSONObject.parseObject((String)returnValue);
                Integer errCode = responseData.getInteger("errcode");
                if (errCode == 0) {
                    unreadCount = responseData.getString("num");
                }
            }
            catch (Exception e) {
                logger.error((Object)("[  JSONObject.parseObject error ] returnValue value is " + returnValue));
            }
        }
        if (unreadCount == null || unreadCount.length() < 0) {
            unreadCount = "0";
        }
        return unreadCount;
    }

    private Map<String, String> getAuthParams() {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            Map paramMap = CloudParamUtil.getCloudParams((Context)ctx);
            String uid = (String)paramMap.get("uid");
            String prodInstId = (String)paramMap.get("prod_inst_code");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("uid", uid);
            params.put("prodInstId", prodInstId);
            params.put("productId", "S10S001S002");
            String accessToken = "";
            if (!StringUtils.isEmpty((String)uid) && !StringUtils.isEmpty((String)prodInstId)) {
                accessToken = this.getAccessToken(uid, prodInstId);
            }
            if (!StringUtils.isEmpty((String)accessToken)) {
                String authCode = this.getAuthCodeByAccessToken(accessToken);
                params.put("authCode", authCode);
            }
            return params;
        }
        catch (Exception e) {
            logger.error((Object)"get auth_code failed", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMessage(String surl) throws Exception {
        String response = null;
        HttpClient http = new HttpClient();
        GetMethod get = null;
        try {
            get = new GetMethod(surl);
            http.setConnectionTimeout(5000);
            http.executeMethod((HttpMethod)get);
            response = new String(get.getResponseBodyAsString().getBytes("UTF-8"));
        }
        catch (Throwable e) {
            logger.error((Object)"error message", e);
            response = "send exception:" + e.getMessage();
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return response;
    }

    private Map<String, String> getCloudConfig() throws EASBizException, BOSException {
        return (Map)CloudUserFacadeFactory.getRemoteInstance().getConfig();
    }

    private String getClubServerUrl(Map<String, String> cloudConfig) throws EASBizException, BOSException {
        return "http://club.kingdee.com";
    }

    private String getCloudServerUrl(Map<String, String> cloudConfig) {
        return cloudConfig.get("cloud.server.url");
    }

    private String getCloudClientId(Map<String, String> cloudConfig) {
        return cloudConfig.get("cloud.client.id");
    }

    private String getCloudClientsecret(Map<String, String> cloudConfig) {
        return cloudConfig.get("cloud.client.secret");
    }

    @RequestMapping(value={"/getLogInfo"})
    public void getLogInfoAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        Context ctx = SHRContext.getInstance().getContext();
        String userID = ctx.getCaller().toString();
        String ipAdd = request.getRemoteHost();
        String version = "s-HRV8.2";
        String clientno = "";
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            clientno = baseInfo.getSerialNum();
        }
        catch (LicenseException e1) {
            logger.error((Object)e1);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userID", userID);
        map.put("ipAdd", ipAdd);
        map.put("version", version);
        map.put("clientno", clientno);
        try {
            JSONUtils.SUCCESS(map, (ServletResponse)response);
        }
        catch (SHRWebException e) {
            e.printStackTrace();
        }
    }
}

