/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.secrity.AESUtils;
import com.kingdee.shr.base.syssetting.web.controller.DownloadFileController;
import com.kingdee.util.StringUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/downloadFileForMulMachine"})
public class DownloadFileForMulMachineController
extends DownloadFileController {
    private static final Logger logger = Logger.getLogger(DownloadFileForMulMachineController.class);

    @Override
    @RequestMapping(params={"method=file"})
    public void downloadFromDir(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String filename;
        if (this.isDownload(request)) {
            throw new ShrWebBizException(new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION));
        }
        String file = request.getParameter("file");
        if (!this.verifParam(file, filename = request.getParameter("filename"))) {
            return;
        }
        String ctxId = request.getParameter("ctxId");
        try {
            boolean isPortalUserExists = UserMonitorFactory.getRemoteInstance().isPortalUserExists(ctxId);
            if (!isPortalUserExists) {
                logger.error((Object)("isPortalUserExists:" + isPortalUserExists));
                return;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            return;
        }
        this.downloadLocalFile(request, response, filename, file);
    }

    private boolean isDownload(HttpServletRequest request) {
        String javaInnerCallEncodeValue = request.getHeader("java_inner_call");
        if (StringUtils.isEmpty((String)javaInnerCallEncodeValue)) {
            return false;
        }
        try {
            String javaInnerCallDecodeValue = AESUtils.cbcDecrypt((String)javaInnerCallEncodeValue, (String)AESUtils.getUrlParamEncryptKey());
            return AESUtils.getUrlParamEncryptKey().equals(javaInnerCallDecodeValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

