/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AuditPersonPhotoFactory;
import com.kingdee.eas.hr.base.util.personphoto.PersonPhotoAuditUtil;
import com.kingdee.eas.hr.emp.EmployeeAuditCollection;
import com.kingdee.eas.hr.emp.EmployeeAuditFactory;
import com.kingdee.eas.hr.emp.EmployeeAuditInfo;
import com.kingdee.eas.hr.emp.EmployeeAuditStateEnum;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.api.service.SHRFunctionPermissionService;
import com.kingdee.shr.base.syssetting.annotation.Action;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.SHRPermissionWebUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FileModel;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FormUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.WebUtil;
import com.kingdee.util.StringUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/headUpload"})
public class HeadUploadController
extends WebComponentController {
    private static final String PSERSONID = "personId";
    private static final long MAX_SIZE_IMAGE = 0x200000L;

    private boolean isEmpSpecUIView(Context ctx, String uipk) throws SHRWebException {
        UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
        return uiViewInfo != null && "form".equals(uiViewInfo.getType()) && ("com.kingdee.eas.hr.affair.app.EmpEnrollBizBill".equals(uiViewInfo.getModel()) || "com.kingdee.shr.preentry.app.PreEntry".equals(uiViewInfo.getModel()) || "com.kingdee.eas.hr.emp.app.EmpAuditBizBill".equals(uiViewInfo.getModel()));
    }

    private String getPersonID(Context ctx, HttpServletRequest request) throws SHRWebException {
        String personId;
        String refferer = request.getHeader("Referer");
        String uipk = SHRPermissionWebUtils.getUipkByUrl(refferer);
        if (this.isEmpSpecUIView(ctx, uipk) && !StringUtils.isEmpty((String)(personId = request.getParameter(PSERSONID)))) {
            return personId;
        }
        HttpSession session = request.getSession();
        String searchRandomKey = request.getParameter("onceKey");
        String personId2 = request.getParameter(PSERSONID);
        String sessionKey = String.format("%s%s", "onceKey", personId2);
        HashMap serverSearchRandomKey = null;
        if (session.getAttribute(sessionKey) instanceof HashMap) {
            serverSearchRandomKey = (HashMap)session.getAttribute(sessionKey);
        }
        if (!StringUtils.isEmpty((String)uipk) && "shr.perself.homepage".equals(uipk)) {
            PersonInfo p = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            if (null == p) {
                return null;
            }
            if (this.isNotTemper(searchRandomKey, serverSearchRandomKey)) {
                session.removeAttribute(sessionKey);
                return (String)serverSearchRandomKey.get(PSERSONID);
            }
            return p.getId().toString();
        }
        PermItemInfo pi = SHRPermissionWebUtils.getPermItemByReferer(ctx, refferer);
        if (null != pi && OrgType.NONE.equals((Object)pi.getOrgRelation())) {
            PersonInfo p = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            if (null == p) {
                return null;
            }
            if (this.isNotTemper(searchRandomKey, serverSearchRandomKey)) {
                session.removeAttribute(sessionKey);
                return (String)serverSearchRandomKey.get(PSERSONID);
            }
            try {
                SHRFunctionPermissionService.checkCurrnetUserFunctionPermission((Context)ctx, (PermItemInfo)pi);
                return personId2;
            }
            catch (Exception e) {
                throw new ShrWebBizException(new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION));
            }
        }
        if (null != pi) {
            return personId2;
        }
        if (!(StringUtils.isEmpty((String)refferer) || refferer.indexOf("/shr/home.do") == -1 && refferer.indexOf("/shr/main.do") == -1)) {
            PersonInfo p = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            if (null == p) {
                return null;
            }
            if (this.isNotTemper(searchRandomKey, serverSearchRandomKey)) {
                session.removeAttribute(sessionKey);
                return (String)serverSearchRandomKey.get(PSERSONID);
            }
            return p.getId().toString();
        }
        throw new ShrWebBizException(new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION));
    }

    private boolean isNotTemper(String searchRandomKey, HashMap<String, String> serverSearchRandomKey) {
        return null != serverSearchRandomKey && !StringUtils.isEmpty((String)searchRandomKey) && searchRandomKey.equals(serverSearchRandomKey.get("onceKey"));
    }

    @RequestMapping(params={"method=initUploadDialog"})
    @Action
    public String initUploadDialog(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, IOException, SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String personId = this.getPersonID(ctx, request);
        if (personId != null && personId.length() > 0) {
            IPersonPhoto personPhoto = PersonPhotoFactory.getLocalInstance((Context)ctx);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            CoreBaseCollection coll = new CoreBaseCollection();
            coll = this.isShowAuditPhoto(ctx, request) ? personPhoto.getAuditPersonPhoto(personId) : personPhoto.getCollection(entityViewInfo);
            PersonPhotoInfo personPhotoInfo = null;
            if (coll.size() > 0) {
                personPhotoInfo = (PersonPhotoInfo)coll.get(0);
                request.setAttribute("id", (Object)personPhotoInfo.getId());
                request.setAttribute(PSERSONID, (Object)personId);
                if (personPhotoInfo.getImageDataSource() != null) {
                    request.setAttribute("hasImg", (Object)"true");
                    request.setAttribute("sourceImageWidth", (Object)personPhotoInfo.getSourceImageWidth());
                    request.setAttribute("sourceImageHeight", (Object)personPhotoInfo.getSourceImageHeight());
                    request.getSession().setAttribute("last_image_source", (Object)personPhotoInfo.getImageDataSource());
                    request.getSession().setAttribute("last_image_source_contenttype", (Object)personPhotoInfo.getImageContentType());
                } else {
                    request.setAttribute("hasImg", (Object)"false");
                    request.setAttribute("sourceImageWidth", (Object)"0");
                    request.setAttribute("sourceImageHeight", (Object)"0");
                }
            } else {
                request.setAttribute(PSERSONID, (Object)personId);
                request.setAttribute("id", (Object)"null");
                request.setAttribute("hasImg", (Object)"false");
                request.setAttribute("sourceImageWidth", (Object)"0");
                request.setAttribute("sourceImageHeight", (Object)"0");
            }
        } else {
            request.setAttribute(PSERSONID, (Object)"null");
            request.setAttribute("id", (Object)"null");
            request.setAttribute("hasImg", (Object)"false");
            request.setAttribute("sourceImageWidth", (Object)"0");
            request.setAttribute("sourceImageHeight", (Object)"0");
        }
        return "shr/base/upload";
    }

    @RequestMapping(params={"method=initLogoUploadDialog"})
    @Action
    public String initLogoUploadDialog(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, IOException {
        request.setAttribute(PSERSONID, (Object)"null");
        request.setAttribute("id", (Object)"null");
        request.setAttribute("hasImg", (Object)"false");
        request.setAttribute("sourceImageWidth", (Object)"0");
        request.setAttribute("sourceImageHeight", (Object)"0");
        return "shr/base/logoUpload";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(params={"method=uploadSrcImage"})
    @Action
    public String uploadSrcImage(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, IOException {
        String contentType = request.getContentType();
        FileModel fileModel = null;
        String personId = request.getParameter(PSERSONID);
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            MultipartFile multipartFile = multipartHttpServletRequest.getFile("upload");
            String originalFilename = multipartFile.getOriginalFilename();
            String imgContentType = null;
            OutputStream os = null;
            InputStream is = null;
            try {
                if (multipartFile.getSize() > 0x200000L) {
                    throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "illegal_file_size", "2M"));
                }
                StringUtil4File.checkInvalidCharsInFileName((String)originalFilename);
                String imageType = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                boolean flag = false;
                if ("jpeg".equalsIgnoreCase(imageType) || "jpg".equalsIgnoreCase(imageType) || "png".equalsIgnoreCase(imageType)) {
                    flag = true;
                }
                if (!flag) {
                    throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "illegal_file_type"));
                }
                String serverPath = request.getRealPath("/") + "uploadFoler" + File.separator;
                File newFolder = new File(serverPath);
                if (!newFolder.exists()) {
                    newFolder.mkdir();
                }
                String targetFileName = this.generateFileName(multipartFile.getOriginalFilename());
                File target = new File(serverPath, targetFileName);
                os = new FileOutputStream(target);
                is = multipartFile.getInputStream();
                int inslen = 0;
                byte[] insbuf = new byte[1024];
                while ((inslen = is.read(insbuf, 0, 1024)) != -1) {
                    os.write(insbuf, 0, inslen);
                }
                os.flush();
                imgContentType = "image/" + imageType;
                fileModel = this.buildFileModel4Upload(imgContentType, target);
            }
            catch (IOException e) {
                request.setAttribute("uploadState", (Object)"false");
                request.setAttribute("oper", (Object)"uploadSrcImgDone");
                String string = "shr/base/result";
                return string;
            }
            catch (EASBizException | ShrWebBizException e1) {
                request.setAttribute("uploadState", (Object)"false");
                request.setAttribute("oper", (Object)"uploadSrcImgDone");
                request.setAttribute("errorMessage", (Object)e1.getMessage());
                String string = "shr/base/result";
                return string;
            }
            finally {
                if (null != os) {
                    os.close();
                }
                if (null != is) {
                    is.close();
                }
            }
            request.getSession().setAttribute("last_image_source_contenttype", (Object)imgContentType);
        }
        request.setAttribute("uploadState", (Object)"true");
        request.setAttribute("oper", (Object)"uploadSrcImgDone");
        request.setAttribute(PSERSONID, (Object)personId);
        String lastUploadImgKey = String.format("%s%s", "last_upload_img_key", personId);
        request.getSession().setAttribute(lastUploadImgKey, fileModel);
        return "shr/base/result";
    }

    @RequestMapping(params={"method=showSrcImage"})
    @Action
    public void showSrcImage(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        String personId = request.getParameter(PSERSONID);
        String lastUploadImgKey = String.format("%s%s", "last_upload_img_key", personId);
        FileModel fileModel = (FileModel)request.getSession().getAttribute(lastUploadImgKey);
        if (null != fileModel) {
            File tempTempImg = new File(fileModel.getUploadFilePath());
            byte[] fileContent = this.getFileContent(tempTempImg);
            this.writeResponse(response, fileModel.getUploadContentType(), fileContent);
        } else {
            byte[] imgDataSource = (byte[])request.getSession().getAttribute("last_image_source");
            String imageContentType = (String)request.getSession().getAttribute("last_image_source_contenttype");
            this.writeResponse(response, imageContentType, imgDataSource);
        }
    }

    @RequestMapping(params={"method=showImageAuditStatus"})
    @Action
    public void showImageAuditStatus(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException {
        Context ctx = SHRContext.getInstance().getContext();
        HttpSession session = request.getSession();
        String searchRandomKey = request.getParameter("onceKey");
        String personId = this.getPersonID(ctx, request);
        String sessionKey = String.format("%s%s", "onceKey", personId);
        HashMap serverSearchRandomKey = null;
        if (session.getAttribute(sessionKey) instanceof HashMap) {
            serverSearchRandomKey = (HashMap)session.getAttribute("onceKey" + personId);
        }
        HashMap data = new HashMap();
        if (this.isNotTemper(searchRandomKey, serverSearchRandomKey) && !StringUtils.isEmpty((String)((String)serverSearchRandomKey.get("auditStatus")))) {
            String auditStatus = (String)serverSearchRandomKey.get("auditStatus");
            try {
                data = com.kingdee.bos.json.JSONUtils.convertJsonToObject((Context)ctx, (String)auditStatus);
            }
            catch (BOSException e) {
                throw new ShrWebBizException(e.getMessage(), e);
            }
        }
        if (data.isEmpty() && this.isShowAuditPhoto(ctx, request)) {
            data = PersonPhotoAuditUtil.assembleAuditPhotoStatus((Context)ctx, (String)personId);
        }
        JSONUtils.SUCCESS(data);
    }

    @RequestMapping(params={"method=confirmAuditPhotoData"})
    @Action
    public void confirmAuditPhotoData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            String personId = this.getPersonID(ctx, request);
            String auditDataId = request.getParameter("auditDataId");
            if (StringUtils.isEmpty((String)auditDataId)) {
                JSONUtils.ERROR("auditDataId is null");
                return;
            }
            EntityViewInfo audit = new EntityViewInfo();
            FilterInfo auditFilter = new FilterInfo();
            FilterItemCollection filterItemColl = auditFilter.getFilterItems();
            filterItemColl.add(new FilterItemInfo("person", (Object)personId));
            filterItemColl.add(new FilterItemInfo("id", (Object)auditDataId));
            audit.setFilter(auditFilter);
            EmployeeAuditCollection coll = EmployeeAuditFactory.getLocalInstance((Context)ctx).getEmployeeAuditCollection(audit);
            if (coll.isEmpty()) {
                JSONUtils.ERROR("can not confirm this auditDataId:" + auditDataId);
                return;
            }
            EmployeeAuditInfo info = coll.get(0);
            if (EmployeeAuditStateEnum.UNPASSED.equals((Object)info.getStatus())) {
                EmployeeAuditFactory.getLocalInstance((Context)ctx).confirmEmployeeAuditData((IObjectPK)new ObjectUuidPK(auditDataId));
            }
            JSONUtils.SUCCESS(true);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    @RequestMapping(params={"method=abortAuditPhotoData"})
    @Action
    public void abortAuditPhotoData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException {
        try {
            Object[] pks;
            Context ctx = SHRContext.getInstance().getContext();
            String personId = this.getPersonID(ctx, request);
            String auditDataId = request.getParameter("auditDataId");
            if (StringUtils.isEmpty((String)auditDataId)) {
                JSONUtils.ERROR("auditDataId is null");
                return;
            }
            EntityViewInfo audit = new EntityViewInfo();
            FilterInfo auditFilter = new FilterInfo();
            FilterItemCollection filterItemColl = auditFilter.getFilterItems();
            filterItemColl.add(new FilterItemInfo("person", (Object)personId));
            filterItemColl.add(new FilterItemInfo("id", (Object)auditDataId));
            audit.setFilter(auditFilter);
            EmployeeAuditCollection coll = EmployeeAuditFactory.getLocalInstance((Context)ctx).getEmployeeAuditCollection(audit);
            if (coll.isEmpty()) {
                JSONUtils.ERROR("can not abort this auditDataId:" + auditDataId);
                return;
            }
            EmployeeAuditInfo info = coll.get(0);
            if (EmployeeAuditStateEnum.SUBMITED.equals((Object)info.getStatus()) && (pks = EmployeeAuditFactory.getLocalInstance((Context)ctx).delete(auditFilter)).length > 0) {
                FilterInfo deleteFilter = new FilterInfo();
                deleteFilter.getFilterItems().add(new FilterItemInfo("parent", (Object)Sets.newHashSet((Object[])pks), CompareType.INCLUDE));
                AuditPersonPhotoFactory.getLocalInstance((Context)ctx).delete(deleteFilter);
            }
            JSONUtils.SUCCESS(true);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    @RequestMapping(params={"method=showCutImage"})
    @Action
    public void showCutImage(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, IOException, BOSException {
        Context ctx = SHRContext.getInstance().getContext();
        HttpSession session = request.getSession();
        String searchRandomKey = request.getParameter("onceKey");
        String personId = this.getPersonID(ctx, request);
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo personInfo = null;
        try {
            boolean exists = iPerson.exists((IObjectPK)new ObjectStringPK(personId));
            if (exists) {
                personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectStringPK(personId));
            }
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (personInfo != null) {
            result.put("gender", personInfo.getGender());
            result.put("name", personInfo.getName());
        } else {
            result.put("gender", "");
            result.put("name", "");
        }
        if (!StringUtils.isEmpty((String)personId)) {
            IPersonPhoto personPhoto = PersonPhotoFactory.getLocalInstance((Context)ctx);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            CoreBaseCollection coll = new CoreBaseCollection();
            coll = this.isShowAuditPhoto(ctx, request) ? personPhoto.getAuditPersonPhoto(personId) : personPhoto.getCollection(entityViewInfo);
            PersonPhotoInfo personPhotoInfo = null;
            if (coll.size() > 0) {
                personPhotoInfo = (PersonPhotoInfo)coll.get(0);
                request.setAttribute("id", (Object)personPhotoInfo.getId());
                request.setAttribute(PSERSONID, (Object)personId);
                if (personPhotoInfo.getImageData() != null) {
                    HashMap<String, String> idAndKey = new HashMap<String, String>(2);
                    byte[] fileContent = personPhotoInfo.getImageData();
                    String ContentType = personPhotoInfo.getImageContentType();
                    this.writeResponse(response, ContentType, fileContent);
                    idAndKey.put(PSERSONID, personId);
                    idAndKey.put("onceKey", searchRandomKey);
                    idAndKey.put("auditStatus", personPhotoInfo.get(PersonPhotoAuditUtil.PHOTOAUDITFLAG) != null ? JSON.toJSONString((Object)personPhotoInfo.get(PersonPhotoAuditUtil.PHOTOAUDITFLAG)) : "");
                    session.setAttribute("onceKey" + personId, idAndKey);
                } else {
                    result.put("hasImageData", "false");
                    JSONUtils.SUCCESS(result);
                }
            } else {
                result.put("hasImageData", "false");
                JSONUtils.SUCCESS(result);
            }
        } else {
            result.put("hasImageData", "false");
            JSONUtils.SUCCESS(result);
        }
        String lastUploadImgKey = String.format("%s%s", "last_upload_img_key", personId);
        session.removeAttribute(lastUploadImgKey);
    }

    private boolean isShowAuditPhoto(Context ctx, HttpServletRequest request) throws SHRWebException {
        String refferer = request.getHeader("Referer");
        String uipk = SHRPermissionWebUtils.getUipkByUrl(refferer);
        if (!StringUtils.isEmpty((String)uipk) && "shr.perself.homepage".equals(uipk)) {
            return false;
        }
        PermItemInfo pi = SHRPermissionWebUtils.getPermItemByReferer(ctx, refferer);
        UIViewInfo view = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
        boolean photoRequireAudit = false;
        if (view instanceof FormUIViewInfo) {
            FormUIViewInfo formView = (FormUIViewInfo)view;
            photoRequireAudit = formView.isPhotoRequireAudit();
        }
        return null != pi && OrgType.NONE.equals((Object)pi.getOrgRelation()) && photoRequireAudit;
    }

    private byte[] reducePhoto(byte[] imageData) throws IOException {
        int nwidth = 100;
        int nheight = 120;
        BufferedImage read = ImageIO.read(new ByteArrayInputStream(imageData));
        Image scaledInstance = read.getScaledInstance(nwidth, nheight, 4);
        BufferedImage tag = new BufferedImage(nwidth, nheight, 1);
        tag.getGraphics().drawImage(scaledInstance, 0, 0, null);
        tag.getGraphics().dispose();
        tag.flush();
        read.flush();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)tag, "JPEG", output);
        byte[] byteArray = output.toByteArray();
        output.close();
        read = null;
        tag = null;
        System.gc();
        return byteArray;
    }

    protected void writeResponse(HttpServletResponse response, String contentType, byte[] result) {
        try {
            response.setHeader("cache-control", "no-cache");
            response.setHeader("charset", "UTF-8");
            response.setContentType(contentType);
            response.getOutputStream().write(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getFileContent(File file) {
        byte[] data = null;
        InputStream in = null;
        try {
            if (!file.exists()) {
                byte[] byArray = null;
                return byArray;
            }
            in = new FileInputStream(file.getAbsolutePath());
            data = new byte[in.available()];
            in.read(data);
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            this.logger.error((Object)"getFileContent error", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    protected String generateFileName(String fileName) {
        int position = fileName.lastIndexOf(".");
        String extension = fileName.substring(position);
        return System.currentTimeMillis() + extension;
    }

    private FileModel buildFileModel4Upload(String contentType, File target) throws FileNotFoundException, IOException, SHRWebException {
        FileModel fileModel = new FileModel();
        fileModel.setUploadFilePath(target.getAbsolutePath());
        fileModel.setUploadContentType(contentType);
        return fileModel;
    }

    private void deletedFile(String subPath) {
        File deletedFile = new File(subPath);
        File[] files = deletedFile.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].exists() || !files[i].isFile()) continue;
                files[i].delete();
            }
        }
        if (deletedFile.exists()) {
            deletedFile.delete();
        }
    }

    @RequestMapping(params={"method=uploadEndImage"})
    @Action
    public String uploadEndImage(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws FileNotFoundException, IOException, SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String personId = this.getPersonID(ctx, request);
        String id = request.getParameter("id");
        if ("null".equals(personId) || personId == null || personId.length() == 0) {
            request.setAttribute("uploadState", (Object)"false");
            request.setAttribute("oper", (Object)"uploadEndImgFail");
            return "shr/base/result";
        }
        try {
            String imageContentType;
            String imageBase64 = request.getParameter("croppedImgData");
            imageBase64 = imageBase64.split(";")[1];
            imageBase64 = imageBase64.split(",")[1];
            byte[] data = Base64.decodeBase64((String)imageBase64);
            for (int i = 0; i < data.length; ++i) {
                if (data[i] >= 0) continue;
                int n = i;
                data[n] = (byte)(data[n] + 256);
            }
            int height = (int)Float.parseFloat(request.getParameter("cropModel.height"));
            int width = (int)Float.parseFloat(request.getParameter("cropModel.width"));
            String lastUploadImgKey = String.format("%s%s", "last_upload_img_key", personId);
            FileModel fm = (FileModel)request.getSession().getAttribute(lastUploadImgKey);
            File file = null;
            if (fm != null && fm.getUploadFilePath() != null) {
                file = new File(fm.getUploadFilePath());
            }
            if ("image/jpg".equalsIgnoreCase(imageContentType = (String)request.getSession().getAttribute("last_image_source_contenttype"))) {
                imageContentType = "image/jpeg";
            }
            PersonPhotoInfo personPhotoInfo = new PersonPhotoInfo();
            personPhotoInfo.setImageData(data);
            if (fm != null && fm.getUploadFilePath() != null) {
                personPhotoInfo.setImageDataSource(this.getFileContent(file));
            } else {
                personPhotoInfo.setImageDataSource((byte[])request.getSession().getAttribute("last_image_source"));
            }
            personPhotoInfo.setSourceImageWidth(width);
            personPhotoInfo.setSourceImageHeight(height);
            personPhotoInfo.setImageContentType(imageContentType);
            PersonInfo pi = new PersonInfo();
            pi.setId(BOSUuid.read((String)personId));
            if ("null".equals(id) || id == null || id.length() == 0) {
                personPhotoInfo.setPerson(pi);
            } else {
                personPhotoInfo.setPerson(pi);
                personPhotoInfo.setId(BOSUuid.read((String)id));
            }
            if (this.isShowAuditPhoto(ctx, request)) {
                PersonPhotoFactory.getLocalInstance((Context)ctx).saveAuditPersonPhoto(personPhotoInfo);
            } else {
                PersonPhotoFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)personPhotoInfo);
            }
            request.setAttribute("uploadState", (Object)"true");
            request.setAttribute("oper", (Object)"uploadEndImgDone");
            if (file != null && file.exists() && file.isFile()) {
                file.delete();
            } else {
                FileModel tempFm = new FileModel();
                tempFm.setWidth(0);
                tempFm.setHeight(0);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("head uploadEndImage error: " + e.getMessage()), (Throwable)e);
            request.setAttribute("uploadState", (Object)"false");
            request.setAttribute("oper", (Object)"uploadEndImgFail");
        }
        return "shr/base/result";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(params={"method=batchImportPhoto"})
    @Action
    public void batchImportPhoto(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        String contentType = request.getContentType();
        if (contentType == null || contentType.indexOf("multipart/form-data") == -1) {
            return;
        }
        MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
        MultipartFile multipartFile = multipartHttpServletRequest.getFile("batchImportPackage");
        String serverPath = request.getRealPath("/") + "newZipFoler" + File.separator;
        this.deletedFile(serverPath);
        File newFolder = new File(serverPath);
        newFolder.mkdir();
        File unZipFile = new File(serverPath + "index.zip");
        FileOutputStream ops = null;
        InputStream inputs = null;
        try {
            ops = new FileOutputStream(unZipFile);
            inputs = multipartFile.getInputStream();
            int inslen = 0;
            byte[] insbuf = new byte[1024];
            while ((inslen = inputs.read(insbuf, 0, 1024)) != -1) {
                ((OutputStream)ops).write(insbuf, 0, inslen);
            }
        }
        finally {
            if (inputs != null) {
                try {
                    inputs.close();
                }
                finally {
                    if (ops != null) {
                        ((OutputStream)ops).close();
                    }
                }
            }
        }
        ZipFile zfile = new ZipFile(unZipFile, "GBK");
        Enumeration zList = zfile.getEntries();
        ZipEntry ze = null;
        ArrayList<String> errorfileList = new ArrayList<String>();
        while (zList.hasMoreElements()) {
            ze = (ZipEntry)zList.nextElement();
            try {
                if (this.handlerFile(zfile, ze)) continue;
                errorfileList.add(ze.getName());
                this.logger.error((Object)("head sculptrue import fail: " + ze.getName()));
            }
            catch (Exception e) {
                this.logger.error((Object)("head sculptrue import fail: " + ze.getName()), (Throwable)e);
                errorfileList.add(ze.getName());
            }
        }
        zfile.close();
        JSONUtils.SUCCESS(errorfileList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handlerFile(ZipFile zfile, ZipEntry ze) throws Exception {
        boolean isImage;
        String zeName = ze.getName();
        if (zeName.contains("/") && StringUtils.isEmpty((String)(zeName = zeName.substring(zeName.lastIndexOf("/") + 1, zeName.length())))) {
            return true;
        }
        String fileName = zeName.substring(0, zeName.lastIndexOf("."));
        String typeName = zeName.substring(zeName.lastIndexOf(".") + 1, zeName.length());
        if (StringUtils.isEmpty((String)typeName) || StringUtils.isEmpty((String)fileName)) {
            return false;
        }
        boolean bl = isImage = typeName.equalsIgnoreCase("jpg") || typeName.equalsIgnoreCase("png") || typeName.equalsIgnoreCase("jpeg") || typeName.equalsIgnoreCase("bmp");
        if (!isImage) {
            return false;
        }
        ByteArrayOutputStream os = null;
        BufferedInputStream is = null;
        try {
            os = new ByteArrayOutputStream();
            is = new BufferedInputStream(zfile.getInputStream(ze));
            int readLen = 0;
            byte[] buf = new byte[1024];
            while ((readLen = is.read(buf, 0, 1024)) != -1) {
                os.write(buf, 0, readLen);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return this.insertPersonPhoto(fileName, typeName, os.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertPersonPhoto(String fileName, String fileType, byte[] fileData) throws Exception {
        Context ctx = SHRContext.getInstance().getContext();
        IPersonPhoto iPP = PersonPhotoFactory.getLocalInstance((Context)ctx);
        HashMap reMap = iPP.getPersonDetailInfo();
        ArrayList personList = (ArrayList)reMap.get("personList");
        if (personList == null) {
            return false;
        }
        PersonInfo person = null;
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPk = null;
        int size = personList.size();
        for (int i = 0; i < size; ++i) {
            person = (PersonInfo)personList.get(i);
            if (fileName.equals(person.getNumber()) || fileName.equals(person.getName())) {
                orgPk = new ObjectUuidPK(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
                permission.checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "image_in_out"));
                break;
            }
            person = null;
        }
        if (person == null) {
            return false;
        }
        BufferedImage image = null;
        try {
            PersonPhotoInfo ppInfo = new PersonPhotoInfo();
            ppInfo.setPerson(person);
            ppInfo.setImageDataSource(fileData);
            ppInfo.setImageData(this.reducePhoto(fileData));
            image = ImageIO.read(new ByteArrayInputStream(fileData));
            ppInfo.setSourceImageHeight(image.getHeight());
            ppInfo.setSourceImageWidth(image.getWidth());
            String imgContentType = "image/" + fileType;
            ppInfo.setImageContentType(imgContentType);
            iPP.addnew((CoreBaseInfo)ppInfo);
            image.flush();
            boolean bl = true;
            return bl;
        }
        finally {
            image = null;
            System.gc();
        }
    }

    @RequestMapping(params={"method=batchExportPhoto"})
    @Action
    public void batchExportPhoto(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, EASBizException, SHRWebException {
        HttpSession session;
        Context ctx = SHRContext.getInstance().getContext();
        String exportByPersonList = request.getParameter("exportByPersonList");
        HashMap map = null;
        String fileName = null;
        IPersonPhoto iPP = PersonPhotoFactory.getLocalInstance((Context)ctx);
        if ("true".equals(exportByPersonList)) {
            String sql = this.getExportFilterSqlByPersonList(request);
            if (StringUtils.isEmpty((String)sql)) {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "sql_cache_insession"));
            }
            String fromSql = sql.substring(sql.indexOf("FROM"));
            sql = "select \"PERSON\".FID " + fromSql;
            session = request.getSession();
            fileName = (String)session.getAttribute("photoName");
            if (fileName == null || fileName.equals("")) {
                fileName = !System.getProperty("os.name").substring(0, 7).equalsIgnoreCase("WINDOWS") ? "personPhotos" : SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "all_list_picture");
            }
            map = iPP.getPersonPhotoDataByPersonFilter(sql);
        } else {
            String adminOrgID = request.getParameter("adminOrgID");
            String adminOrgLongNumber = request.getParameter("adminOrgLongNumber");
            fileName = request.getParameter("adminOrgName");
            session = request.getSession();
            fileName = (String)session.getAttribute("photoName");
            if ((fileName == null || fileName.equals("")) && !System.getProperty("os.name").substring(0, 7).equalsIgnoreCase("WINDOWS")) {
                fileName = adminOrgLongNumber.lastIndexOf("!") > 0 ? adminOrgLongNumber.substring(adminOrgLongNumber.lastIndexOf("!") + 1) : adminOrgLongNumber;
            }
            String isContainsSub = request.getParameter("isContainsSub");
            AdminOrgUnitInfo paramAdmin = new AdminOrgUnitInfo();
            paramAdmin.setId(BOSUuid.read((String)adminOrgID));
            paramAdmin.setLongNumber(adminOrgLongNumber);
            map = iPP.getPersonPhotoDataByAdmin(paramAdmin, Boolean.parseBoolean(isContainsSub));
        }
        if (map == null || map.isEmpty()) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "no_picture_export"));
        }
        OutputStream out = null;
        try {
            WebUtil.setFileResponseHeader(request, response, fileName + ".zip");
            Iterator it = map.keySet().iterator();
            out = response.getOutputStream();
            ZipOutputStream zipOutStream = new ZipOutputStream(out);
            java.util.zip.ZipEntry zipEntry = null;
            while (it.hasNext()) {
                PersonInfo person = (PersonInfo)it.next();
                String personNumberStr = person.getNumber().replaceAll("/", "").trim();
                personNumberStr = personNumberStr + ".jpg";
                zipEntry = new java.util.zip.ZipEntry(personNumberStr);
                zipOutStream.putNextEntry(zipEntry);
                byte[] data = (byte[])map.get(person);
                zipOutStream.write(data);
            }
            zipOutStream.closeEntry();
            zipOutStream.close();
        }
        catch (Exception e) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "picture_download_fail"), e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private String getExportFilterSqlByPersonList(HttpServletRequest request) throws BOSException {
        Map storeData;
        Map storeDatas = (Map)request.getSession().getAttribute("query_store_data");
        if (null != storeDatas && null != (storeData = (Map)storeDatas.get(request.getParameter("queryUuid")))) {
            String querySql = (String)storeData.get("query_sql");
            return querySql;
        }
        return null;
    }

    public String fastParseFileType(byte[] byte1) {
        if (byte1[0] == 71 && byte1[1] == 73 && byte1[2] == 70 && byte1[3] == 56 && (byte1[4] == 55 || byte1[4] == 57) && byte1[5] == 97) {
            return "gif";
        }
        if (byte1[6] == 74 && byte1[7] == 70 && byte1[8] == 73 && byte1[9] == 70) {
            return "jpg";
        }
        if (byte1[0] == 66 && byte1[1] == 77) {
            return "bmp";
        }
        if (byte1[1] == 80 && byte1[2] == 78 && byte1[3] == 71) {
            return "png";
        }
        return "jpg";
    }

    public byte[] convertFileTOBytes(File file) throws Exception {
        if (file != null) {
            int size = (int)file.length();
            try (FileInputStream fin = null;){
                fin = new FileInputStream(file);
                byte[] bts = null;
                if (size > 0) {
                    bts = new byte[size];
                    fin.read(bts);
                    byte[] byArray = bts;
                    return byArray;
                }
            }
        }
        return null;
    }
}

