/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.sso.client.util.SSOLogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.util.AutoLoginConfigPropUtil;
import com.kingdee.eas.cp.eip.sso.util.LoginUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.LicenseHelper;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SystemContextUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.guilogin.EASServiceHelper;
import com.kingdee.shr.webservice.utils.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Controller
@RequestMapping(value={"/mulLan"})
public class MultipleLanSwitchController {
    private static Logger logger = LoggerFactory.getLogger(MultipleLanSwitchController.class);

    @RequestMapping(params={"method=switch"})
    public String switchLan(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        Context ctx = SHRContext.getInstance().getContext();
        String datacenter = ctx.getAIS();
        String dbType = ContextUtil.getDbType((Context)ctx);
        if (StringUtils.isEmpty((String)dbType)) {
            dbType = SystemContextUtil.getDbTypeByDataCenter((String)ctx.getAIS());
        }
        String locale = request.getParameter("locale");
        String redirectTo = request.getParameter("targetUrl");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userName = userInfo.getNumber();
        String currentWorkPlatformId = (String)request.getSession().getAttribute("currentWorkPlatformId");
        try {
            this.logoutAndReleaseResource(request);
            this.login(request, response, datacenter, dbType, userName, locale);
            request.getSession().setAttribute("currentWorkPlatformId", (Object)currentWorkPlatformId);
            response.sendRedirect(SHRCheck.checkUrlParamsForSendRedirect((String)redirectTo));
        }
        catch (BOSException e) {
            logger.error("multiLanChanging logout or login error!");
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("multiLanChanging redirect error, url=" + SHRCheck.vaildLog((String)redirectTo));
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("multiLanChanging login error, username=" + userName + ",datacenter=" + datacenter + ",locale=" + SHRCheck.vaildLog((String)locale));
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SHRWebException e) {
            logger.error("multiLanChanging login error, username=" + userName + ",datacenter=" + datacenter + ",locale=" + SHRCheck.vaildLog((String)locale));
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private Context login(HttpServletRequest request, HttpServletResponse response, String datacenter, String dbType, String userName, String locale) throws EASBizException, BOSException, SHRWebException {
        HashMap<String, String> attribute = new HashMap<String, String>();
        attribute.put("userAuthPattern", AutoLoginConfigPropUtil.getAuthPattern());
        attribute.put("dataCenter", StringUtils.isEmpty((String)datacenter) ? AutoLoginConfigPropUtil.getDataCenter() : datacenter);
        attribute.put("dbType", dbType);
        attribute.put("locale", StringUtils.isEmpty((String)locale) ? AutoLoginConfigPropUtil.getLocale() : locale);
        attribute.put("solutionName", "eas");
        attribute.put("isPureWeb", "true");
        Context ctx = LoginUtil.createEasContext((String)userName, attribute, (HttpServletRequest)request);
        if (ctx != null) {
            logger.info("relogin success, locale =" + ctx.getLocale().getLanguage() + ",username" + ctx.getUserName() + ",datacenter=" + ctx.getAIS());
        }
        Locale.setDefault(new Locale(locale));
        HRFilterUtils.initOrgUnit((Context)ctx);
        ConfigMDUtil.setContextToThread((Context)ctx);
        SHRContext.getInstance().setContext(ctx);
        UIViewUtil.cleanViewInfo();
        FreeMarkerConfigurer freeMarkerConfig = (FreeMarkerConfigurer)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)((ApplicationContext)request.getSession().getServletContext().getAttribute("org.springframework.web.servlet.FrameworkServlet.CONTEXT.MVCServlet")), FreeMarkerConfig.class, (boolean)true, (boolean)false);
        freeMarkerConfig.getConfiguration().clearTemplateCache();
        MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).clearAll();
        return ctx;
    }

    private String logoutAndReleaseResource(HttpServletRequest request) throws BOSException {
        HttpSession session = request.getSession();
        if (session == null) {
            return null;
        }
        try {
            LicenseHelper.releaseLicenseBySessionID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            if (ctx != null) {
                SessionInfo bossession;
                if (logger.isDebugEnabled()) {
                    String[] names;
                    for (String key : names = session.getValueNames()) {
                        logger.debug(key + "=" + session.getAttribute(key));
                    }
                }
                if ((bossession = SessionManager.getInstance().getSession(ctx.getContextID())) != null) {
                    SessionManager.getInstance().removeSession(ctx.getContextID());
                    ((LoginContext)bossession.get((Object)"LoginContext")).logout();
                }
                SSOLogUtil.logLogout((Context)ctx);
                EASServiceHelper helper = new EASServiceHelper();
                helper.deleteUserMonitor(request);
            } else {
                logger.error("easserviceimpl deleteUserMonitor ctx is null!");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("session = " + session);
                logger.debug("request.getSession()=" + request.getSession());
            }
            session.setAttribute("UserContext", null);
            session.setAttribute("org.apache.struts.action.LOCALE", null);
            session.setAttribute("pureWebContext", null);
            session.setAttribute("_const_cas_assertion_", null);
            session.setAttribute("userInfo", null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @RequestMapping(params={"method=updateBreadcrumb"})
    public String updateBreadcrumb(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        ArrayList<String> names = new ArrayList<String>();
        String locale = request.getParameter("locale");
        String uipks = request.getParameter("uipks");
        String operateState = request.getParameter("operateState");
        try {
            String[] uipkArr;
            Context ctx = SHRContext.getInstance().getContext();
            Locale old = ctx.getLocale();
            ctx.setLocale(LocaleUtils.getLocale((String)locale));
            if (!StringUtils.isEmpty((String)uipks) && (uipkArr = uipks.split(",")) != null && uipkArr.length > 0) {
                for (String uipk : uipkArr) {
                    UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
                    if (uiViewInfo != null) {
                        names.add(uiViewInfo.getViewTitle());
                        continue;
                    }
                    names.add("");
                }
            }
            if (!StringUtils.isEmpty((String)operateState) && operateState.equalsIgnoreCase("ADDNEW") && names.size() > 1) {
                names.remove(names.get(names.size() - 1));
                names.add(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"create", (Locale)ctx.getLocale()));
            }
            ctx.setLocale(old);
            JSONUtils.writeJson(response, names);
        }
        catch (SHRWebException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

