/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.view.ListController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/objectHistoryList"})
public class ObjectHistoryListController
extends ListController {
    private static final Logger logger = Logger.getLogger(ObjectHistoryListController.class);

    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String billId = request.getParameter("billId");
        if (!StringUtils.isEmpty((String)billId)) {
            modelMap.put((Object)"uipk", (Object)request.getParameter("uipk"));
            modelMap.put((Object)"billId", (Object)URLEncoder.encode(billId));
        }
        return "/framework/objectHistoryList";
    }

    @Override
    public String getListData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        String billId = request.getParameter("billId");
        int rows = Integer.parseInt(request.getParameter("rows"));
        int page = Integer.parseInt(request.getParameter("page"));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo(HistoryConstant.EFFDT));
        sic.add(new SelectorItemInfo(HistoryConstant.LEFFDT));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        entityViewInfo.setSelector(sic);
        if (!StringUtils.isEmpty((String)request.getParameter("sidx"))) {
            String sorterItems = request.getParameter("sidx") + " " + request.getParameter("sord");
            try {
                SorterItemCollection sorters = new SorterItemCollection();
                sorters.getSorter().decode("order by " + sorterItems);
                entityViewInfo.setSorter(sorters);
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        ICoreBase iCoreBase = this.getBizinterface(request, billId);
        List historys = this.getObjectHistoryRecords(iCoreBase, billId, entityViewInfo, (page - 1) * rows, rows);
        GridDataEntity gridData = this.assembleGridData(historys);
        int totalCount = this.getObjectHistoryRecordsCount(iCoreBase, billId, entityViewInfo);
        if (totalCount % rows == 0) {
            gridData.setTotal(totalCount / rows);
        } else {
            gridData.setTotal(totalCount / rows + 1);
        }
        gridData.setRecords(totalCount);
        gridData.setPage(page);
        JSONUtils.writeJson(response, gridData);
        return null;
    }

    private ICoreBase getBizinterface(HttpServletRequest request, String billId) throws SHRWebException {
        String uipk = request.getParameter("uipk");
        UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(SHRContext.getInstance().getContext(), uipk);
        String view_model = uiViewInfo.getModel();
        ICoreBase iCoreBase = null;
        try {
            if (!StringUtils.isEmpty((String)view_model)) {
                iCoreBase = MetaDataUtil.getBizInterface(view_model);
            }
            if (iCoreBase == null) {
                iCoreBase = MetaDataUtil.getBizInterface(BOSUuid.read((String)billId).getType());
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        return iCoreBase;
    }

    private List getObjectHistoryRecords(ICoreBase iCoreBase, String billId, EntityViewInfo entityViewInfo, int start, int length) throws SHRWebException {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(billId);
            return iCoreBase.getAllHisVersionReturnCurrentPaging((IObjectPK)pk, entityViewInfo, start, length);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (UuidException e) {
            throw new SHRWebException(e);
        }
        catch (EASBizException e) {
            throw new SHRWebException(e);
        }
    }

    private int getObjectHistoryRecordsCount(ICoreBase iCoreBase, String billId, EntityViewInfo entityViewInfo) throws SHRWebException {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(billId);
            return iCoreBase.getAllHistoryVersionCount((IObjectPK)pk, entityViewInfo);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (UuidException e) {
            throw new SHRWebException(e);
        }
        catch (EASBizException e) {
            throw new SHRWebException(e);
        }
    }

    private GridDataEntity assembleGridData(List historys) {
        GridDataEntity gridData = new GridDataEntity();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Object obj : historys) {
            result.add(this.assembleGridDataItem(obj));
        }
        gridData.setRows(result);
        return gridData;
    }

    private Map<String, Object> assembleGridDataItem(Object obj) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)obj;
        item.put("id", coreBaseInfo.get(HistoryConstant.historyRelateID));
        item.put(HistoryConstant.EFFDT, DateTimeUtils.formatDate((Date)((Date)coreBaseInfo.get(HistoryConstant.EFFDT))));
        item.put("lastUpdateTime", DateTimeUtils.formatDate((Date)((Date)coreBaseInfo.get("lastUpdateTime"))));
        UserInfo userInfo = (UserInfo)coreBaseInfo.get("lastUpdateUser");
        item.put("lastUpdateUser", userInfo.getPerson() != null ? userInfo.getPerson().getName() : userInfo.getName());
        Date leffdt = (Date)coreBaseInfo.get(HistoryConstant.LEFFDT);
        item.put("isNewest", HistoryUtil.getMaxDate().equals(leffdt));
        return item;
    }

    @Override
    protected String getEditUrl(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        return null;
    }

    @Override
    protected String getViewUrl(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws SHRWebException, ShrWebBizException {
        return null;
    }

    @Override
    protected IMetaDataPK getQueryPK() throws SHRWebException, ShrWebBizException {
        return null;
    }
}

