/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.DataObject;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.permission.field.QueryType;
import com.kingdee.shr.base.permission.field.ShrFieldPerm;
import com.kingdee.shr.base.syssetting.ISearchView;
import com.kingdee.shr.base.syssetting.SearchViewCollection;
import com.kingdee.shr.base.syssetting.SearchViewFactory;
import com.kingdee.shr.base.syssetting.SearchViewInfo;
import com.kingdee.shr.base.syssetting.annotation.Action;
import com.kingdee.shr.base.syssetting.component.commonquery.CommonQueryHelper;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.log.OperateLogManager;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.sensitive.IShrSensitiveService;
import com.kingdee.shr.base.syssetting.sensitive.ShrSensitiveServiceFactory;
import com.kingdee.shr.base.syssetting.util.DataTypeUtil;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.PromptF7FastFilterUtils;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBaseItemUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.IListUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.ISearchUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.ListFieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.ListUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.QuerySolutionInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.SearchUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.handler.CoreHandler;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.common.util.SHREnumUtil;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.StringEnum;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="com.kingdee.shr.base.syssetting.web.PromptF7Controller")
@RequestMapping(value={"/promptF7"})
public class PromptF7Controller
extends WebComponentController {
    Logger logger = LoggerFactory.getLogger(PromptF7Controller.class);

    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        long startTime = System.currentTimeMillis();
        String uipk = request.getParameter("uipk");
        String query = request.getParameter("query");
        String botp = request.getParameter("botp");
        List<Object> colModel = new ArrayList();
        Context ctx = SHRContext.getInstance().getContext();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        QueryType queryType = null;
        String queryValue = null;
        String modelName = null;
        if (!StringUtils.isEmpty((String)query)) {
            colModel = this.getColModel(ctx, query, uipk);
            queryType = QueryType.QUERY;
            queryValue = query;
        } else if (!StringUtils.isEmpty((String)uipk)) {
            Element grid;
            ListUIViewInfo uiViewInfo = (ListUIViewInfo)UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
            List<FieldInfo> fields = uiViewInfo.getFields();
            HashMap<String, Object> formatoptions = null;
            Map<String, String> attributes = null;
            HashMap<String, Object> data = null;
            DataType dataType = null;
            modelName = uiViewInfo.getModel();
            if (!StringUtils.isEmpty((String)uiViewInfo.getQuery())) {
                queryType = QueryType.QUERY;
                queryValue = uiViewInfo.getQuery();
            } else {
                queryType = QueryType.ENTITY;
            }
            for (FieldInfo fieldInfo : fields) {
                data = new HashMap<String, Object>();
                data.put("columnName", fieldInfo.getName());
                boolean encryptField = UIViewUtil.isEncryptField(ctx, uipk, fieldInfo.getName());
                data.put("isEncryptField", encryptField);
                data.put("label", fieldInfo.getAlias());
                data.put("hidden", "hidden".equals(fieldInfo.getType()));
                attributes = fieldInfo.getAttributes();
                data.put("width", 150);
                if (!StringUtils.isEmpty((String)attributes.get("width"))) {
                    try {
                        int parseInt = Integer.parseInt(attributes.get("width"));
                        data.put("width", parseInt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                dataType = fieldInfo.getDataType();
                data.put("align", "left");
                data.put("isMultilingual", false);
                if (null != fieldInfo.getProperty() && fieldInfo.getProperty() instanceof OwnPropertyInfo) {
                    data.put("isMultilingual", ((OwnPropertyInfo)fieldInfo.getProperty()).isMultilingual());
                }
                if (null != fieldInfo.getProperty()) {
                    data.put("dbType", fieldInfo.getProperty().getMappingField().getTypeName().getName());
                }
                data.put("sortable", fieldInfo.isSortable());
                data.put("formatter", fieldInfo.getFormatter());
                formatoptions = new HashMap<String, Object>();
                data.put("formatoptions", formatoptions);
                this.setSensitiveRule(ctx, fieldInfo.getAttributes(), data, uiViewInfo);
                this.setFormatoptions(ctx, attributes, dataType, formatoptions, data, fieldInfo);
                UserNantionalUtil.setNumberPrecisionByVarDefineForFormatoptions(attributes, (DataType)dataType, data, uiViewInfo.getVarDefine(ctx));
                if (fieldInfo instanceof ListFieldInfo) {
                    fieldInfo = (ListFieldInfo)fieldInfo;
                    boolean keyField = ((ListFieldInfo)fieldInfo).isKeyField();
                    data.put("key", keyField);
                }
                if (fieldInfo.isLinkProperty()) {
                    String entityName = fieldInfo.getName();
                    data.put("type", DataType.STRING.toString());
                    data.put("columnName", entityName + ".name");
                } else {
                    if (dataType == null) {
                        dataType = DataType.STRING;
                    }
                    data.put("type", dataType.toString());
                }
                colModel.add(data);
            }
            HashMap<String, Object> data0 = new HashMap<String, Object>();
            data0.put("columnName", "id");
            data0.put("hidden", true);
            data0.put("label", "id");
            colModel.add(data0);
            Document doc = XMLUtil.parseXML(uiViewInfo.getContent());
            Element root = doc.getRootElement();
            if (uiViewInfo.isNavigateList()) {
                Element navigateList = XMLUtil.getElement(root, "navigateList");
                Element treeNavigation = XMLUtil.getElement(root, "treeNavigation");
                String filterConfig = treeNavigation.getAttributeValue("filterConfig");
                properties.put("filterConfig", filterConfig);
                String relatedField = navigateList.getAttributeValue("relatedField");
                String url = treeNavigation.getAttributeValue("url");
                url = StringUtils.isEmpty((String)url) ? DynamicUtil.getContextPath() + "/dynamic.do?method=getTreeData" : DynamicUtil.getContextPath() + url;
                properties.put("relatedField", relatedField);
                properties.put("url", url);
            }
            if ((grid = XMLUtil.getElement(root, "grid")) == null) {
                grid = XMLUtil.getElement(root, "list");
            }
            if (grid != null) {
                String shrinkToFitStr = grid.getAttributeValue("shrinkToFit");
                boolean shrinkToFit = true;
                if (!StringUtils.isEmpty((String)shrinkToFitStr)) {
                    try {
                        shrinkToFit = Boolean.parseBoolean(shrinkToFitStr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                properties.put("shrinkToFit", shrinkToFit);
            }
            properties.put("sorterItems", uiViewInfo.getOrderBy());
            properties.put("addNewView", uiViewInfo.getAddNewView());
            properties.put("requireAddNew", uiViewInfo.isRequireAddNew());
            properties.put("synchTotal", uiViewInfo.isSynchTotal());
            this.assembleF7GridOptions(properties, uiViewInfo);
        }
        ShrFieldPerm shrFieldPerm = new ShrFieldPerm(ctx);
        try {
            shrFieldPerm.filter(colModel, queryType, queryValue, modelName, true);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        properties.put("colModel", colModel);
        Map<String, Object> promptF7FastFilterConfigData = PromptF7FastFilterUtils.getPromptF7FastFilterConfigData(UIViewUtil.getUIViewInfoByUIPK(ctx, uipk));
        properties.put("fastfilterData", promptF7FastFilterConfigData);
        if (!StringUtils.isEmpty((String)botp) && botp.equals("true")) {
            properties.put("fastfilterData", null);
        }
        JSONUtils.writeJson(response, properties);
        OperateLogManager.writeAccesLog(request, uipk, "initalize", startTime);
        return null;
    }

    private void setFormatoptions(Context ctx, Map<String, String> attributes, DataType dataType, Map<String, Object> formatoptions, Map<String, Object> data, FieldInfo fieldInfo) throws SHRWebException {
        HashMap extendOptions = new HashMap();
        try {
            DataType dataType0;
            if (!StringUtils.isEmpty((String)attributes.get("dataType")) && null != (dataType0 = DataType.getEnum((String)attributes.get("dataType")))) {
                dataType = dataType0;
            }
            if (DataType.TIME.equals((Object)dataType) || DataType.DATE.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType)) {
                UserNantionalUtil.dateExtendOptionsSetting((Context)ctx, extendOptions, (boolean)false, attributes, (DataType)dataType, (PropertyInfo)fieldInfo.getProperty());
                formatoptions.putAll((Map)extendOptions.get("datetimeOptions"));
                data.put("formatter", "shrDateTimePicker");
            }
            if (DataType.DOUBLE.equals((Object)dataType) || DataType.DECIMAL.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType)) {
                UserNantionalUtil.numberExtendOptionsSetting((Context)ctx, extendOptions, (boolean)true, attributes);
                formatoptions.putAll((Map)extendOptions.get("numberOptions"));
                data.put("formatter", "numberfield");
            }
            if (DataType.LONG.equals((Object)dataType) || DataType.INTEGER.equals((Object)dataType)) {
                UserNantionalUtil.numberExtendOptionsSetting((Context)ctx, extendOptions, (boolean)true, attributes);
                Map numberOptions = (Map)extendOptions.get("numberOptions");
                numberOptions.put("decimalPrecision", 0);
                formatoptions.putAll((Map)extendOptions.get("numberOptions"));
                data.put("formatter", "numberfield");
            }
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    protected void assembleF7GridOptions(Map<String, Object> properties, IListUIViewInfo viewinfo) throws SHRWebException {
        Document doc = XMLUtil.parseXML(viewinfo.getContent());
        Element root = doc.getRootElement();
        Element grid = XMLUtil.getElement(root, "grid");
        if (null == grid && null == (grid = XMLUtil.getElement(root, "list"))) {
            return;
        }
        String rowNum = grid.getAttributeValue("rowNum");
        String multiselect = grid.getAttributeValue("multiselect");
        String rowList = grid.getAttributeValue("rowList");
        Object rownumbers = grid.getAttributeValue("rownumbers");
        rownumbers = rownumbers == null ? Boolean.valueOf(false) : Boolean.valueOf(rownumbers.toString());
        properties.put("rownumbers", rownumbers);
        if (!StringUtils.isEmpty((String)rowNum)) {
            int rowNum0 = 10;
            try {
                rowNum0 = Integer.parseInt(rowNum);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            properties.put("rowNum", rowNum0);
        }
        if (!StringUtils.isEmpty((String)rowList)) {
            properties.put("rowList", JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), rowList, ArrayList.class));
        }
        if (!StringUtils.isEmpty((String)multiselect)) {
            boolean multiselect0 = false;
            try {
                multiselect0 = Boolean.parseBoolean(multiselect);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            properties.put("multiselect", multiselect0);
        }
    }

    @RequestMapping(params={"method=getProperties"})
    @Action
    protected String getPropertiesAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String query = request.getParameter("query");
        String uipk = request.getParameter("uipk");
        String jsonData = request.getParameter("jsonData");
        String isExpFilterConfig = request.getParameter("isExpFilterConfig");
        boolean isExpFilterConfig0 = false;
        if (!StringUtils.isEmpty((String)isExpFilterConfig)) {
            isExpFilterConfig0 = Boolean.parseBoolean(isExpFilterConfig);
        }
        Context ctx = SHRContext.getInstance().getContext();
        long startTime = System.currentTimeMillis();
        List<Object> colModel = new ArrayList();
        ArrayList<Map<String, Object>> searchModel = new ArrayList<Map<String, Object>>();
        boolean isDynamicList = false;
        UIViewInfo viewinfo = null;
        QueryType queryType = null;
        String queryValue = null;
        if (!StringUtils.isEmpty((String)query)) {
            queryType = QueryType.QUERY;
            queryValue = query;
            colModel = this.getColModel(ctx, query, uipk);
        } else if (!StringUtils.isEmpty((String)uipk)) {
            viewinfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
            isDynamicList = "dynamicList".equals(viewinfo.getType());
            if (!StringUtils.isEmpty((String)viewinfo.getQuery())) {
                colModel = this.getColModel(ctx, viewinfo.getQuery(), uipk);
                queryType = QueryType.QUERY;
                queryValue = viewinfo.getQuery();
            } else if (!StringUtils.isEmpty((String)viewinfo.getModel())) {
                if ("list".equals(viewinfo.getType()) || "F7".equals(viewinfo.getType())) {
                    this.assembleCommonListColModel(ctx, (List<Map<String, Object>>)colModel, viewinfo);
                } else if (isDynamicList) {
                    this.assembleDynamicListColModel(ctx, (List<Map<String, Object>>)colModel, viewinfo);
                }
                queryType = isDynamicList ? QueryType.SCHEME : QueryType.ENTITY;
                queryValue = viewinfo.getModel();
            }
            String searchView = viewinfo.getSearchView();
            if (!StringUtils.isEmpty((String)viewinfo.getSearchView())) {
                UIViewInfo searchViewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, searchView);
                String string = searchViewInfo.getModel();
                Document doc = this.getSearchViewDocument(ctx, viewinfo);
                Element root = doc.getRootElement();
                if (root.getChild("advancedSearch") != null) {
                    if (!isDynamicList) {
                        for (int j = 0; j < colModel.size(); ++j) {
                            Map data = (Map)colModel.get(j);
                            data.put("isFilter", false);
                        }
                    }
                    List advancedSearch = root.getChild("advancedSearch").getChildren();
                    int size = advancedSearch.size();
                    block7: for (int i = 0; i < size; ++i) {
                        Element element = (Element)advancedSearch.get(i);
                        String field = element.getAttributeValue("name");
                        String label = element.getAttributeValue("label");
                        String yearRange = element.getAttributeValue("yearRange");
                        String enumFilters = element.getAttributeValue("filter");
                        String f7displayFormat = element.getAttributeValue("displayFormat");
                        String multiselect = element.getAttributeValue("multiselect");
                        uipk = element.getAttributeValue("uipk");
                        Boolean isTree = Boolean.parseBoolean(element.getAttributeValue("isTree"));
                        String treeUrl = element.getAttributeValue("treeUrl");
                        String queryCtrl = element.getAttributeValue("queryCtrl");
                        String queryCtrlOption = element.getAttributeValue("queryCtrlOption");
                        String _sortable_ = element.getAttributeValue("sortable");
                        boolean sortable = true;
                        if (!StringUtils.isEmpty((String)_sortable_) && "false".equals(_sortable_)) {
                            sortable = false;
                        }
                        String name = field;
                        if (StringUtils.isEmpty((String)viewinfo.getQuery()) && !isDynamicList && field.indexOf(".") != -1) {
                            name = field.split("\\.")[0];
                        }
                        for (int j = 0; j < colModel.size(); ++j) {
                            Map data = (Map)colModel.get(j);
                            if (!data.get("columnName").toString().equalsIgnoreCase(name) && (!data.get("columnName").toString().equalsIgnoreCase(field) || !StringUtils.isEmpty((String)viewinfo.getQuery()) || isDynamicList)) continue;
                            HashMap<String, Object> searchData = new HashMap<String, Object>();
                            searchData.put("isTree", isTree);
                            searchData.put("isMultilingual", data.get("isMultilingual"));
                            searchData.put("dbType", data.get("dbType"));
                            searchData.put("treeUrl", treeUrl);
                            searchData.put("queryCtrl", queryCtrl);
                            Object isEncryptFieldObj = data.get("isEncryptField");
                            boolean isEncryptField = false;
                            if (isEncryptFieldObj != null && Boolean.parseBoolean(isEncryptFieldObj.toString())) {
                                isEncryptField = true;
                            }
                            searchData.put("isEncryptField", isEncryptField);
                            if (!StringUtils.isEmpty((String)multiselect)) {
                                searchData.put("multiselect", Boolean.parseBoolean(multiselect));
                            }
                            searchData.put("queryCtrlOption", queryCtrlOption);
                            searchData.put("sortable", sortable);
                            Object extendOptions = data.get("extendOptions");
                            if (null != extendOptions) {
                                searchData.put("extendOptions", extendOptions);
                            } else {
                                searchData.put("extendOptions", Collections.EMPTY_MAP);
                            }
                            if (!StringUtils.isEmpty((String)viewinfo.getQuery())) {
                                this.processQuerySearchData(uipk, searchModel, i, field, label, yearRange, name, data, searchData);
                            } else if (isDynamicList) {
                                this.processDynamicSearchData(uipk, searchModel, string, i, field, label, yearRange, name, data, searchData);
                            } else {
                                this.processEntitySearchData(uipk, searchModel, string, i, field, label, yearRange, name, data, searchData);
                            }
                            if (!StringUtils.isEmpty((String)((String)searchData.get("enumSource"))) && !StringUtils.isEmpty((String)enumFilters)) {
                                searchData.put("enumFilters", enumFilters);
                            }
                            if (!StringUtils.isEmpty((String)f7displayFormat)) {
                                f7displayFormat = f7displayFormat.replace("{", "").replace("}", "");
                                f7displayFormat = "{" + f7displayFormat + "}";
                                searchData.put("f7displayFormat", f7displayFormat);
                            }
                            if (!isExpFilterConfig0) continue block7;
                            this.addExpFilterAttributes(ctx, searchData);
                            continue block7;
                        }
                    }
                }
            } else if (!StringUtils.isEmpty((String)jsonData)) {
                colModel = (ArrayList)JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), jsonData, ArrayList.class);
            }
        } else if (!StringUtils.isEmpty((String)jsonData)) {
            colModel = (ArrayList)JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), jsonData, ArrayList.class);
        }
        ShrFieldPerm shrFieldPerm = new ShrFieldPerm(ctx);
        if (!searchModel.isEmpty()) {
            try {
                if (null != viewinfo && !StringUtils.isEmpty((String)queryValue)) {
                    shrFieldPerm.filter(searchModel, queryType, queryValue, viewinfo.getModel(), false);
                }
            }
            catch (EASBizException e) {
                throw new ShrWebBizException(e.getMessage(), e);
            }
            catch (BOSException e) {
                throw new SHRWebException(e);
            }
            JSONUtils.writeJson(response, searchModel);
        } else {
            if (isExpFilterConfig0) {
                viewinfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
                for (Map map : colModel) {
                    String columnName = (String)map.get("columnName");
                    FieldInfo f0 = null;
                    if (null != viewinfo) {
                        f0 = viewinfo.getField(columnName);
                    }
                    if (null == f0 || "hidden".equals(f0.getType())) continue;
                    this.addExpFilterAttributes(ctx, map);
                    searchModel.add(map);
                }
            }
            try {
                if (!StringUtils.isEmpty((String)queryValue) && null != viewinfo) {
                    shrFieldPerm.filter(searchModel, queryType, queryValue, viewinfo.getModel(), false);
                }
            }
            catch (EASBizException e) {
                throw new ShrWebBizException(e.getMessage(), e);
            }
            catch (BOSException e) {
                throw new SHRWebException(e);
            }
            JSONUtils.writeJson(response, searchModel);
        }
        OperateLogManager.writeAccesLog(request, uipk, "getProperties", startTime);
        return null;
    }

    private void addExpFilterAttributes(Context ctx, Map<String, Object> each) throws SHRWebException {
        ListUIViewInfo info;
        each.put("isFilter", true);
        each.put("isHRBaseItem", false);
        String uipk = (String)each.get("uipk");
        if (!StringUtils.isEmpty((String)uipk) && null != (info = (ListUIViewInfo)UIViewUtil.getUIViewInfoByUIPK(ctx, uipk))) {
            boolean isSHRBaseItem = false;
            if (SysSettingSHRBaseItemUtil.isSHRBaseItem((Context)ctx, (String)info.getModel()) && !StringUtils.isEmpty((String)info.getQuery())) {
                isSHRBaseItem = true;
            }
            each.put("isHRBaseItem", isSHRBaseItem);
        }
    }

    private void processEntitySearchData(String uipk, List<Map<String, Object>> searchModel, String entityName, int i, String field, String label, String yearRange, String name, Map<String, Object> data, Map<String, Object> searchData) {
        PropertyInfo propertyInfo = MetaDataUtil.getPropertyInfo(entityName, field);
        if (propertyInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo o = (OwnPropertyInfo)propertyInfo;
            String dataTypeStr = o.getDataType().toString();
            if (DataType.ENUM.toString().equals(dataTypeStr)) {
                String enmumStr = this.getRealEnumType(data, o);
                searchData.put("type", enmumStr);
            } else {
                searchData.put("type", dataTypeStr);
                if (null != data && null != data.get("type") && !"link".equals((String)data.get("type"))) {
                    searchData.put("type", data.get("type"));
                }
            }
            searchData.put("isMultilingual", o.isMultilingual());
        } else if (data != null && propertyInfo instanceof LinkPropertyInfo) {
            searchData.put("type", "link");
            searchData.put("uipk", data.get("uipk"));
        }
        if (null == searchData.get("dbType") && null != propertyInfo) {
            searchData.put("dbType", propertyInfo.getMappingField().getTypeName().getName());
        }
        if (data != null) {
            searchData.put("enumSource", data.get("enumSource"));
            searchData.put("label", data.get("label"));
        }
        searchData.put("columnName", field);
        searchData.put("isFilter", true);
        searchData.put("index", i);
        if (uipk != null) {
            searchData.put("uipk", uipk);
        } else if (data != null && field.equalsIgnoreCase(name)) {
            searchData.put("uipk", data.get("uipk"));
        }
        if (yearRange != null) {
            searchData.put("yearRange", yearRange);
        }
        if (label != null) {
            searchData.put("label", label);
        }
        searchModel.add(searchData);
    }

    private void processDynamicSearchData(String uipk, List<Map<String, Object>> searchModel, String entityName, int i, String field, String label, String yearRange, String name, Map<String, Object> data, Map<String, Object> searchData) {
        searchData.put("type", data.get("type"));
        searchData.put("columnName", data.get("columnName"));
        searchData.put("isFilter", data.get("isFilter"));
        if (SHREnumUtil.isEnum((String)String.valueOf(data.get("type")))) {
            searchData.put("enumSource", data.get("enumSource"));
        }
        String uipk0 = (String)data.get("uipk");
        if (!StringUtils.isEmpty((String)uipk)) {
            searchData.put("type", "link");
            searchData.put("uipk", uipk);
        } else if (!StringUtils.isEmpty((String)uipk0)) {
            searchData.put("type", "link");
            searchData.put("uipk", uipk0);
        }
        searchData.put("label", data.get("label"));
        searchData.put("index", i);
    }

    private void processQuerySearchData(String uipk, List<Map<String, Object>> searchModel, int i, String field, String label, String yearRange, String name, Map<String, Object> data, Map<String, Object> searchData) {
        searchData.put("enumSource", data.get("enumSource"));
        searchData.put("label", data.get("label"));
        searchData.put("columnName", field);
        searchData.put("isFilter", true);
        searchData.put("index", i);
        searchData.put("type", data.get("type"));
        if (uipk != null) {
            searchData.put("uipk", uipk);
        } else if (field.equalsIgnoreCase(name)) {
            searchData.put("uipk", data.get("uipk"));
        }
        if (yearRange != null) {
            searchData.put("yearRange", yearRange);
        }
        if (label != null) {
            searchData.put("label", label);
        }
        searchModel.add(searchData);
    }

    private String getRealEnumType(Map<String, Object> data, OwnPropertyInfo o) {
        String dataType = "IntEnum";
        if (DataType.ENUM.toString().equals(o.getDataType().toString())) {
            BizEnumInfo enumInfo = o.getEnumType(MDHostType.RUNTIME);
            if (enumInfo == null) {
                dataType = "IntEnum";
            } else {
                data.put("enumSource", o.getMetaDataRef());
                dataType = BizEnumValueType.STRING.equals((Object)enumInfo.getDataType()) ? "StringEnum" : "IntEnum";
            }
        }
        return dataType;
    }

    private Document getSearchViewDocument(Context ctx, UIViewInfo viewinfo) throws SHRWebException {
        UIViewInfo searchView = UIViewUtil.getUIViewInfoByUIPK(ctx, viewinfo.getSearchView());
        Document doc = XMLUtil.parseXML(searchView.getContent());
        return doc;
    }

    private void assembleDynamicListColModel(Context ctx, List<Map<String, Object>> colModel, UIViewInfo uiViewInfo) throws SHRWebException {
        HashMap<String, String> param = new HashMap<String, String>();
        if (null == uiViewInfo.getSearchView()) {
            return;
        }
        param.put("scheme", uiViewInfo.getModel());
        param.put("fieldRange", uiViewInfo.getUipk());
        UIViewInfo uiviewInfo0 = UIViewUtil.getUIViewInfoByUIPK(ctx, uiViewInfo.getSearchView());
        SearchUIViewInfo searchView = null;
        if (uiviewInfo0 instanceof SearchUIViewInfo) {
            searchView = (SearchUIViewInfo)uiviewInfo0;
        } else {
            this.logger.error(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "type_not_match"), uiViewInfo.getUipk(), uiViewInfo.getType()));
        }
        List fields = (List)OSFExecutor.executeOSF((Context)ctx, param, (String)"getQueryZTreeNodes");
        if (null == searchView || null == fields) {
            return;
        }
        List<FieldInfo> fieldInfos = searchView.getAdvancedSearchFields();
        HashMap<String, String> temp = new HashMap<String, String>();
        if (null == fieldInfos) {
            return;
        }
        for (FieldInfo fieldInfo : fieldInfos) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            String fieldName = fieldInfo.getName();
            if (null != temp.get(fieldName)) {
                return;
            }
            temp.put(fieldName, fieldName);
            data.put("columnName", fieldName);
            data.put("isFilter", true);
            data.put("isMultilingual", false);
            data.put("dbType", "");
            HashMap<String, String> sameKeyMap = new HashMap<String, String>();
            block1: for (com.kingdee.shr.base.syssetting.app.complexquery.QueryFieldInfo queryFieldInfo : fields) {
                List children = queryFieldInfo.getChildren();
                block2: for (com.kingdee.shr.base.syssetting.app.complexquery.QueryFieldInfo child : children) {
                    String childName = child.getName();
                    String childField = child.getField();
                    if (StringUtils.isEmpty((String)childField)) {
                        List childrenSub = child.getChildren();
                        for (com.kingdee.shr.base.syssetting.app.complexquery.QueryFieldInfo subQueryFieldInfo : childrenSub) {
                            if (!fieldName.equals(subQueryFieldInfo.getField()) || null != sameKeyMap.get(fieldName)) continue;
                            sameKeyMap.put(fieldName, fieldName);
                            if (!StringUtils.isEmpty((String)childName)) {
                                data.put("label", subQueryFieldInfo.getName());
                            }
                            data.put("type", subQueryFieldInfo.getDataType());
                            data.put("enumSource", subQueryFieldInfo.getEnumSource());
                            data.put("extendOptions", subQueryFieldInfo.getExtendOptions());
                            String uipk = subQueryFieldInfo.getUipk();
                            data.put("isMultilingual", subQueryFieldInfo.isMultilingual());
                            data.put("dbType", subQueryFieldInfo.getDbType());
                            data.put("isEncryptField", subQueryFieldInfo.isEncryptField());
                            if (!StringUtils.isEmpty((String)uipk)) {
                                data.put("uipk", uipk);
                            }
                            if (!StringUtils.isEmpty((String)subQueryFieldInfo.getF7FieldName())) {
                                data.put("f7displayFormat", subQueryFieldInfo.getF7FieldName());
                            }
                            UserNantionalUtil.setNumberPrecisionByVarDefineAndOrignExtendOptions((Map)subQueryFieldInfo.getExtendOptions(), (DataType)DataType.getEnum((String)subQueryFieldInfo.getDataType()), data, searchView.getVarDefine(ctx));
                            colModel.add(data);
                            continue block2;
                        }
                        continue;
                    }
                    if (!fieldName.equals(childField) || null != sameKeyMap.get(fieldName)) continue;
                    sameKeyMap.put(fieldName, fieldName);
                    if (!StringUtils.isEmpty((String)child.getName())) {
                        data.put("label", child.getName());
                    }
                    data.put("type", child.getDataType());
                    if (!StringUtils.isEmpty((String)child.getUipk())) {
                        data.put("uipk", child.getUipk());
                    }
                    if (!StringUtils.isEmpty((String)child.getEnumSource())) {
                        data.put("enumSource", child.getEnumSource());
                    }
                    if (!StringUtils.isEmpty((String)child.getEnumSource())) {
                        data.put("enumSource", child.getEnumSource());
                    }
                    if (!StringUtils.isEmpty((String)child.getF7FieldName())) {
                        data.put("f7displayFormat", child.getF7FieldName());
                    }
                    if (null != child.getExtendOptions()) {
                        data.put("extendOptions", child.getExtendOptions());
                    }
                    data.put("isMultilingual", child.isMultilingual());
                    data.put("dbType", child.getDbType());
                    data.put("isEncryptField", child.isEncryptField());
                    UserNantionalUtil.setNumberPrecisionByVarDefineAndOrignExtendOptions((Map)child.getExtendOptions(), (DataType)DataType.getEnum((String)child.getDataType()), data, searchView.getVarDefine(ctx));
                    colModel.add(data);
                    continue block1;
                }
            }
        }
    }

    private void assembleCommonListColModel(Context ctx, List<Map<String, Object>> colModel, UIViewInfo viewinfo) throws SHRWebException {
        String uipk = null;
        UIViewInfo searchView = this.getSearchViewInfo(ctx, viewinfo);
        PropertyInfo info = null;
        HashMap<String, Object> data = null;
        HashMap extendOptions = null;
        Map<String, String> attributes = null;
        DataType dataType = null;
        List<FieldInfo> fs = searchView.getFields();
        if (null == fs || fs.isEmpty()) {
            return;
        }
        try {
            for (FieldInfo f : fs) {
                dataType = null;
                info = f.getProperty();
                attributes = f.getAttributes();
                data = new HashMap<String, Object>();
                extendOptions = new HashMap();
                data.put("extendOptions", extendOptions);
                data.put("columnName", f.getName());
                data.put("label", f.getAlias());
                data.put("isFilter", true);
                data.put("isMultilingual", false);
                data.put("dbType", "");
                if (null != attributes && !StringUtils.isEmpty((String)attributes.get("dataType")) && null != (dataType = DataTypeUtil.convertString2DataType((String)attributes.get("dataType")))) {
                    data.put("type", dataType.toString());
                }
                if (info instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)info;
                    if (null == dataType) {
                        dataType = ownPropertyInfo.getDataType();
                    }
                    data.put("isMultilingual", ownPropertyInfo.isMultilingual());
                    data.put("type", dataType.toString());
                    data.put("dbType", ownPropertyInfo.getMappingField().getTypeName().getName());
                    data.put("isEncryptField", UIViewUtil.isEncryptField(ctx, viewinfo, f.getName()));
                    if (DataType.ENUM.equals((Object)dataType)) {
                        BizEnumInfo bizEnumInfo = SHREnumUtil.getBizEnumInfoByOwnProperty((OwnPropertyInfo)ownPropertyInfo);
                        if (null != bizEnumInfo) {
                            data.put("enumSource", bizEnumInfo.getFullName());
                        }
                        data.put("type", SHREnumUtil.getEnumByOwnProperty((OwnPropertyInfo)ownPropertyInfo));
                    }
                    if (DataType.TIME.equals((Object)dataType) || DataType.DATE.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType)) {
                        UserNantionalUtil.dateExtendOptionsSetting((Context)ctx, extendOptions, (boolean)false, attributes, (DataType)dataType, (PropertyInfo)ownPropertyInfo);
                    }
                    if (DataType.DOUBLE.equals((Object)dataType) || DataType.DECIMAL.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType)) {
                        UserNantionalUtil.numberExtendOptionsSetting((Context)ctx, extendOptions, (boolean)true, attributes);
                        UserNantionalUtil.setNumberPrecisionByVarDefineForExtendOptions(attributes, (DataType)dataType, data, searchView.getVarDefine(ctx));
                    }
                    if (DataType.LONG.equals((Object)dataType) || DataType.INTEGER.equals((Object)dataType)) {
                        UserNantionalUtil.numberExtendOptionsSetting((Context)ctx, extendOptions, (boolean)true, attributes);
                        Map numberOptions = (Map)extendOptions.get("numberOptions");
                        numberOptions.put("decimalPrecision", 0);
                    }
                } else if (info instanceof LinkPropertyInfo) {
                    LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)info;
                    String entityName = linkPropertyInfo.getName();
                    data.put("type", "link");
                    data.put("dbType", linkPropertyInfo.getMappingField().getTypeName().getName());
                    String linkEntityName = linkPropertyInfo.getRelationship().getSupplierObject().getFullName();
                    if (viewinfo.getEntityName().equals(linkEntityName)) {
                        linkEntityName = linkPropertyInfo.getRelationship().getClientObject().getFullName();
                    }
                    UIViewInfo f7 = null;
                    uipk = linkEntityName + ".F7";
                    try {
                        f7 = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
                    }
                    catch (SHRWebException e) {
                        uipk = linkEntityName + ".list";
                    }
                    data.put("uipk", uipk);
                    data.put("filterName", entityName + ".name");
                } else {
                    if (DataType.ENUM.equals(dataType) && null != attributes) {
                        data.put("enumSource", attributes.get("enumSource"));
                    }
                    if (DataType.TIME.equals((Object)dataType) || DataType.DATE.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType)) {
                        UserNantionalUtil.dateExtendOptionsSetting((Context)ctx, extendOptions, (boolean)false, attributes, (DataType)dataType, null);
                    }
                    if (DataType.DOUBLE.equals((Object)dataType) || DataType.DECIMAL.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType)) {
                        UserNantionalUtil.numberExtendOptionsSetting((Context)ctx, extendOptions, (boolean)true, attributes);
                        UserNantionalUtil.setNumberPrecisionByVarDefineForExtendOptions(attributes, (DataType)dataType, data, searchView.getVarDefine(ctx));
                    }
                    if (DataType.LONG.equals((Object)dataType) || DataType.INTEGER.equals((Object)dataType)) {
                        UserNantionalUtil.numberExtendOptionsSetting((Context)ctx, extendOptions, (boolean)true, attributes);
                        Map numberOptions = (Map)extendOptions.get("numberOptions");
                        numberOptions.put("decimalPrecision", 0);
                    }
                    if (DataType.OBJECTVALUE.equals((Object)dataType) && null != attributes) {
                        uipk = attributes.get("uipk");
                        data.put("type", "link");
                        if (!StringUtils.isEmpty((String)uipk)) {
                            try {
                                UIViewInfo f7 = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
                                data.put("uipk", uipk);
                            }
                            catch (SHRWebException e) {
                                data.put("uipk", "");
                            }
                        }
                    }
                }
                if (!"id".equalsIgnoreCase(f.getName())) {
                    data.put("isFilter", true);
                } else {
                    data.put("isFilter", false);
                }
                colModel.add(data);
            }
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    @RequestMapping(params={"method=getQuickSearch"})
    @Action
    protected String getQuickSearchAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String uipk = request.getParameter("uipk");
        Context ctx = SHRContext.getInstance().getContext();
        ArrayList<Map<String, Object>> colModel = new ArrayList<Map<String, Object>>();
        if (!StringUtils.isEmpty((String)uipk)) {
            UIViewInfo viewinfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
            if (!StringUtils.isEmpty((String)viewinfo.getSearchView())) {
                List<FieldInfo> quickSearchList;
                UIViewInfo searchView = UIViewUtil.getUIViewInfoByUIPK(ctx, viewinfo.getSearchView());
                if (searchView instanceof ISearchUIViewInfo && (quickSearchList = ((ISearchUIViewInfo)((Object)searchView)).getQuickSearchFields()) != null) {
                    ShrFieldPerm shrFieldPerm = new ShrFieldPerm(ctx);
                    int size = quickSearchList.size();
                    for (int i = 0; i < size; ++i) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        String columnName = quickSearchList.get(i).getName();
                        if (!this.hasFieldPerm(shrFieldPerm, viewinfo, columnName)) continue;
                        data.put("columnName", columnName);
                        data.put("label", quickSearchList.get(i).getAlias());
                        boolean isEncryptField = false;
                        isEncryptField = UIViewUtil.isEncryptField(ctx, viewinfo, columnName);
                        data.put("isEncryptField", isEncryptField);
                        colModel.add(data);
                    }
                }
            } else {
                QueryFieldInfo queryField;
                String model = viewinfo.getModel();
                boolean isShrBaseItem = SysSettingSHRBaseItemUtil.isSHRBaseItem((Context)ctx, (String)model);
                String query = viewinfo.getQuery();
                if (isShrBaseItem && !StringUtils.isEmpty((String)query) && (queryField = MetaDataUtil.getQueryField(query, "BaseInfo.name")) != null) {
                    this.processData(ctx, colModel, viewinfo, "BaseInfo.name", SHRSysSettingResourceUtil.getResource((String)"name", (Context)ctx));
                    this.processData(ctx, colModel, viewinfo, "BaseInfo.number", SHRSysSettingResourceUtil.getResource((String)"number", (Context)ctx));
                }
            }
        }
        JSONUtils.writeJson(response, colModel);
        return null;
    }

    private Map<String, Object> processData(Context ctx, List<Map<String, Object>> colModel, UIViewInfo viewinfo, String columnName, String label) throws SHRWebException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("columnName", columnName);
        data.put("label", label);
        boolean isEncryptField = false;
        isEncryptField = UIViewUtil.isEncryptField(ctx, viewinfo, columnName);
        data.put("isEncryptField", isEncryptField);
        colModel.add(data);
        return data;
    }

    @RequestMapping(params={"method=saveSearchView"})
    @Action
    protected String saveSearchViewAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, EASBizException, ParseException {
        Context ctx = SHRContext.getInstance().getContext();
        String currentPersonId = "";
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            currentPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        String uipk = request.getParameter("uipk");
        String query = request.getParameter("query");
        String viewName = request.getParameter("viewName");
        String searchFilter = request.getParameter("searchFilter");
        String viewId = "";
        String defaultView = request.getParameter("defaultView");
        String effdt = request.getParameter("effdt");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("personid", (Object)currentPersonId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("viewName", (Object)viewName, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("uipk", (Object)uipk, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SearchViewCollection collection = SearchViewFactory.getLocalInstance((Context)ctx).getSearchViewCollection(viewInfo);
        ISearchView searchview = SearchViewFactory.getLocalInstance((Context)ctx);
        SearchViewInfo viewinfo = new SearchViewInfo();
        if (collection.size() > 0) {
            viewId = collection.get(0).getId().toString();
            viewinfo.setId(collection.get(0).getId());
        }
        viewinfo.setViewname(viewName);
        viewinfo.setUipk(uipk);
        viewinfo.setQuery(query);
        viewinfo.setQueryfilter(searchFilter);
        if (!StringUtils.isEmpty((String)effdt)) {
            viewinfo.setSearchdate(DateTimeUtils.parseDate((String)effdt, (String)"yyyy-MM-dd"));
        } else {
            viewinfo.setSearchdate(new Date());
        }
        viewinfo.setPersonid(currentPersonId);
        if ("true".equals(defaultView)) {
            StringBuffer sql = new StringBuffer();
            sql.append(" update S_BS_SearchView set FisDefault = 0 where FUipk = '" + uipk + "' ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            viewinfo.setIsDefault(true);
        } else {
            viewinfo.setIsDefault(false);
        }
        ObjectUuidPK pk = (ObjectUuidPK)searchview.save((CoreBaseInfo)viewinfo);
        if ("".equals(viewId)) {
            viewId = pk.getKeyValue().toString();
            JSONUtils.SUCCESS(viewId);
        }
        return null;
    }

    @RequestMapping(params={"method=findSearchView"})
    @Action
    protected String findSearchViewAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, EASBizException, SHRWebException {
        QuerySolutionInfo defaultSolutionInfo;
        String viewId = request.getParameter("viewId");
        String uipk = request.getParameter("uipk");
        Context ctx = SHRContext.getInstance().getContext();
        HashMap<String, Object> data = null;
        if (!StringUtils.isEmpty((String)uipk) && (defaultSolutionInfo = this.getDefaultQuerySolutionInfo(ctx, request, uipk)) != null && defaultSolutionInfo.getId().equalsIgnoreCase(viewId) && defaultSolutionInfo.getItems() != null) {
            List<com.kingdee.shr.base.syssetting.web.dynamic.model.FilterItemInfo> items = defaultSolutionInfo.getItems();
            ArrayList list = new ArrayList();
            com.kingdee.shr.base.syssetting.web.dynamic.model.FilterItemInfo itemInfo = null;
            HashMap<String, String> map = null;
            int size = items.size();
            for (int i = 0; i < size; ++i) {
                itemInfo = items.get(i);
                map = new HashMap<String, String>();
                map.put("prop_field", itemInfo.getFieldName());
                map.put("prop_op", itemInfo.getCompareType());
                map.put("prop_value", itemInfo.getValue());
                list.add(map);
            }
            data = new HashMap();
            data.put("searchFilter", JSONUtils.convertObjectToJson(ctx, list));
            boolean hasDefault = this.hasDefaultSolution(uipk);
            data.put("defaultView", hasDefault ? false : defaultSolutionInfo.isDefaultSolution());
        }
        if (data == null) {
            ISearchView searchview = SearchViewFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)viewId));
            SearchViewInfo viewinfo = (SearchViewInfo)searchview.getValue((IObjectPK)pk);
            data = new HashMap<String, Object>();
            data.put("searchFilter", viewinfo.getQueryfilter());
            data.put("defaultView", viewinfo.isIsDefault());
            data.put("effdt", viewinfo.getSearchdate().toString());
        }
        JSONUtils.SUCCESS(data);
        return null;
    }

    private boolean hasDefaultSolution(String uipk) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        Context ctx = SHRContext.getInstance().getContext();
        String personId = "";
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("personid", (Object)personId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("uipk", (Object)uipk, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE));
        boolean hasDefault = SearchViewFactory.getLocalInstance((Context)ctx).exists(filterInfo);
        return hasDefault;
    }

    @RequestMapping(params={"method=findSearchViewList"})
    @Action
    protected String findSearchViewListAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, EASBizException, SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String personId = "";
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        String uipk = request.getParameter("uipk");
        String query = request.getParameter("query");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("viewname"));
        viewInfo.getSelector().add(new SelectorItemInfo("isDefault"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("personid", (Object)personId, CompareType.EQUALS));
        if (!StringUtils.isEmpty((String)uipk)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("uipk", (Object)uipk, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("query", (Object)query, CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        SearchViewCollection collection = SearchViewFactory.getLocalInstance((Context)ctx).getSearchViewCollection(viewInfo);
        ArrayList list = new ArrayList();
        boolean hasDefault = false;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            SearchViewInfo filter = collection.get(i);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", filter.getId().toString());
            data.put("name", filter.getViewname());
            data.put("defaultView", filter.isIsDefault());
            if (!hasDefault) {
                hasDefault = filter.isIsDefault();
            }
            list.add(data);
        }
        QuerySolutionInfo defaultSolutionInfo = this.getDefaultQuerySolutionInfo(ctx, request, uipk);
        if (defaultSolutionInfo != null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", defaultSolutionInfo.getId());
            data.put("name", defaultSolutionInfo.getName());
            data.put("defaultView", hasDefault ? false : defaultSolutionInfo.isDefaultSolution());
            list.add(0, data);
        }
        JSONUtils.SUCCESS(list);
        return null;
    }

    private QuerySolutionInfo getDefaultQuerySolutionInfo(Context ctx, HttpServletRequest request, String uipk) throws SHRWebException {
        UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
        if (uiViewInfo instanceof IListUIViewInfo) {
            IListUIViewInfo listUIViewInfo = (IListUIViewInfo)((Object)uiViewInfo);
            QuerySolutionInfo solutionInfo = listUIViewInfo.getDefaultQuerySolution();
            if ((solutionInfo = this.afterGetDefaultSolutionInfo(request, uipk, solutionInfo)) != null) {
                solutionInfo.setId("systemDefaultQuerySolution");
                solutionInfo.setDefaultSolution(true);
            }
            return solutionInfo;
        }
        return null;
    }

    private QuerySolutionInfo afterGetDefaultSolutionInfo(HttpServletRequest request, String uipk, QuerySolutionInfo querySolutionInfo) throws SHRWebException {
        CoreHandler object = DynamicUtil.newHandler(uipk);
        if (object instanceof ListHandler) {
            querySolutionInfo = ((ListHandler)object).afterGetDefaultSolutionInfo(request, querySolutionInfo);
        }
        return querySolutionInfo;
    }

    @RequestMapping(params={"method=delSearchView"})
    @Action
    protected String delSearchViewAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, EASBizException {
        String viewId = request.getParameter("viewId");
        ISearchView searchview = SearchViewFactory.getLocalInstance((Context)SHRContext.getInstance().getContext());
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)viewId));
        searchview.delete((IObjectPK)pk);
        JSONUtils.SUCCESS(true);
        return null;
    }

    private UIViewInfo getSearchViewInfo(Context ctx, UIViewInfo viewinfo) {
        UIViewInfo searchViewinfo = null;
        try {
            searchViewinfo = StringUtils.isEmpty((String)viewinfo.getSearchView()) ? viewinfo : UIViewUtil.getUIViewInfoByUIPK(ctx, viewinfo.getSearchView());
        }
        catch (SHRWebException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            searchViewinfo = viewinfo;
        }
        return searchViewinfo;
    }

    private List<Map<String, Object>> getColModel(Context ctx, String queryPK, String uipk) throws SHRWebException {
        QuerySelect select = new QuerySelect(queryPK);
        MetaDataPK queryObjectPK = MetaDataPK.create((String)queryPK);
        QueryInfo queryInfo = CommonQueryHelper.getQueryInfo(ctx, (IMetaDataPK)queryObjectPK);
        try {
            select.selectHeaderSelectorFields().propertyUnitSelect().select(new String[]{"*"}, new String[]{"displayName", "returnType", "isSelector", "isFilter", "isSorter"}, ctx.getOriginLocale()).extendPropertySelect().select("*");
            ArrayList<Map<String, Object>> colModel = new ArrayList<Map<String, Object>>();
            UIViewInfo viewinfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
            UIViewInfo searchViewinfo = this.getSearchViewInfo(ctx, viewinfo);
            PropertyUnitCollection puc = queryInfo.getUnits();
            int total = puc.size();
            for (int i = 0; i < total; ++i) {
                PropertyUnitInfo qfi = puc.get(i);
                Map<String, Object> colMap = this.getColMap(qfi, queryInfo, ctx, searchViewinfo);
                boolean encryptField = UIViewUtil.isEncryptField(ctx, uipk, qfi.getName());
                colMap.put("isEncryptField", encryptField);
                colModel.add(colMap);
            }
            return colModel;
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    private Map<String, Object> getColMap(PropertyUnitInfo qfi, QueryInfo queryInfo, Context ctx, UIViewInfo searchViewinfo) throws SHRWebException, BOSException, EASBizException {
        String isUsingF7;
        HashMap<String, Object> col = new HashMap<String, Object>();
        String columnName = qfi.getName();
        col.put("columnName", columnName);
        col.put("isMultilingual", false);
        col.put("dbType", "");
        String displayName = qfi.getDisplayName();
        if (StringUtils.isEmpty((String)displayName)) {
            displayName = columnName;
        }
        col.put("label", displayName);
        String visible = qfi.getExtendedProperty("isVisibleForKDTable");
        if ("false".equals(visible)) {
            col.put("hidden", true);
        } else {
            col.put("hidden", false);
        }
        String colWidth = qfi.getExtendedProperty("colWidthInKDTable");
        if (colWidth != null) {
            col.put("width", new Integer(colWidth));
        } else {
            col.put("width", 100);
        }
        FieldInfo fieldInfo = searchViewinfo.getField(columnName);
        PropertyInfo p = null;
        if (null == fieldInfo || null == fieldInfo.getProperty()) {
            if (null != qfi.getPropertyRefs() && null != qfi.getPropertyRefs().get(0) && (p = qfi.getPropertyRefs().get(0).getRefProperty()) == null) {
                PropertyUnitInfo pu = qfi.getPropertyRefs().get(0).getUnit();
                if (pu != null && null != pu.getPropertyRefs() && null != pu.getPropertyRefs().get(0)) {
                    p = pu.getPropertyRefs().get(0).getRefProperty();
                } else {
                    pu = qfi.getPropertyRefs().get(0).getRefUnit();
                    if (null != pu && null != pu.getPropertyRefs() && null != pu.getPropertyRefs().get(0) && null != pu.getPropertyRefs().get(0).getRefUnit() && null != pu.getPropertyRefs().get(0).getRefUnit().getPropertyRefs() && null != pu.getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0)) {
                        p = qfi.getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0).getRefUnit().getPropertyRefs().get(0).getRefProperty();
                    }
                }
            }
        } else {
            p = fieldInfo.getProperty();
        }
        if (null != p) {
            if (p.getMappingField() != null && p.getMappingField().getTypeName() != null) {
                col.put("dbType", p.getMappingField().getTypeName().getName());
            } else {
                String name = p.getName();
                this.logger.error("debugxxx:" + name + "|" + columnName);
                col.put("dbType", "");
            }
        }
        ConstDataType dataType = qfi.getReturnType();
        HashMap extendOptions = new HashMap();
        col.put("extendOptions", extendOptions);
        DataType dataType0 = null;
        if (fieldInfo != null) {
            this.setSensitiveRule(ctx, fieldInfo.getAttributes(), col, searchViewinfo);
            if (null != fieldInfo && !StringUtils.isEmpty((String)fieldInfo.getAttributes().get("dataType"))) {
                dataType0 = DataTypeUtil.convertString2DataType((String)fieldInfo.getAttributes().get("dataType"));
            }
            if (ConstDataType.TIME.equals((Object)dataType) || ConstDataType.DATE.equals((Object)dataType) || ConstDataType.TIMESTAMP.equals((Object)dataType)) {
                if (null == dataType0) {
                    if (ConstDataType.TIME.equals((Object)dataType)) {
                        dataType0 = DataType.TIME;
                    } else if (ConstDataType.DATE.equals((Object)dataType)) {
                        dataType0 = DataType.DATE;
                    } else if (ConstDataType.TIMESTAMP.equals((Object)dataType)) {
                        dataType0 = DataType.TIMESTAMP;
                    }
                }
                UserNantionalUtil.dateExtendOptionsSetting((Context)ctx, extendOptions, (boolean)false, fieldInfo.getAttributes(), (DataType)dataType0);
            }
            if (ConstDataType.NUMBER.equals((Object)dataType) || ConstDataType.INT.equals((Object)dataType)) {
                UserNantionalUtil.numberExtendOptionsSetting((Context)ctx, extendOptions, (boolean)true, fieldInfo.getAttributes());
                if (ConstDataType.INT.equals((Object)dataType)) {
                    Map numberOptions = (Map)extendOptions.get("numberOptions");
                    numberOptions.put("decimalPrecision", 0);
                } else {
                    UserNantionalUtil.setNumberPrecisionByVarDefineForExtendOptions(fieldInfo.getAttributes(), col, searchViewinfo.getVarDefine(ctx));
                }
            }
            if (ConstDataType.STRING.equals((Object)dataType) && p instanceof OwnPropertyInfo) {
                col.put("isMultilingual", ((OwnPropertyInfo)p).isMultilingual());
            }
        }
        String dataTypeStr0 = dataType.toString();
        if (ConstDataType.NUMBER.getAlias().equalsIgnoreCase(dataTypeStr0)) {
            dataTypeStr0 = DataType.DECIMAL.getName();
        }
        if (null == dataType0) {
            col.put("type", dataTypeStr0);
        } else {
            col.put("type", dataType0.getName());
        }
        col.put("align", "left");
        String isFilter = qfi.getExtendedProperty("isCommonQueryFilter");
        if ("true".equals(isFilter)) {
            col.put("isFilter", true);
        } else {
            col.put("isFilter", false);
        }
        DataObject dataObject = QueryUtils.getRefMetaData((Context)ctx, (QueryInfo)queryInfo, (String)columnName);
        boolean isReturnTypeEnum = false;
        if (null != p && p instanceof OwnPropertyInfo && DataType.ENUM.equals((Object)((OwnPropertyInfo)p).getDataType())) {
            isReturnTypeEnum = true;
        }
        if (isReturnTypeEnum) {
            if (null != dataObject) {
                String enumClassName = dataObject.getValue();
                BizEnumInfo enumInfo = QueryUtils.getEnum((Context)ctx, (String)enumClassName);
                if (BizEnumValueType.STRING.equals((Object)enumInfo.getDataType())) {
                    col.put("type", "StringEnum");
                } else {
                    col.put("type", "IntEnum");
                }
                col.put("enumSource", enumClassName);
            } else {
                OwnPropertyInfo pp = (OwnPropertyInfo)p;
                Enum e = com.kingdee.shr.base.syssetting.app.util.MetaDataUtil.getEnum((String)pp.getMetaDataRef());
                if (null != e) {
                    if (e instanceof StringEnum || e instanceof DynamicEnum) {
                        col.put("type", "StringEnum");
                    } else {
                        col.put("type", "IntEnum");
                    }
                    col.put("enumSource", pp.getMetaDataRef());
                }
            }
        }
        if ("true".equals(isUsingF7 = qfi.getExtendedProperty("isUsingF7"))) {
            String entityName = dataObject.getValue();
            String uipk = entityName + ".list";
            col.put("type", "link");
            col.put("uipk", uipk);
        }
        return col;
    }

    private boolean hasFieldPerm(ShrFieldPerm shrFieldPerm, UIViewInfo viewinfo, String columnName) throws SHRWebException {
        String listType = viewinfo.getType();
        QueryType queryType = "dynamicList".equals(listType) ? QueryType.SCHEME : (StringUtils.isEmpty((String)viewinfo.getQuery()) ? QueryType.ENTITY : QueryType.QUERY);
        try {
            return shrFieldPerm.isAllowView(queryType, viewinfo.getModel(), columnName, viewinfo.getQuery(), false);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    private void setSensitiveRule(Context ctx, Map<String, String> attrs, Map<String, Object> col, UIViewInfo viewinfo) throws SHRWebException {
        col.put("sensitiveRule", null);
        if (null != attrs && attrs.containsKey("sensitiveRule") && !StringUtils.isEmpty((String)attrs.get("sensitiveRule"))) {
            col.put("sensitiveRule", JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), attrs.get("sensitiveRule")));
            return;
        }
        String fieldName = (String)col.get("columnName");
        IShrSensitiveService iShrSensitiveService = ShrSensitiveServiceFactory.getInstance().getIShrSensitiveService();
        Map<String, Object> sensitiveRuleValue = iShrSensitiveService.getFieldSensitiveForUipk(ctx, viewinfo.getUipk(), fieldName);
        if (null != sensitiveRuleValue) {
            col.put("sensitiveRule", sensitiveRuleValue);
            return;
        }
        sensitiveRuleValue = !StringUtils.isEmpty((String)viewinfo.getQuery()) ? iShrSensitiveService.getFieldSensitiveForQuery(ctx, viewinfo.getQuery(), fieldName) : iShrSensitiveService.getFieldSensitiveForEntity(ctx, viewinfo.getEntityName(), fieldName, attrs);
        col.put("sensitiveRule", sensitiveRuleValue);
    }
}

