/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.print.common.provider.DefaultPrintDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDistributionUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.IContextProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.KDNoteWebServerHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.AbstractPrintIntegrationInfo;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.basedata.assistant.util.CommonPrintIntegrationDataProvider;
import com.kingdee.eas.basedata.assistant.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.context.WebContextUtil;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.log.IOperateLogService;
import com.kingdee.shr.base.syssetting.log.OperateLogManager;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.component.report.CommonDataProvider;
import com.kingdee.shr.component.report.ICommonDataProvider;
import com.kingdee.shr.component.report.IReportTemplateController;
import com.kingdee.shr.json.TreeDataEntity;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/component/ReportTemplate"})
public class ReportTemplateController
extends WebComponentController
implements IReportTemplateController {
    private static Logger logger = Logger.getLogger(ReportTemplateController.class);
    public static String RPT_CTX = "shr_rpt_ctx";
    public static String PDF = "PDF";
    public static String NODE_SERVER = "shr_node_Server";
    private static Pattern PATTERN = Pattern.compile("(\r\n|\r|\n|\n\r|>|<|'|\"|;|,|\\(|\\)|\\{|\\})");

    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String billID = request.getParameter("billID");
        String tdQueryPK = request.getParameter("tdQueryPK");
        String tdTemplateName = request.getParameter("tdTemplateName");
        String dataProvider = request.getParameter("dataProvider");
        if (this.isIllegalParam(billID) || this.isIllegalParam(tdQueryPK) || this.isIllegalParam(tdTemplateName) || this.isIllegalParam(dataProvider)) {
            throw new ShrWebBizException("Illegal character in requested parameter");
        }
        request.setAttribute("billID", (Object)billID);
        request.setAttribute("tdQueryPK", (Object)tdQueryPK);
        request.setAttribute("tdTemplateName", (Object)tdTemplateName);
        request.setAttribute("dataProvider", (Object)dataProvider);
        return "/webframework/webcom/report/reportTemplate";
    }

    private boolean isIllegalParam(String value) {
        Matcher m;
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value) && (m = PATTERN.matcher(value)).find();
    }

    @Override
    public String getTemplatePath(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        String rootName;
        String tdTemplateName = request.getParameter("tdTemplateName");
        String contentPath = PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)tdTemplateName);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("name", null);
        attrs.put("alias", null);
        attrs.put("category", null);
        attrs.put("eas_template_relation_orgs", null);
        Context ctx = SHRContext.getInstance().getContext();
        attrs.put("FCOMPANYNUMBER", ContextUtil.getCurrentCtrlUnit((Context)ctx).getNumber());
        HashMap[] multiResult = null;
        try {
            IBizContext bizContext = ReportTemplateController.getBizContext();
            if (bizContext != null && bizContext.getBizContent() != null) {
                multiResult = bizContext.getBizContent().list2(contentPath, attrs);
            }
        }
        catch (KDRSException e) {
            logger.error((Object)"get template list error!", (Throwable)e);
            JSONUtils.ERROR(e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)"get template list error!", (Throwable)e);
            JSONUtils.ERROR(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "load_template_fail"), e);
        }
        boolean isRootVisible = false;
        if (request.getParameter("isRootVisible") != null) {
            isRootVisible = new Boolean(request.getParameter("isRootVisible"));
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(rootName = request.getParameter("rootName")))) {
            rootName = "";
        }
        TreeDataEntity root = null;
        if (isRootVisible) {
            root = new TreeDataEntity();
            root.setId("rootId");
            root.setNumber("rootNumber");
            root.setName(rootName);
            root.setOpen(true);
        }
        TreeDataEntity parent = root;
        if (multiResult != null && parent != null) {
            int relaRootDeep;
            for (int i = relaRootDeep = PathUtil.splitPath((String)"/EAS_Note.kdrs").length - 1; i < multiResult.length - 1; ++i) {
                String name = (String)multiResult[i].get("name");
                String alias = (String)multiResult[i].get("alias");
                TreeDataEntity childNode = new TreeDataEntity();
                childNode.setNumber(name);
                childNode.setName(alias);
                childNode.setOpen(true);
                ArrayList<TreeDataEntity> children = new ArrayList<TreeDataEntity>();
                children.add(childNode);
                parent.setChildren(children);
                parent = childNode;
            }
        }
        ArrayList<TreeDataEntity> data = new ArrayList<TreeDataEntity>();
        data.add(root);
        JSONUtils.writeJson(response, data);
        return null;
    }

    @Override
    public String getTemplateInfoList(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        String tdTemplateName = request.getParameter("tdTemplateName");
        String contentPath = PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)tdTemplateName);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("name", null);
        attrs.put("alias", null);
        attrs.put("category", null);
        attrs.put("eas_template_relation_orgs", null);
        Context ctx = SHRContext.getInstance().getContext();
        attrs.put("FCOMPANYNUMBER", ContextUtil.getCurrentCtrlUnit((Context)ctx).getNumber());
        Map vals = null;
        try {
            IBizContext bizContext = ReportTemplateController.getBizContext();
            if (bizContext != null && bizContext.getBizContent() != null) {
                vals = bizContext.getBizContent().list(contentPath, attrs);
            }
        }
        catch (KDRSException e) {
            logger.error((Object)"get template list error!", (Throwable)e);
            JSONUtils.ERROR(e.getMessage(), (Exception)((Object)e));
            return null;
        }
        if (vals != null) {
            String[] names = (String[])vals.get("name");
            String[] alias = (String[])vals.get("alias");
            String[] categories = (String[])vals.get("category");
            ArrayList items = new ArrayList();
            HashMap<String, String> val = null;
            for (int i = 0; i < names.length; ++i) {
                if (!"kdrs-form".equals(categories[i]) && !"r1-print".equals(categories[i])) continue;
                try {
                    IBizContext bizContext = ReportTemplateController.getBizContext();
                    if (bizContext == null || !this.isCanPrint(bizContext.getBizContent(), contentPath + "/" + names[i]) || ("zh_CN".equals(ctx.getOriginLocale().toString()) ? names[i].contains("[EN]") || names[i].contains("[zh_TW]") : ("en_US".equals(ctx.getOriginLocale().toString()) ? !names[i].contains("[EN]") : "zh_TW".equals(ctx.getOriginLocale().toString()) && !names[i].contains("[zh_TW]")))) continue;
                    val = new HashMap<String, String>(4);
                    val.put("name", names[i]);
                    val.put("alias", alias[i]);
                    items.add(val);
                    continue;
                }
                catch (KDRSException e) {
                    e.printStackTrace();
                }
            }
            Collections.sort(items, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> o1, Map<String, String> o2) {
                    if (o1.get("alias") == null || o2.get("alias") == null) {
                        return -1;
                    }
                    return o1.get("alias").compareTo(o2.get("alias"));
                }
            });
            JSONUtils.SUCCESS(items);
        }
        return null;
    }

    @Override
    public String getTemplateList(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        String tdTemplateName = request.getParameter("tdTemplateName");
        String contentPath = PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)tdTemplateName);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("name", null);
        attrs.put("alias", null);
        attrs.put("category", null);
        attrs.put("eas_template_relation_orgs", null);
        Context ctx = SHRContext.getInstance().getContext();
        attrs.put("FCOMPANYNUMBER", ContextUtil.getCurrentCtrlUnit((Context)ctx).getNumber());
        Map vals = null;
        try {
            IBizContext bizContext = ReportTemplateController.getBizContext();
            if (bizContext != null && bizContext.getBizContent() != null) {
                vals = bizContext.getBizContent().list(contentPath, attrs);
            }
        }
        catch (KDRSException e) {
            logger.error((Object)"get template list error!", (Throwable)e);
            JSONUtils.ERROR(e.getMessage(), (Exception)((Object)e));
            return null;
        }
        if (vals != null) {
            String[] names = (String[])vals.get("name");
            String[] alias = (String[])vals.get("alias");
            String[] categories = (String[])vals.get("category");
            ArrayList<String> items = new ArrayList<String>();
            for (int i = 0; i < names.length; ++i) {
                if (!"kdrs-form".equals(categories[i]) && !"r1-print".equals(categories[i])) continue;
                try {
                    IBizContext bizContext = ReportTemplateController.getBizContext();
                    if (bizContext == null || bizContext.getBizContent() == null || !this.isCanPrint(bizContext.getBizContent(), contentPath + "/" + names[i]) || ("zh_CN".equals(ctx.getOriginLocale().toString()) ? names[i].contains("[EN]") || names[i].contains("[zh_TW]") : ("en_US".equals(ctx.getOriginLocale().toString()) ? !names[i].contains("[EN]") : "zh_TW".equals(ctx.getOriginLocale().toString()) && !names[i].contains("[zh_TW]")))) continue;
                    items.add(names[i] + "," + alias[i]);
                    continue;
                }
                catch (KDRSException e) {
                    e.printStackTrace();
                }
            }
            JSONUtils.SUCCESS(items);
        }
        return null;
    }

    @Override
    public String reportAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        String tdTemplatePath = request.getParameter("tdTemplatePath");
        String tdRptTemplate = request.getParameter("tdRptTemplate");
        String templatePath = tdTemplatePath + "/" + tdRptTemplate;
        Context ctx = SHRContext.getInstance().getContext();
        IOperateLogService service = null;
        try {
            service = OperateLogManager.getIOperateLogService(ctx, OperateLogManager.getPrintLogConfigBean(ctx));
            if (null != service) {
                service.preLogHandle(request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Object dataProvider = this.getDataProvider(request, response, modelMap);
            ReportTemplateController.export(request, response, modelMap, templatePath, dataProvider, "PDF");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SHRWebException(e);
        }
        try {
            if (null != service) {
                service.postLogHandle(request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String templatePath, Object dataProvider, String type) throws IOException, SHRWebException {
        if (templatePath == null) {
            return;
        }
        try {
            templatePath = URLDecoder.decode(templatePath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("decode url error when export. the url is :" + SHRCheck.vaildLog((String)templatePath)));
        }
        logger.info((Object)("Note output PDF start..." + SHRCheck.vaildLog((String)templatePath)));
        KDNoteWebServerHelper webServerHelper = (KDNoteWebServerHelper)SHRContext.getSessionContext().get(NODE_SERVER);
        if (webServerHelper == null) {
            IBizContext bizContext;
            if (logger.isInfoEnabled()) {
                logger.info((Object)"WAF Debug for Dynform framework ,webServerHelper get is null from Session by key shr_node_Server,then ");
            }
            if ((bizContext = ReportTemplateController.getBizContext()) != null) {
                webServerHelper = (KDNoteWebServerHelper)SHRContext.getSessionContext().get(NODE_SERVER);
            } else {
                JSONUtils.ERROR(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "is_empty"), "bizContext"));
            }
        }
        if (webServerHelper == null) {
            JSONUtils.ERROR("cann't find context server!");
        }
        String fname = templatePath.toString();
        fname = fname.substring(fname.lastIndexOf("/") + 1) + ".pdf";
        response.setHeader("Content-Disposition", SHRCheck.checkFileNameForSetResponseHeader((String)("inline; filename=\"" + URLEncoder.encode(fname, "UTF-8") + "\"")));
        if (PDF.equals(type)) {
            response.setContentType("application/pdf");
        }
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            if (webServerHelper != null) {
                webServerHelper.setBosContext(WebContextUtil.getEasContext(request));
                webServerHelper.exportPDF(templatePath, dataProvider, (OutputStream)out);
            }
        }
        catch (Exception e0) {
            logger.error((Object)"export pdf error:", (Throwable)e0);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public static IBizContext getBizContext() {
        IBizContext biaContext = (IBizContext)SHRContext.getSessionContext().get(RPT_CTX);
        if (biaContext != null) {
            return biaContext;
        }
        try {
            KDNoteWebServerHelper nodeWeb = new KDNoteWebServerHelper();
            nodeWeb.setContextProvider(new IContextProvider(){

                public IBizContext getBizContext(Context bosCtx) {
                    IBizContext ctx = (IBizContext)SHRContext.getSessionContext().get(RPT_CTX);
                    if (ctx != null) {
                        return ctx;
                    }
                    try {
                        ctx = KDNoteHelper.makeContext((Context)SHRContext.getInstance().getContext());
                        SHRContext.getSessionContext().put(RPT_CTX, ctx);
                    }
                    catch (ConnectException e) {
                        logger.error((Object)"get page data error!", (Throwable)e);
                        return null;
                    }
                    return ctx;
                }
            });
            SHRContext.getSessionContext().put(NODE_SERVER, nodeWeb);
            return nodeWeb.getThisBizContext();
        }
        catch (Exception e) {
            logger.error((Object)"get page data error!", (Throwable)e);
            return null;
        }
    }

    private boolean isCanPrint(IBizContent bizCtn, String absPathText) throws KDRSException {
        HashMap attrs = bizCtn.getAttributes(absPathText, new String[]{"user_enabled_users"});
        String currentUser = SHRContext.getInstance().getContext().getUserName();
        String users = (String)attrs.get("user_enabled_users");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)users)) {
            return true;
        }
        Set usersSet = NoteDistributionUtil.usersStr2Set((String)users);
        return usersSet.contains(currentUser);
    }

    public Object getDataProvider(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException {
        boolean isSelectedAll;
        Object data = null;
        String tdRptTemplate = request.getParameter("tdRptTemplate");
        String tdQueryPK = request.getParameter("tdQueryPK");
        List<String> idList = new ArrayList();
        String isSelectedAllStr = request.getParameter("isSelectedAll");
        String queryUuidStr = request.getParameter("queryUuid");
        String billID = request.getParameter("billID");
        Context ctx = WebContextUtil.getWebContext(request).getEasContext();
        String dataProvider = request.getParameter("dataProvider");
        boolean bl = isSelectedAll = isSelectedAllStr != null && isSelectedAllStr.equalsIgnoreCase("true");
        if (isSelectedAll) {
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)tdQueryPK));
            idList = exec.getBillIDList(Uuid.read((String)queryUuidStr), "id", 0, 0);
        } else {
            String[] billIDs;
            for (String s : billIDs = billID.split(",")) {
                idList.add(s);
            }
        }
        KDNoteWebServerHelper webServerHelper = (KDNoteWebServerHelper)SHRContext.getSessionContext().get("node_Server");
        if (webServerHelper == null) {
            IBizContext bizContext;
            if (logger.isInfoEnabled()) {
                logger.info((Object)"WAF Debug for Dynform framework ,webServerHelper get is null from Session by key node_Server,then ");
            }
            if ((bizContext = ReportTemplateController.getBizContext()) != null) {
                webServerHelper = (KDNoteWebServerHelper)SHRContext.getSessionContext().get("node_Server");
            } else {
                JSONUtils.ERROR("bizContext is empty !");
            }
        }
        MetaDataPK tdQuery = null;
        if (tdQueryPK != null) {
            tdQuery = MetaDataPK.create((String)tdQueryPK);
        }
        if (!StringUtils.isEmpty((String)dataProvider)) {
            if ("com.kingdee.bos.ctrl.print.common.provider.DefaultPrintDataProvider".equals(dataProvider)) {
                data = new DefaultPrintDataProvider(ctx, idList, (IMetaDataPK)tdQuery);
            } else if ("com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider".equals(dataProvider)) {
                data = new DefaultNoteDataProvider(ctx, idList, (IMetaDataPK)tdQuery);
            } else {
                try {
                    Constructor<?>[] ctor = MsfClassLoaderFactory.forName((String)dataProvider).getDeclaredConstructors();
                    logger.debug((Object)("-------start--------dataprovider is " + dataProvider));
                    int total = ctor.length;
                    for (int i = 0; i < total; ++i) {
                        Class<?>[] cl = ctor[i].getParameterTypes();
                        if (cl.length == 1) {
                            data = MsfClassLoaderFactory.forName((String)dataProvider).getConstructor(cl).newInstance(billID);
                            continue;
                        }
                        if (cl.length != 2) continue;
                        data = MsfClassLoaderFactory.forName((String)dataProvider).getConstructor(cl).newInstance(billID, tdQueryPK);
                        break;
                    }
                    logger.debug((Object)("------end---------dataprovider is " + dataProvider));
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (data == null) {
                    try {
                        data = Class.forName(dataProvider).newInstance();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        } else {
            data = new DefaultNoteDataProvider(ctx, idList, (IMetaDataPK)tdQuery);
        }
        if (null == data) {
            data = new CommonDataProvider(idList, (IMetaDataPK)tdQuery);
        }
        if (data instanceof ICommonDataProvider) {
            ((ICommonDataProvider)data).setContext(ctx);
        }
        data = this.printTimesControl(request, data, idList, tdRptTemplate);
        return data;
    }

    private Object printTimesControl(HttpServletRequest request, Object data, List idList, String rptTemplate) throws BOSException {
        MultiDataSourceDataProviderProxy multiDataProvider = new MultiDataSourceDataProviderProxy();
        StringBuffer failToPrintMsg = new StringBuffer();
        try {
            HashMap printAttributes = null;
            IBizContext bizContext = ReportTemplateController.getBizContext();
            if (bizContext != null && bizContext.getBizContent() != null) {
                printAttributes = bizContext.getBizContent().getAttributes("/EAS_Note.kdrs/s-HR/AffairBiz/EmpEnroll/EmpEnrollBiz.r1-print", new String[]{"isselected", "prttimes"});
            }
            if (printAttributes != null && printAttributes.get("isselected") == null) {
                return data;
            }
            int curNum = 1;
            if (printAttributes != null) {
                boolean isTimesCtrl;
                boolean bl = isTimesCtrl = Integer.parseInt(String.valueOf(printAttributes.get("isselected"))) == 1;
                if (!isTimesCtrl) {
                    return data;
                }
            }
            ObjectUuidPK pk = new ObjectUuidPK(idList.get(0).toString());
            String bosType = pk.getObjectType().toString();
            IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
            List infoList = pinfo.getBillsPrintInfoByList(idList, bosType);
            if (rptTemplate != null && rptTemplate.trim().length() > 0) {
                for (int i = 0; i < infoList.size(); ++i) {
                    Object[] objs;
                    String msgInfo;
                    String billNumber;
                    logger.info((Object)"start the print control!");
                    int maxNum = 0;
                    if (printAttributes != null && printAttributes.get("prttimes") != null) {
                        maxNum = Integer.parseInt(String.valueOf(printAttributes.get("prttimes")));
                    }
                    int pnum = ((AbstractPrintIntegrationInfo)infoList.get(i)).getPrintedNumber();
                    String billID1 = ((AbstractPrintIntegrationInfo)infoList.get(i)).getPrintBillID();
                    logger.info((Object)("Max print number:>>" + maxNum));
                    logger.info((Object)("Alreadey print number:>>" + pnum));
                    logger.info((Object)("current print number:>>" + curNum));
                    if (pnum >= maxNum) {
                        idList.remove(billID1);
                        billNumber = pinfo.getBillNumberByBosType(bosType, billID1);
                        msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.controlinfo1");
                        objs = new Object[]{billNumber, String.valueOf(curNum), String.valueOf(pnum), String.valueOf(maxNum)};
                        failToPrintMsg.append(MessageFormat.format(msgInfo, objs) + "\n");
                        ReportTemplateController.HTML(failToPrintMsg.toString());
                        continue;
                    }
                    if (curNum + pnum <= maxNum) continue;
                    idList.remove(billID1);
                    billNumber = pinfo.getBillNumberByBosType(bosType, billID1);
                    msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.controlinfo2");
                    objs = new Object[]{billNumber, String.valueOf(curNum), String.valueOf(pnum), String.valueOf(maxNum)};
                    failToPrintMsg.append(MessageFormat.format(msgInfo, objs) + "\n");
                    ReportTemplateController.HTML(failToPrintMsg.toString());
                }
            }
            multiDataProvider.put("MainQuery", (BOSQueryDelegate)data);
            CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(bosType.toString(), PrintIntegrationManager.getPrintQueryPK());
            multiDataProvider.put("PrintQuery", (BOSQueryDelegate)printQueryData);
            PrintIntegrationManager.initPrint((KDNoteHelper)((KDNoteWebServerHelper)SHRContext.getSessionContext().get(NODE_SERVER)), (BOSObjectType)pk.getObjectType(), (List)idList, (String)rptTemplate, (String)"com.kingdee.eas.scm.common.SCMResource", (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return data;
        }
        return multiDataProvider;
    }

    public static void HTML(String message) throws ShrWebBizException {
        PrintWriter pw;
        ServletResponse response = SHRContext.getInstance().getResponse();
        try {
            pw = response.getWriter();
        }
        catch (IOException e) {
            throw new ShrWebBizException("can't open the output stream!");
        }
        pw.write(message);
        pw.flush();
        pw.close();
    }
}

