/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.util.SHRPermissionParamUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.secrity.AESUtils;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.MultiLangUtils;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SHRPermissionWebUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.handler.CoreHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.common.util.XssFilterUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;
import org.springframework.util.ReflectionUtils;

public class DynamicUtil {
    private static Logger logger = Logger.getLogger(DynamicUtil.class);
    private static Set<String> HANDLER_WHITELIST = new HashSet<String>();

    public static String assembleUrl(String url, HttpServletRequest request) {
        url = DynamicUtil.appendUrlParam(url, "uipk", request.getParameter("uipk"));
        return url;
    }

    public static String appendUrlParam(String url, String name, String value) {
        if (url == null || StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)value)) {
            return url;
        }
        StringBuilder newUrl = new StringBuilder(url);
        if (url.indexOf("?") == -1) {
            newUrl.append("?");
        } else {
            newUrl.append("&");
        }
        newUrl.append(name);
        newUrl.append("=");
        newUrl.append(value);
        return newUrl.toString();
    }

    public static String assembleUrl(String url, Map params) {
        Context ctx = SHRContext.getInstance().getContext();
        return DynamicUtil.assembleUrl(ctx, url, params);
    }

    public static String assembleUrl(Context ctx, String url, Map params) {
        StringBuilder redirectUrl = new StringBuilder(url);
        if (redirectUrl.indexOf("?") == -1) {
            redirectUrl.append('?');
        } else {
            redirectUrl.append('&');
        }
        String key2 = null;
        String value = null;
        int index = 0;
        for (String key2 : params.keySet()) {
            value = params.get(key2) instanceof String ? (String)params.get(key2) : JSONUtils.convertObjectToJson(ctx, params.get(key2));
            if (index != 0) {
                redirectUrl.append('&');
            }
            redirectUrl.append(key2);
            redirectUrl.append("=");
            redirectUrl.append(URLEncoder.encode(value));
            ++index;
        }
        DynamicUtil.appendEncryptParam(ctx, redirectUrl, params);
        return redirectUrl.toString();
    }

    private static void appendEncryptParam(Context ctx, StringBuilder redirectUrl, Map params) {
        if (DynamicUtil.isAddPermissionParam(params)) {
            StringBuilder values = new StringBuilder();
            values.append("file").append("=").append((String)params.get("file")).append(",");
            values.append("filename").append("=").append((String)params.get("filename")).append(",");
            values.append("userId").append("=").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            try {
                redirectUrl.append("&_p_v_s_").append("=").append(URLEncoder.encode(AESUtils.cbcEncrypt((String)values.toString(), (String)AESUtils.getUrlParamEncryptKey())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isAddPermissionParam(Map params) {
        String keyValue;
        return params.get("method") instanceof String && ("tmp".equals(keyValue = (String)params.get("method")) || "file".equals(keyValue) || "export".equals(keyValue));
    }

    public static Map getRequestParameters(HttpServletRequest request) {
        Set paramSet = request.getParameterMap().keySet();
        HashMap<String, String> params = new HashMap<String, String>();
        String key2 = null;
        for (String key2 : paramSet) {
            params.put(key2, request.getParameter(key2));
        }
        return params;
    }

    public static String convertId(String id) {
        if (!StringUtils.isEmpty((String)id)) {
            id = id.replace('.', '_');
        }
        return id;
    }

    public static String getContextPath() {
        HttpServletRequest request = (HttpServletRequest)SHRContext.getInstance().getRequest();
        return request.getContextPath();
    }

    public static String firstUpperCase(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        return str.substring(0, 1).toUpperCase().concat(str.substring(1));
    }

    public static boolean asSubClass(Class source, Class desc) {
        try {
            Class result = source.asSubclass(desc);
            if (result == null) {
                return false;
            }
        }
        catch (Exception exeption) {
            return false;
        }
        return true;
    }

    public static void setObjectPropertyValue(CoreBaseInfo coreBaseInfo, String property, String value) throws SHRWebException {
        if (coreBaseInfo == null || StringUtils.isEmpty((String)property)) {
            return;
        }
        String[] strs = property.split("\\.");
        String propertyName = strs[0];
        Class clazz = DynamicUtil.getObjectPropertyInfo(coreBaseInfo, propertyName);
        if (DynamicUtil.asSubClass(clazz, IObjectValue.class)) {
            IObjectValue objectValue = MetaDataUtil.newInstance(clazz);
            objectValue.put("id", (Object)BOSUuid.read((String)value));
            coreBaseInfo.put(propertyName, (Object)objectValue);
        } else if (DynamicUtil.asSubClass(clazz, BOSUuid.class)) {
            coreBaseInfo.put(propertyName, (Object)BOSUuid.read((String)value));
        } else if (DynamicUtil.asSubClass(clazz, String.class)) {
            coreBaseInfo.put(propertyName, (Object)value);
        }
    }

    private static Class getObjectPropertyInfo(CoreBaseInfo coreBaseInfo, String propertyName) throws SHRWebException {
        Type returnType = MetaDataUtil.getMetadataValueType((IObjectValue)coreBaseInfo, propertyName);
        if (returnType != null && returnType instanceof Class) {
            return (Class)returnType;
        }
        return null;
    }

    public static Object getObjectPropertyValue(CoreBaseInfo coreBaseInfo, String property) {
        if (coreBaseInfo == null || StringUtils.isEmpty((String)property)) {
            return null;
        }
        CoreBaseInfo tempObject = coreBaseInfo;
        Object value = null;
        String[] strs = property.split("\\.");
        int length = strs.length;
        for (int i = 0; i < length && (value = MultiLangUtils.isMultiLangEntityProperty(tempObject.getBOSType(), strs[i]) ? tempObject.get(strs[i], SHRContext.getInstance().getContext().getLocale()) : tempObject.get(strs[i])) != null; ++i) {
            if (!(value instanceof CoreBaseInfo)) continue;
            tempObject = (CoreBaseInfo)value;
        }
        return value;
    }

    public static Object newInstance(String className) throws SHRWebException {
        try {
            Class clazz = MsfClassLoaderFactory.forName((String)className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    public static String invokeHandlerMethod(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String handler, String methodName) throws SHRWebException {
        try {
            Class clazz = MsfClassLoaderFactory.forName((String)handler);
            Method method = ReflectionUtils.findMethod((Class)clazz, (String)methodName, (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class, ModelMap.class});
            if (method == null) {
                logger.error((Object)MessageFormat.format(" can not find methodName : {0}", SHRCheck.vaildLog((String)methodName)));
                String handlers = (String)request.getAttribute("_uiview_handler_and_req_handler_");
                if (StringUtils.isEmpty((String)handlers)) {
                    throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "mthod_not_in_handler"));
                }
                String[] hs = handlers.split(",");
                String reqHandler = SHRCheck.vaildLog((String)hs[0]);
                System.out.println(MessageFormat.format(" uiview handler [{0}] and request handler [{0}] is different.", hs[1], reqHandler));
                String href = "<a href='/shr/dynamic.do?method=addHandlerWhiteList&uipk=com.kingdee.shr.base.syssetting.app.UIView.list&handler=" + reqHandler + "'>";
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "request_contain_handler_error", href, "</a>"));
            }
            long start = 0L;
            long end = 0L;
            if (logger.isDebugEnabled()) {
                start = new Date().getTime();
            }
            Object object = ReflectionUtils.invokeMethod((Method)method, clazz.newInstance(), (Object[])new Object[]{request, response, modelMap});
            if (logger.isDebugEnabled()) {
                end = new Date().getTime();
                logger.debug((Object)MessageFormat.format("handler: {0}, method: {1}, cost: {2}", SHRCheck.vaildLog((String)handler), SHRCheck.vaildLog((String)methodName), end - start));
            }
            return object != null ? object.toString() : null;
        }
        catch (ClassNotFoundException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    public static CoreHandler newHandler(String uipk) throws SHRWebException {
        UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(SHRContext.getInstance().getContext(), uipk);
        String className = uiViewInfo.getHandler();
        if (StringUtils.isEmpty((String)className)) {
            throw new ShrWebBizException(MessageFormat.format("uipk '{0}'s handler is null", uipk));
        }
        CoreHandler handler = (CoreHandler)DynamicUtil.newInstance(className);
        handler.setUipk(uipk);
        return handler;
    }

    public static String getProductionMode(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object value = session.getAttribute("productionMode");
        if (value == null) {
            value = session.getServletContext().getAttribute("productionMode");
        }
        return (String)value;
    }

    public static boolean isProductionMode(HttpServletRequest request) {
        return "production".equals(DynamicUtil.getProductionMode(request));
    }

    public static int getTableFileldLengthFromDB(String entityName, String fieldName) {
        PropertyInfo propertyInfo = MetaDataUtil.getPropertyInfo(entityName, fieldName);
        if (null == propertyInfo) {
            logger.error((Object)MessageFormat.format(" getTableFileldLengthFromDB propertyInfo is null. entityName: {0}, filedName: {1}, ", entityName, fieldName));
            return 0;
        }
        ColumnInfo mappingField = propertyInfo.getMappingField();
        if (null == mappingField) {
            logger.error((Object)MessageFormat.format(" getTableFileldLengthFromDB propertyInfo.getMappingField() is null. entityName: {0}, filedName: {1}, ", entityName, fieldName));
            return 0;
        }
        String columnName = mappingField.getName();
        if (StringUtils.isEmpty((String)columnName)) {
            logger.error((Object)MessageFormat.format(" getTableFileldLengthFromDB mappingField.getName() is empty. entityName: {0}, filedName: {1},columnName: {2} ", entityName, fieldName, columnName));
            return 0;
        }
        try {
            Context ctx = SHRContext.getInstance().getContext();
            if (mappingField.isMultilingual()) {
                columnName = columnName + "_" + ctx.getLocale().getDisplayName();
            }
            String tableName = MetaDataUtil.getEntityObjectByEntityName(entityName).getTable().getName();
            return DynamicUtil.getTableColumnLen(ctx, tableName, columnName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTableColumnLen(Context ctx, String table, String column) {
        ResultSet rs;
        Statement statement;
        Connection conn;
        block5: {
            int n;
            if (StringUtils.isEmpty((String)table) || StringUtils.isEmpty((String)column)) {
                return 0;
            }
            String sql = "select top 1 " + column + " from " + table;
            conn = null;
            statement = null;
            rs = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                statement = conn.createStatement();
                rs = statement.executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                if (rsmd.getColumnCount() <= 0) break block5;
                n = rsmd.getColumnDisplaySize(1);
            }
            catch (SQLException exc) {
                try {
                    logger.error((Object)(" error sql is :" + sql));
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
            return n;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return 0;
    }

    public static String getHandler(HttpServletRequest request) throws SHRWebException {
        UIViewInfo uiViewInfo;
        String uipk;
        request.removeAttribute("_uiview_handler_and_req_handler_");
        String handler = request.getParameter("handler");
        XssFilterUtil.stripXSS((String)handler, (String)"handler");
        Context ctx = SHRContext.getInstance().getContext();
        boolean isHandlerRefuse = SHRPermissionParamUtil.isSHRPermissionHandlerRefuse((Context)ctx);
        boolean isHandlerWhiteList = DynamicUtil.inHandlerWhiteList(ctx, handler);
        if (!StringUtils.isEmpty((String)handler) && !isHandlerRefuse || !StringUtils.isEmpty((String)handler) && isHandlerRefuse) {
            for (String handlerWhite : HANDLER_WHITELIST) {
                if (!handlerWhite.equals(handler) && !isHandlerWhiteList) continue;
                return handler;
            }
        }
        if (!StringUtils.isEmpty((String)(uipk = DynamicUtil.getUIPK(request))) && (uiViewInfo = UIViewUtil.getCurrentUIViewInfo((ServletRequest)request)) != null) {
            if (!StringUtils.isEmpty((String)handler) && !uiViewInfo.getHandler().equals(handler)) {
                request.setAttribute("_uiview_handler_and_req_handler_", (Object)MessageFormat.format("{0},{1}", handler, uiViewInfo.getHandler()));
            }
            return uiViewInfo.getHandler();
        }
        return null;
    }

    private static boolean inHandlerWhiteList(Context ctx, String handler) throws SHRWebException {
        String sql = "SELECT COUNT(1) CC FROM T_SHR_HandlerWhiteList where FServiceName =?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{handler});
            while (rs.next()) {
                int count = rs.getInt("CC");
                if (count <= 0) continue;
                return true;
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (SQLException e) {
            throw new SHRWebException(e);
        }
        return false;
    }

    public static Set<String> getHandlerWhiteList(Context ctx) throws SHRWebException {
        HashSet<String> handlerSet = new HashSet<String>();
        handlerSet.addAll(HANDLER_WHITELIST);
        String sql = "SELECT FServiceName handler FROM T_SHR_HandlerWhiteList";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String handler = rs.getString("handler");
                handlerSet.add(handler);
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (SQLException e) {
            throw new SHRWebException(e);
        }
        return handlerSet;
    }

    public static String getUIPK(HttpServletRequest request) {
        String uipk = request.getParameter("uipk");
        uipk = SHRPermissionWebUtils.getRealUipk(uipk);
        return uipk;
    }

    static {
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.ImportInfoHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.ExportInfoHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.GlobalWaterMarkHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.SysPatchToolsHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.PersonalNantionalPlanEditHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.LogJarClassInfoToolsHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.ShrLoseCheckToolsHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.SystemConfigSolutionHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.SignatureRecordListHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.DocumentationConfigListHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.DevUtilHandler");
        HANDLER_WHITELIST.add("com.kingdee.eas.hr.emp.web.handler.timezone.HRTimeZoneServiceHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.ScriptHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.PublicSolutionHandler");
        HANDLER_WHITELIST.add("com.kingdee.shr.base.syssetting.web.handler.DynamicListFilterSchemeListHandler");
    }
}

