/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.filter;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.context.WebContextUtil;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.util.UrlParamEncryptHelper;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SHRRequestParameterWrapFilter
implements Filter {
    private static Logger logger = Logger.getLogger(SHRRequestParameterWrapFilter.class);
    private boolean enableSHRRequestParamWrapFilter = true;

    public void init(FilterConfig filterConfig) throws ServletException {
        String initParameter = filterConfig.getInitParameter("enableSHRRequestParamWrapFilter");
        if (!StringUtils.isEmpty((String)initParameter)) {
            this.enableSHRRequestParamWrapFilter = Boolean.valueOf(initParameter);
        }
        logger.debug((Object)" SHRRequestParamWrapFilter init success ");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        SHRRequestParameterWrapper sHRRequestParameterWrapper = new SHRRequestParameterWrapper(httpRequest);
        if (this.enableSHRRequestParamWrapFilter) {
            filterChain.doFilter((ServletRequest)sHRRequestParameterWrapper, (ServletResponse)httpResponse);
        } else {
            logger.error((Object)" SHRRequestParameterWrapFilter param disable , please check web.xml SHRRequestParameterWrapFilter ");
            filterChain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    class SHRRequestParameterWrapper
    extends HttpServletRequestWrapper {
        private static final String ENCRYPT_SIGNAL = "encryptKeys";
        private String encryptKeys;
        private Context ctx;

        public SHRRequestParameterWrapper(HttpServletRequest request) {
            super(request);
            this.encryptKeys = "";
            this.ctx = null;
            this.encryptKeys = request.getParameter(ENCRYPT_SIGNAL);
            this.ctx = WebContextUtil.getEasContext(request);
        }

        public Map<String, String[]> getParameterMap() {
            Map parameterMap = super.getParameterMap();
            Map<String, String[]> wrapperparameterMap = Collections.synchronizedMap(new LinkedHashMap());
            if (!StringUtils.isEmpty((String)this.encryptKeys)) {
                Enumeration enumeration = this.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    String name = (String)enumeration.nextElement();
                    String[] values = this.getParameterValues(name);
                    wrapperparameterMap.put(name, values);
                }
                return wrapperparameterMap;
            }
            return parameterMap;
        }

        public String[] getParameterValues(String parameter) {
            String[] values = super.getParameterValues(parameter);
            if (values == null) {
                return null;
            }
            int count = values.length;
            String[] encodedValues = new String[count];
            Object[] encryptKeys = this.getEncryptKeys();
            for (int i = 0; i < count; ++i) {
                String value = values[i];
                if (ENCRYPT_SIGNAL.equals(parameter)) {
                    if (null != encryptKeys && encryptKeys.length > 0) {
                        value = StringUtils.arrayToString((Object[])encryptKeys, (String)",");
                    }
                } else if (this.isEncryptKey((String[])encryptKeys, parameter)) {
                    try {
                        value = UrlParamEncryptHelper.decodeValue(this.ctx, value);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                } else {
                    value = this.processBillIdValueWhenIncludeTableSpace(parameter, value);
                }
                encodedValues[i] = value;
            }
            return encodedValues;
        }

        public String getParameter(String parameter) {
            String value = super.getParameter(parameter);
            Object[] encryptKeys = this.getEncryptKeys();
            if (ENCRYPT_SIGNAL.equals(parameter)) {
                if (null != encryptKeys && encryptKeys.length > 0) {
                    return StringUtils.arrayToString((Object[])encryptKeys, (String)",");
                }
            } else if (this.isEncryptKey((String[])encryptKeys, parameter)) {
                try {
                    value = UrlParamEncryptHelper.decodeValue(this.ctx, value);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else {
                value = this.processBillIdValueWhenIncludeTableSpace(parameter, value);
            }
            return value;
        }

        private String processBillIdValueWhenIncludeTableSpace(String parameter, String value) {
            if (("billId".equals(parameter) || "billID".equals(parameter)) && !StringUtils.isEmpty((String)value) && !StringUtils.isEmpty((String)value) && value.indexOf(" ") > -1) {
                value = value.replaceAll(" ", "+");
            }
            return value;
        }

        public boolean getBase64Value(String key1) {
            boolean base64FilterValue = false;
            Map<String, String[]> paramMap = this.getParameterMap();
            String base64Filter = "";
            try {
                if (null == paramMap) {
                    return base64FilterValue;
                }
                String[] filterKeyObj = paramMap.get(key1);
                if (filterKeyObj instanceof String[]) {
                    String[] keyArray = filterKeyObj;
                    if (keyArray.length > 0) {
                        base64Filter = String.valueOf(keyArray[0]);
                    }
                } else if (filterKeyObj instanceof String) {
                    base64Filter = String.valueOf(filterKeyObj);
                }
                if (!StringUtils.isEmpty((String)base64Filter)) {
                    base64FilterValue = Boolean.valueOf(base64Filter);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return base64FilterValue;
        }

        private String[] getEncryptKeys() {
            String[] arry = null;
            if (!StringUtils.isEmpty((String)this.encryptKeys)) {
                try {
                    if (this.encryptKeys.startsWith("encryptKeys:")) {
                        this.encryptKeys = UrlParamEncryptHelper.decodeValue(this.ctx, this.encryptKeys.substring(ENCRYPT_SIGNAL.length() + 1));
                    }
                    arry = this.encryptKeys.split(",");
                }
                catch (SHRWebException e) {
                    logger.error((Object)e);
                    e.printStackTrace();
                }
            }
            return arry;
        }

        private boolean isEncryptKey(String[] encryptKeys, String key) {
            if (null != encryptKeys && encryptKeys.length > 0) {
                for (String encryptKey : encryptKeys) {
                    if (!encryptKey.equalsIgnoreCase(key)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

