/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.action.DataPlatformAction;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.context.SHRRequestWorkPlatformUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SHRRequestWorkPlatformFilter
implements Filter {
    private static Logger logger = Logger.getLogger(SHRRequestWorkPlatformFilter.class);
    private static final String INDEX = "/addon/dataplatform/web/build/index.html";
    private static final String PREVIEW = "/addon/dataplatform/web/build/preview.html";
    private static final String UIPK_PAGE = "shr.workplatform.homepage";
    private static final String UIPK_SOLUTION = "com.kingdee.shr.dataplatform.app.WorkPFSolutionForm";
    private static final String METHOD = "editPlatForm";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (SHRRequestWorkPlatformUtil.isInHandlerWhiteList(request.getRequestURI())) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            Context ctx = SHRContext.getInstance().getContext();
            String url = request.getRequestURI();
            String method = request.getParameter("method");
            String uipk = request.getParameter("uipk");
            if (url.contains(INDEX) || url.contains(PREVIEW)) {
                if (StringUtils.isEmpty((String)uipk)) {
                    response.sendRedirect("/shr/404.jsp");
                } else {
                    String pageId = request.getParameter("pageId");
                    String permItemKey = MessageFormat.format("{0}{1}", uipk, pageId);
                    if ((UIPK_PAGE.equals(uipk) || UIPK_SOLUTION.equals(uipk)) && null != DataPlatformAction.getPremItemId(ctx, uipk)) {
                        filterChain.doFilter(servletRequest, servletResponse);
                    } else if (METHOD.equals(method) && url.contains(INDEX) || url.contains(PREVIEW)) {
                        if (!StringUtils.isEmpty((String)((String)request.getSession().getAttribute(permItemKey)))) {
                            filterChain.doFilter(servletRequest, servletResponse);
                        } else {
                            try {
                                DataPlatformAction.setPremission(ctx, uipk, pageId, request);
                                filterChain.doFilter(servletRequest, servletResponse);
                            }
                            catch (EASBizException e) {
                                throw new ServletException((Throwable)e);
                            }
                            catch (BOSException e1) {
                                throw new ServletException((Throwable)e1);
                            }
                        }
                    } else {
                        response.sendRedirect("/shr/404.jsp");
                    }
                }
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
        }
    }

    public void destroy() {
    }
}

