/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.filter.sqlinject;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLInjectionFilterRequestWrapper
extends HttpServletRequestWrapper {
    private static Logger logger = LoggerFactory.getLogger(SQLInjectionFilterRequestWrapper.class);
    private static final String SPACE_MARK = " ";
    private String[] sqlKeyword;
    private String[] sqlinjectfilterparams;

    public SQLInjectionFilterRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String[] getSqlKeyword() {
        return this.sqlKeyword;
    }

    public void setSqlKeyword(String[] sqlKeyword) {
        this.sqlKeyword = sqlKeyword;
    }

    public String[] getSqlinjectfilterparams() {
        return this.sqlinjectfilterparams;
    }

    public void setSqlinjectfilterparams(String[] sqlinjectfilterparams) {
        this.sqlinjectfilterparams = sqlinjectfilterparams;
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            String value = values[i];
            encodedValues[i] = this.sqlInjectionValueWrapper(value, parameter);
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        return this.sqlInjectionValueWrapper(value, parameter);
    }

    private String sqlInjectionValueWrapper(String sourceValue, String key) {
        return this.dowarpperParamValue(sourceValue, key);
    }

    public String dowarpperParamValue(String sourceValue, String key) {
        String[] bySeparatedSpaceValues;
        if (StringUtils.isEmpty((String)sourceValue)) {
            return sourceValue;
        }
        if (this.isIncluedKeyWordListByEqualsIgnoreCase(sourceValue)) {
            logger.info(MessageFormat.format(" request Value is {0}, intercept value is {1}, ingore sql injection intercept ", SHRCheck.vaildLog((String)sourceValue), SHRCheck.vaildLog((String)sourceValue)));
            return sourceValue;
        }
        if (!this.isIncluedarametersListByEqualsIgnoreCase(key)) {
            return this.checkValueDBFunction(sourceValue, key);
        }
        for (String valueItem : bySeparatedSpaceValues = sourceValue.split(SPACE_MARK)) {
            if (StringUtils.isEmpty((String)valueItem) || !this.isIncluedKeyWordListByEqualsIgnoreCase(valueItem)) continue;
            String msg = MessageFormat.format(" SQLInjection ,request Value: {0}, include key word :{1}, value replaced by sqlinjectionkeyword ", SHRCheck.vaildLog((String)sourceValue), SHRCheck.vaildLog((String)sourceValue));
            logger.info(SHRCheck.vaildLog((String)msg));
            throw new IllegalArgumentException("Found SQL Injection for Parameter: " + key);
        }
        return this.appScanRuleHandler(sourceValue);
    }

    private String checkValueDBFunction(String sourceValue, String key) {
        if (StringUtils.isEmpty((String)sourceValue)) {
            return sourceValue;
        }
        this.doCheckValueDBFunction(sourceValue, key);
        String tmp = sourceValue.replaceAll(SPACE_MARK, "");
        this.doCheckValueDBFunction(tmp, key);
        return this.appScanRuleHandler(sourceValue);
    }

    private void doCheckValueDBFunction(String sourceValue, String key) {
        if (StringUtils.isEmpty((String)sourceValue)) {
            return;
        }
        String tmp = sourceValue.toLowerCase();
        String charFun0 = "char(";
        String asciiFun0 = "ascii(";
        String existsFun0 = "exists(";
        String all_tab_columns_key = "all_tab_columns";
        String table_schema_key = "table_schema";
        if (tmp.indexOf(charFun0) > -1) {
            logger.info(MessageFormat.format(" request Value is {0}, intercept str is {1}, parameter is {2}", sourceValue, charFun0, key));
            throw new IllegalArgumentException("Found SQL Injection for Parameter: " + key);
        }
        if (tmp.indexOf(asciiFun0) > -1) {
            logger.info(MessageFormat.format(" request Value is {0}, intercept str is {1}, parameter is {2}", sourceValue, asciiFun0, key));
            throw new IllegalArgumentException("Found SQL Injection for Parameter: " + key);
        }
        if (tmp.indexOf(existsFun0) > -1) {
            logger.info(MessageFormat.format(" request Value is {0}, intercept str is {1}, parameter is {2}", sourceValue, existsFun0, key));
            throw new IllegalArgumentException("Found SQL Injection for Parameter: " + key);
        }
        if (tmp.indexOf(all_tab_columns_key) > -1) {
            logger.info(MessageFormat.format(" request Value is {0}, intercept str is {1}, parameter is {2}", sourceValue, all_tab_columns_key, key));
            throw new IllegalArgumentException("Found SQL Injection for Parameter: " + key);
        }
        if (tmp.indexOf(table_schema_key) > -1) {
            logger.info(MessageFormat.format(" request Value is {0}, intercept str is {1}, parameter is {2}", sourceValue, table_schema_key, key));
            throw new IllegalArgumentException("Found SQL Injection for Parameter: " + key);
        }
    }

    private String appScanRuleHandler(String sourceValue) {
        if (StringUtils.isEmpty((String)sourceValue)) {
            return sourceValue;
        }
        String appScan_rule0 = "'+||+''+||+'";
        String appScan_rule1 = "'+||+'+||+'";
        String appScan_rule2 = "' || '' || '";
        String appScan_rule3 = "'||''||'";
        String appScan_rule4 = "' || ' || '";
        String appScan_rule5 = "'||'||'";
        String appScan_rule6 = "' + '' +";
        sourceValue = this.doAppScanRuleHandler(sourceValue, appScan_rule0);
        sourceValue = this.doAppScanRuleHandler(sourceValue, appScan_rule1);
        sourceValue = this.doAppScanRuleHandler(sourceValue, appScan_rule2);
        sourceValue = this.doAppScanRuleHandler(sourceValue, appScan_rule3);
        sourceValue = this.doAppScanRuleHandler(sourceValue, appScan_rule4);
        sourceValue = this.doAppScanRuleHandler(sourceValue, appScan_rule5);
        sourceValue = this.doAppScanRuleHandler(sourceValue, appScan_rule6);
        return sourceValue;
    }

    private String doAppScanRuleHandler(String sourceValue, String rule) {
        if (sourceValue.indexOf(rule) > -1) {
            sourceValue = sourceValue.replace(rule, "");
            logger.warn(MessageFormat.format(" request sourceValue is {0}, intercept str is {1}", SHRCheck.vaildLog((String)sourceValue), SHRCheck.vaildLog((String)rule)));
        }
        return sourceValue;
    }

    private boolean isIncluedKeyWordListByEqualsIgnoreCase(String value) {
        String[] keyWordArr = this.getSqlKeyword();
        if (null == keyWordArr || StringUtils.isEmpty((String)value)) {
            return false;
        }
        for (String keyWord : keyWordArr) {
            if (!value.equalsIgnoreCase(keyWord)) continue;
            return true;
        }
        return false;
    }

    private boolean isIncluedarametersListByEqualsIgnoreCase(String value) {
        String[] keyWordArr = this.getSqlinjectfilterparams();
        if (null == keyWordArr || StringUtils.isEmpty((String)value)) {
            return false;
        }
        for (String keyWord : keyWordArr) {
            if (!value.equalsIgnoreCase(keyWord)) continue;
            return true;
        }
        return false;
    }

    private boolean isEvenNumber(String text, char targetChar) {
        int count = 0;
        for (char c : text.toCharArray()) {
            if (c != targetChar) continue;
            ++count;
        }
        return count % 2 == 0;
    }
}

