/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.listener;

import com.grapecity.documents.excel.Workbook;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.web.util.WebUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.springframework.util.ReflectionUtils;

public class SHRAppListener
implements ServletContextListener {
    private static Logger logger = Logger.getLogger(SHRAppListener.class);

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        String productionMode = servletContext.getInitParameter("productionMode");
        servletContext.setAttribute("productionMode", (Object)productionMode);
        Date d = new Date();
        servletContext.setAttribute("configPageVersion", (Object)d.getTime());
        this.initTempPath();
        this.initDomainFilterService();
        this.initSHRBizDataChangeMsgScaner();
        this.importSetActiveTaskToDown();
        this.initGcExcel();
    }

    private void initDomainFilterService() {
        String _classFullName = "com.kingdee.shr.base.syssetting.app.filter.DomainFilterAnnotationLoader";
        try {
            Class clazz = MsfClassLoaderFactory.forName((String)_classFullName);
            Method init = clazz.getDeclaredMethod("init", new Class[0]);
            ReflectionUtils.invokeMethod((Method)init, clazz.newInstance());
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error((Object)"[ SHRAppListener initDomainFilterService error ]");
        }
    }

    private void initSHRBizDataChangeMsgScaner() {
        try {
            Class<?> clazz = Class.forName("com.kingdee.shr.base.bizmanage.listener.SHRBizManageListener");
            Method init = clazz.getDeclaredMethod("init", new Class[0]);
            ReflectionUtils.invokeMethod((Method)init, clazz.newInstance());
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error((Object)"[ SHRAppListener initSHRBizDataChangeMsgScaner error ]");
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    private void initTempPath() {
        String tmpPath = WebUtil.getShrTmpPath();
        try {
            File dir = new File(tmpPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        catch (Exception e) {
            logger.error((Object)("SHRAppListener initTempPath error " + e.getMessage()));
        }
    }

    private void reportInit() {
        try {
            int i;
            Class clazz = MsfClassLoaderFactory.forName((String)"com.kingdee.shr.report.web.util.ReportInitUtil");
            Method[] methods = clazz.getMethods();
            for (i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("reportInit")) continue;
                ReflectionUtils.invokeMethod((Method)methods[i], clazz.newInstance());
                break;
            }
            if (i == methods.length) {
                throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "method_notfound"), "com.kingdee.shr.report.web.util.ReportInitUtil", "reportInit"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Error e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void importSetActiveTaskToDown() {
        try {
            Class clazz = MsfClassLoaderFactory.forName((String)"com.kingdee.shr.base.syssetting.app.io.fileImport.ImportTaskManager");
            Method method = ReflectionUtils.findMethod((Class)clazz, (String)"setActiveTaskToDown");
            if (method == null) {
                throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "method_notfound"), "com.kingdee.shr.base.syssetting.app.io.fileImport.ImportTaskManager", "setActiveTaskToDown"));
            }
            method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Error e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void initGcExcel() {
        Workbook.SetLicenseKey((String)"kingdee,674656255616642#A02NJUjM6UjN4cjNiojIklkI1pjIEJCLi4TPRlmWtBlclpUbMp6TlJlTrBHaUJmWVFmQ8UVWVNTaNlVby4EawMFWVN5UBB5UHpGcW9WcohlRoVDOkN4YMhHOvQGWJhDS0J6UwkXRipEMrVUZ5FVU4xmI0IyUiwCN8UjM7UDNwETM0IicfJye35XX3JiUTRjTiojIDJCLiMjdgEmdhpEIsV6Y8VEIy3mZgQnbl5Wdj3GRgM4RiojIOJyebpjIkJHUiwiI6MTN5YDMgkTMzADMyAjMiojI4J7QiwiI8+Y9sWY9QmZ0Jyp9Jy113uZ9tiL9Iy116uL9v6L066J0ReY0iojIh94QiwiIyQ3NJE");
        Workbook.FontsFolderPath = SHRSyssettingUtil.getShrPropertiesPath();
        try {
            Properties p = SHRSyssettingUtil.getPropertiesFileByPath((String)SHRSyssettingUtil.getShrPropertiesPathByFileName((String)"GcExcelConfig.properties"));
            if (null != p) {
                if (null != p.get("Licensekey")) {
                    Workbook.SetLicenseKey((String)((String)p.get("Licensekey")));
                }
                if (null != p.get("FontsFolderPath")) {
                    Workbook.FontsFolderPath = (String)p.get("FontsFolderPath");
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

