/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator;

import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.shr.base.syssetting.web.templatetranslator.IElementTranslator;
import com.kingdee.shr.base.syssetting.web.templatetranslator.IElementTranslatorStore;
import com.kingdee.shr.base.syssetting.web.templatetranslator.TemplateTranslateException;
import com.kingdee.util.StringUtils;
import java.util.Map;
import org.jdom2.Element;

public abstract class AbstractElementTranslatorStore
implements IElementTranslatorStore {
    @Override
    public IElementTranslator getElementTranslator(Context ctx, String elementName) throws TemplateTranslateException {
        Map<String, String> map = this.getTranslatorMap();
        String className = map.get(elementName);
        if (StringUtils.isEmpty((String)className)) {
            className = map.get("default");
        }
        if (StringUtils.isEmpty((String)className)) {
            return null;
        }
        IElementTranslator translator = null;
        try {
            Class clazz = MsfClassLoaderFactory.forName((String)className);
            translator = (IElementTranslator)clazz.newInstance();
            if (null != translator) {
                translator.setContext(ctx);
            }
            return translator;
        }
        catch (ClassNotFoundException e) {
            throw new TemplateTranslateException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new TemplateTranslateException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new TemplateTranslateException(e.getMessage(), e);
        }
    }

    @Override
    public IElementTranslator getElementTranslator(Element element, Context ctx) throws TemplateTranslateException {
        IElementTranslator translator = this.getElementTranslator(ctx, element.getName());
        translator.setElement(element);
        return translator;
    }
}

