/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.templatetranslator.AbstractElementTranslator;
import com.kingdee.shr.base.syssetting.web.templatetranslator.IElementTranslatorStore;
import com.kingdee.shr.base.syssetting.web.templatetranslator.TemplateTranslateException;
import com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.TranslatorUtil;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class EditGridColumnTranslator
extends AbstractElementTranslator {
    @Override
    public String translate(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        StringBuilder sb = new StringBuilder();
        String fieldName = element.getAttributeValue("name");
        Element parent = element.getParentElement();
        if (parent.getAttributeValue("name") != null) {
            fieldName = parent.getAttributeValue("name") + "." + fieldName;
        }
        FieldInfo fieldInfo = viewInfo.getField(fieldName);
        sb.append("<@e.gridColumn ");
        sb.append(TranslatorUtil.optionToString(this.getColumnOptions(element, fieldInfo, viewInfo)));
        sb.append(">\n");
        String editor = this.createEditor(element, fieldInfo, viewInfo, store);
        if (editor != null) {
            sb.append(editor);
        }
        sb.append(this.translateChildren(element, viewInfo, store));
        sb.append("</@e.gridColumn>");
        return sb.toString();
    }

    private Map<String, Object> getColumnOptions(Element element, FieldInfo fieldInfo, UIViewInfo viewInfo) throws TemplateTranslateException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String fieldName = element.getAttributeValue("name");
        options.put("name", fieldName);
        String sorttype = element.getAttributeValue("sorttype");
        if (fieldInfo != null && StringUtils.isEmpty((String)sorttype) && null != fieldInfo.getDataType()) {
            sorttype = fieldInfo.getDataType().getName().toLowerCase();
        }
        if (StringUtils.isEmpty((String)sorttype)) {
            sorttype = "";
        }
        options.put("sorttype", sorttype);
        String label = element.getAttributeValue("label");
        if (StringUtils.isEmpty((String)label)) {
            label = fieldInfo != null ? fieldInfo.getAlias() : fieldName;
        }
        options.put("label", label);
        Element parent = element.getParentElement();
        if (parent.getAttributeValue("name") != null) {
            String entryName = parent.getAttributeValue("name");
            options.put("entryName", entryName);
        }
        TranslatorUtil.copyAttribute(element, options, "width");
        TranslatorUtil.copyAttribute(element, options, "editable");
        TranslatorUtil.copyAttribute(element, options, "align");
        TranslatorUtil.copyAttribute(element, options, "thalign");
        TranslatorUtil.copyAttribute(element, options, "hidden");
        TranslatorUtil.copyAttribute(element, options, "key");
        TranslatorUtil.copyAttribute(element, options, "customformatter");
        TranslatorUtil.copyAttribute(element, options, "formatter");
        TranslatorUtil.copyAttribute(element, options, "formatoptions");
        TranslatorUtil.copyAttribute(element, options, "rowspan");
        TranslatorUtil.copyAttribute(element, options, "fieldspan");
        TranslatorUtil.copyAttribute(element, options, "frozen");
        TranslatorUtil.copyAttribute(element, options, "ctrl");
        TranslatorUtil.copyAttribute(element, options, "uipk");
        TranslatorUtil.copyAttribute(element, options, "sortable");
        TranslatorUtil.copyAttribute(element, options, "required");
        this.setSensitiveRule(options, fieldInfo, element, viewInfo);
        return options;
    }

    private String createEditor(Element element, FieldInfo fieldInfo, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        String result = null;
        String fieldCtrl = element.getAttributeValue("ctrl");
        if (!StringUtils.isEmpty((String)fieldCtrl)) {
            if (DataType.TIME.getName().equalsIgnoreCase(fieldCtrl)) {
                result = this.createTimeField(element, viewInfo, store, DataType.TIME);
            } else if (DataType.DATE.getName().equalsIgnoreCase(fieldCtrl)) {
                result = this.createDateField(element, viewInfo, store, DataType.DATE);
            } else if (DataType.TIMESTAMP.getName().equalsIgnoreCase(fieldCtrl)) {
                result = this.createDateField(element, viewInfo, store, DataType.TIMESTAMP);
            } else if ("textarea".equalsIgnoreCase(fieldCtrl)) {
                result = this.createTextarea(element, viewInfo, store);
            }
            return result;
        }
        DataType dataType = this.getDataType(element, fieldInfo);
        result = DataType.STRING.equals((Object)dataType) ? this.createStringfield(element, viewInfo, store) : (DataType.DATE.equals((Object)dataType) || DataType.TIME.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType) ? this.createDateField(element, viewInfo, store, dataType) : (DataType.INTEGER.equals((Object)dataType) || DataType.LONG.equals((Object)dataType) || DataType.SHORT.equals((Object)dataType) ? this.createIntegerField(element, viewInfo, store) : (DataType.DOUBLE.equals((Object)dataType) || DataType.DECIMAL.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType) ? this.createDecimalField(element, viewInfo, store) : (DataType.ENUM.equals((Object)dataType) ? this.createSelectField(element, (OwnPropertyInfo)fieldInfo.getProperty(), viewInfo, store) : (DataType.BOOLEAN.equals((Object)dataType) ? this.createCheckBox(element, viewInfo, store) : (DataType.OBJECTVALUE.equals((Object)dataType) ? this.createPromptBox(element, (PropertyInfo)((LinkPropertyInfo)fieldInfo.getProperty()), viewInfo, store) : this.createStringfield(element, viewInfo, store)))))));
        return result;
    }

    private DataType getDataType(Element element, FieldInfo fieldInfo) {
        DataType dataType = null;
        String fieldCtrl = element.getAttributeValue("ctrl");
        if (!StringUtils.isEmpty((String)fieldCtrl)) {
            String newDataType = fieldCtrl.substring(0, 1).toUpperCase() + fieldCtrl.substring(1);
            dataType = DataType.getEnum((String)newDataType);
        } else if (fieldInfo != null) {
            dataType = fieldInfo.getDataType();
        }
        return dataType;
    }

    private String createStringfield(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        TranslatorUtil.copyAttribute(element, options, "maxlength");
        this.setStringIsTrimAll(element, options);
        boolean b = this.isMultiLan(element, viewInfo);
        if (b) {
            return this.convertFieldString("multiLangBox", options, element, viewInfo, store);
        }
        return this.convertFieldString("text", options, element, viewInfo, store);
    }

    @Override
    protected String getFieldName(Element element, UIViewInfo viewInfo) {
        if ("editGrid".equals(element.getParentElement().getName()) && !StringUtils.isEmpty((String)element.getParentElement().getAttributeValue("name"))) {
            return MessageFormat.format("{0}.{1}", element.getParentElement().getAttributeValue("name"), element.getAttributeValue("name"));
        }
        return super.getFieldName(element, viewInfo);
    }

    private String createTextarea(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (element.getAttributeValue("maxlength") != null) {
            options.put("maxlength", element.getAttributeValue("maxlength").toString());
        }
        this.setStringIsTrimAll(element, options);
        if (this.isMultiLan(element, viewInfo)) {
            return this.convertFieldString("multiLangArea", options, element, viewInfo, store);
        }
        return this.convertFieldString("textarea", options, element, viewInfo, store);
    }

    private String createIntegerField(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        TranslatorUtil.copyAttribute(element, options, "formatType");
        this.setNumberFieldOptions(element, options, viewInfo);
        options.put("decimalPrecision", 0);
        return this.convertFieldString("numberField", options, element, viewInfo, store);
    }

    private String createDecimalField(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.setNumberFieldOptions(element, options, viewInfo);
        return this.convertFieldString("numberField", options, element, viewInfo, store);
    }

    private String createCheckBox(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        return this.convertFieldString("checkbox", null, element, viewInfo, store);
    }

    private String createDateField(Element element, UIViewInfo viewInfo, IElementTranslatorStore store, DataType dataType) throws TemplateTranslateException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.setDateTimeOrTimeOptions(element, options, viewInfo, dataType);
        return this.convertFieldString("dateTimePicker", options, element, viewInfo, store);
    }

    private String createTimeField(Element element, UIViewInfo viewInfo, IElementTranslatorStore store, DataType dataType) throws TemplateTranslateException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String minuteStep = element.getAttributeValue("minuteStep");
        Integer default_minuteStep = 15;
        if (!StringUtils.isEmpty((String)minuteStep)) {
            options.put("minuteStep", minuteStep);
        } else {
            options.put("minuteStep", default_minuteStep);
        }
        this.setDateTimeOrTimeOptions(element, options, viewInfo, dataType);
        return this.convertFieldString("dateTimePicker", options, element, viewInfo, store);
    }

    private String createSelectField(Element element, OwnPropertyInfo ownPropertyInfo, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String enumSource = element.getAttributeValue("enumSource");
        if (StringUtils.isEmpty((String)enumSource)) {
            enumSource = null != ownPropertyInfo && DataType.ENUM.equals((Object)ownPropertyInfo.getDataType()) && !StringUtils.isEmpty((String)ownPropertyInfo.getMetaDataRef()) ? ownPropertyInfo.getMetaDataRef() : "";
        }
        options.put("enumSource", enumSource);
        if (element.getAttribute("enumOptions") != null) {
            String enumOptions = element.getAttributeValue("enumOptions");
            enumOptions = enumOptions.replace("'", "\\\"");
            options.put("enumOptions", enumOptions);
        }
        TranslatorUtil.copyAttribute(element, options, "filter");
        return this.convertFieldString("select", options, element, viewInfo, store);
    }

    private String createPromptBox(Element element, PropertyInfo propertyInfo, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String uipk = element.getAttributeValue("uipk");
        if (StringUtils.isEmpty((String)uipk)) {
            String entityName = MetaDataUtil.getEntityNameByPropertyInfo((Context)this.getContext(), (String)viewInfo.getEntityName(), (PropertyInfo)propertyInfo);
            uipk = this.getDefaultF7UIPK(entityName);
        }
        options.put("uipk", uipk);
        String fieldName = element.getAttributeValue("name");
        String entityName = viewInfo.getEntityName();
        String isHROrg = element.getAttributeValue("isHROrg");
        if (!StringUtils.isEmpty((String)isHROrg)) {
            if ("true".equalsIgnoreCase(isHROrg)) {
                options.put("isHROrg", "true");
            } else if ("false".equalsIgnoreCase(isHROrg)) {
                options.put("isHROrg", "false");
            }
        } else {
            options.put("isHROrg", "${isDefaultHROrgFiled('" + entityName + "','" + fieldName + "')}");
        }
        TranslatorUtil.copyAttribute(element, options, "query");
        TranslatorUtil.copyAttribute(element, options, "domain");
        TranslatorUtil.copyAttribute(element, options, "filter");
        TranslatorUtil.copyAttribute(element, options, "searchFields");
        TranslatorUtil.copyAttribute(element, options, "filterConfig");
        TranslatorUtil.copyAttribute(element, options, "isHRBaseItem");
        TranslatorUtil.copyAttribute(element, options, "bizFilterFields");
        TranslatorUtil.copyAttribute(element, options, "f7ReKeyValue");
        TranslatorUtil.copyAttribute(element, options, "afterOnchangeClearFields");
        TranslatorUtil.copyAttribute(element, options, "displayFormat");
        TranslatorUtil.copyAttribute(element, options, "multiselect");
        TranslatorUtil.copyAttribute(element, options, "isTree");
        TranslatorUtil.copyAttribute(element, options, "treeUrl");
        TranslatorUtil.copyAttribute(element, options, "isContainLowerOrg");
        TranslatorUtil.copyAttribute(element, options, "searchLikePattern");
        TranslatorUtil.copyAttribute(element, options, "isEnableExpFilter");
        TranslatorUtil.copyAttribute(element, options, "pgSizes");
        TranslatorUtil.copyAttribute(element, options, "dataShowMode");
        return this.convertFieldString("promptBox", options, element, viewInfo, store);
    }

    private String getDefaultF7UIPK(String entityName) throws TemplateTranslateException {
        String uipk = null;
        try {
            if (StringUtils.isEmpty(uipk)) {
                uipk = entityName + ".F7";
                UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(this.getContext(), uipk);
                if (null == uiViewInfo) {
                    uipk = null;
                }
            }
        }
        catch (SHRWebException e) {
            uipk = null;
        }
        if (StringUtils.isEmpty(uipk)) {
            uipk = entityName + ".list";
        }
        return uipk;
    }

    private String convertFieldString(String tag, Map<String, Object> options, Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        this.handleValidator(element);
        String content = this.convertFieldString("e", tag, options, this.translateChildren(element, viewInfo, store));
        element.removeContent();
        return content;
    }

    private void handleValidator(Element element) {
        String required = element.getAttributeValue("required");
        if ("true".equalsIgnoreCase(required)) {
            Element validator = element.getChild("validator");
            if (validator == null) {
                validator = new Element("validator");
                element.addContent((Content)validator);
            }
            validator.setAttribute("rules", "required:true");
        }
    }
}

