/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.function;

import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.function.AbstractFreemarkerFunction;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModelException;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class ComponentIsVisible
extends AbstractFreemarkerFunction {
    public Object exec(List args) throws TemplateModelException {
        boolean flag = this.isOperateStateVisible(args) && this.isModelStateVisible(args) && this.isModelVersionVisible(args) && this.isHistoryVersionVisible(args);
        return flag ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
    }

    private boolean isOperateStateVisible(List args) {
        if (args.size() < 2) {
            return true;
        }
        String operateState_visible = this.getValueString(args.get(0));
        if (!StringUtils.isEmpty((String)operateState_visible)) {
            Object args1 = args.get(1);
            String currentOperateState = this.getValueString(args1);
            try {
                if (StringUtils.isEmpty((String)currentOperateState)) {
                    ServletRequest servletRequest = SHRContext.getInstance().getRequest();
                    HttpServletRequest request = (HttpServletRequest)servletRequest;
                    String operate = request.getParameter("operateState");
                    if (!(args1 instanceof SimpleScalar) && !(args1 instanceof StringModel)) {
                        currentOperateState = operate;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.isContains(operateState_visible, currentOperateState);
        }
        return true;
    }

    private boolean isModelStateVisible(List args) {
        if (args.size() < 4) {
            return true;
        }
        String range = this.getValueString(args.get(2));
        if (!StringUtils.isEmpty((String)range)) {
            CoreBaseInfo info = this.getValueCoreBaseInfo(args.get(3));
            if (info == null || info.get("state") == null) {
                return false;
            }
            String stateValue = null;
            if (info.get("state") instanceof IntEnum) {
                IntEnum state = (IntEnum)info.get("state");
                stateValue = String.valueOf(state.getValue());
            } else if (info.get("state") instanceof StringEnum) {
                StringEnum state = (StringEnum)info.get("state");
                stateValue = state.getValue();
            } else {
                stateValue = info.get("state").toString();
            }
            return this.isContains(range, stateValue);
        }
        return true;
    }

    private boolean isModelVersionVisible(List args) {
        if (args.size() < 5) {
            return true;
        }
        String range = this.getValueString(args.get(4));
        if (!StringUtils.isEmpty((String)range)) {
            CoreBaseInfo info = this.getValueCoreBaseInfo(args.get(3));
            String value = this.getModelVersion(info);
            return this.isContains(range, value);
        }
        return true;
    }

    private boolean isHistoryVersionVisible(List args) {
        if (args.size() < 6) {
            return true;
        }
        String range = this.getValueString(args.get(5));
        if (!StringUtils.isEmpty((String)range)) {
            CoreBaseInfo info = this.getValueCoreBaseInfo(args.get(3));
            String value = this.getHistoryState(info);
            return this.isContains(range, value);
        }
        return true;
    }

    private boolean isContains(String state_visible, String stateValue) {
        if (StringUtils.isEmpty((String)state_visible) || StringUtils.isEmpty((String)stateValue)) {
            return false;
        }
        String[] operateStates = state_visible.split(",");
        boolean visible = false;
        for (String operateState : operateStates) {
            if (!stateValue.equalsIgnoreCase(operateState)) continue;
            visible = true;
            break;
        }
        return visible;
    }

    private String getModelVersion(CoreBaseInfo info) {
        if (info == null) {
            return null;
        }
        String version = null;
        version = info.get(HistoryConstant.historyRelateID) != null ? "history" : "current";
        return version;
    }

    private String getHistoryState(CoreBaseInfo info) {
        if (info == null) {
            return null;
        }
        String state = null;
        Date leffdt = (Date)info.get(HistoryConstant.LEFFDT);
        state = HistoryUtil.getMaxDate().equals(leffdt) ? "newest" : "older";
        return state;
    }
}

