/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.function;

import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.function.AbstractFreemarkerFunction;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import freemarker.template.TemplateModelException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class DateTimeFormater
extends AbstractFreemarkerFunction {
    private static Logger logger = Logger.getLogger(DateTimeFormater.class);

    public Object exec(List args) throws TemplateModelException {
        Date date = null;
        int size = args.size();
        if (size > 0) {
            Object value = args.get(0);
            if (value == null) {
                return "";
            }
            date = this.getValueDate(value);
            if (date == null) {
                try {
                    value = this.getValueString(value);
                    if (value != null && !StringUtils.isEmpty((String)value.toString())) {
                        date = DateTimeUtils.parseDate((String)value.toString());
                    }
                }
                catch (ParseException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (date == null) {
            return "";
        }
        String dateType = this.getValueString(args.get(1));
        String format = "yyyy-MM-dd HH:mm:ss";
        if (DataType.TIME.getName().equals(dateType)) {
            format = "yyyy-MM-dd HH:mm:ss";
        } else if (DataType.TIMESTAMP.getName().equals(dateType)) {
            format = "yyyy-MM-dd HH:mm:ss";
        } else if (DataType.DATE.getName().equals(dateType)) {
            format = "yyyy-MM-dd";
        }
        return DateTimeUtils.format((Date)date, (String)format);
    }
}

