/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.util;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.URLUtil;
import com.kingdee.util.StringUtils;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.log4j.Logger;

public final class SsoProxyClient {
    private static Logger logger = Logger.getLogger(SsoProxyClient.class);

    public static String assembleServerUrlFromRequest(HttpServletRequest request) {
        String port = String.valueOf(request.getServerPort());
        String serverUrl = MessageFormat.format("{0}://{1}:{2}{3}", request.getScheme(), request.getServerName(), port, request.getContextPath());
        return serverUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse sendRedirectForSuccessfullSsoLogin(HttpServletRequest request, HttpServletResponse response, String targetUrl) {
        CloseableHttpResponse rep = null;
        CloseableHttpClient httpClient = null;
        try {
            String serverUrl = SsoProxyClient.assembleServerUrlFromRequest(request);
            targetUrl = serverUrl.concat("/").concat(targetUrl);
            HttpGet httpGet = new HttpGet(targetUrl);
            RequestConfig methodRequestConfig = RequestConfig.custom().setCircularRedirectsAllowed(true).setCircularRedirectsAllowed(true).build();
            httpGet.setConfig(methodRequestConfig);
            httpGet.addHeader("Referer", serverUrl);
            BasicCookieStore cookieStore = new BasicCookieStore();
            RequestConfig clientRequestConfig = RequestConfig.custom().setRedirectsEnabled(false).setCookieSpec("standard").build();
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            httpClient = HttpClients.custom().setDefaultRequestConfig(clientRequestConfig).setDefaultCookieStore((CookieStore)cookieStore).setSSLContext(sslContext).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
            rep = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = rep.getStatusLine().getStatusCode();
            if (200 == statusCode) {
                List cookies = cookieStore.getCookies();
                javax.servlet.http.Cookie javaxHttpCookie = null;
                for (Cookie cookie : cookies) {
                    javaxHttpCookie = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
                    javaxHttpCookie.setDomain(cookie.getDomain());
                    javaxHttpCookie.setPath("/");
                    javaxHttpCookie.setComment(cookie.getComment());
                    javaxHttpCookie.setVersion(cookie.getVersion());
                    javaxHttpCookie.setSecure(cookie.isSecure());
                    if (null != cookie.getExpiryDate()) {
                        int maxAgeSecond = (int)((cookie.getExpiryDate().getTime() - System.currentTimeMillis()) / 1000L);
                        javaxHttpCookie.setMaxAge(maxAgeSecond);
                    }
                    response.addCookie(javaxHttpCookie);
                }
                String redirectToValue = URLUtil.getQueryParamValue((String)targetUrl, (String)"redirectTo");
                if (StringUtils.isEmpty((String)redirectToValue)) {
                    redirectToValue = "/main.do";
                }
                String redirectUrl = MessageFormat.format("{0}{1}", request.getContextPath(), URLDecoder.decode(redirectToValue, "utf-8"));
                logger.debug((Object)SHRCheck.vaildLog((String)(" sendRedirectForSuccessfullSsoLogin inner redirectUrl is : " + redirectUrl)));
                response.sendRedirect(SHRCheck.checkUrlParamsForSendRedirect((String)redirectUrl));
            } else {
                String message = " statusCode code is " + statusCode;
                logger.error((Object)SHRCheck.vaildLog((String)message));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return rep;
    }
}

