/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.util;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.util.DateTimeUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebUtil {
    public static final String SHR_WEB_WAR_NAME = "shr_web.war";
    public static final String EAS_EAR_ROOT = SHRSyssettingUtil.getEasWebWarPath();
    public static final String SHR_WEB_TMP_PATH = SHRSyssettingUtil.getShrWebWarTmpPath();
    public static final String SHR_NEWZIPFLODER = SHRSyssettingUtil.getShrWebWarNewZipFolderPath();

    public static Map getParameterMap(HttpServletRequest request) {
        Map properties = request.getParameterMap();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Iterator entries = properties.entrySet().iterator();
        String name = "";
        String value = "";
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            name = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }

    public static boolean clientIsMSIE(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        return userAgent.indexOf("MSIE") != -1 || userAgent.indexOf("Trident") != -1;
    }

    public static boolean clientISFF(HttpServletRequest request) {
        String agent = request.getHeader("USER-AGENT").toLowerCase();
        return agent.indexOf("firefox") != -1;
    }

    public static String getRequestParamOrAttribute(HttpServletRequest request, String key) {
        Object value = request.getAttribute(key);
        if (value == null) {
            value = request.getParameter(key);
        }
        return value != null ? value.toString() : null;
    }

    public static String getEasEarPath() {
        return EAS_EAR_ROOT;
    }

    public static String getShrTmpPath() {
        return SHR_WEB_TMP_PATH;
    }

    public static String getShrWebWarName() {
        return SHR_WEB_WAR_NAME;
    }

    public static String getShrNewZipFolerPath() {
        return SHR_NEWZIPFLODER;
    }

    public static String getExcelTempDir() {
        File dir = new File(SHRCheck.checkFilePath((String)System.getProperty("java.io.tmpdir")), "poifiles");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir.getAbsolutePath();
    }

    public static void setFileResponseHeader(HttpServletRequest request, HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        fileName = WebUtil.convertFileNameForDownload(request, fileName);
        response.setHeader("Content-Disposition", SHRCheck.checkFileNameForSetResponseHeader((String)String.format("attachment;filename*=utf-8''%s", fileName)));
        response.setContentType("application/octet-stream; charset=utf-8");
    }

    public static String convertFileNameForDownload(HttpServletRequest request, String fileName) throws UnsupportedEncodingException {
        if (fileName == null || fileName.length() <= 0) {
            return fileName;
        }
        String f0 = URLEncoder.encode(fileName, "UTF-8");
        if (WebUtil.clientISFF(request)) {
            f0 = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
        }
        f0 = f0.replaceAll("\\+", "%20").replaceAll("%28", "\\(").replaceAll("%29", "\\)").replaceAll("%3B", ";");
        f0 = f0.replaceAll("%40", "@").replaceAll("%23", "\\#").replaceAll("%26", "\\&").replaceAll("%2C", "\\,");
        return f0;
    }

    public static String assembleDownloadUrl(String realFileName, String fileName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", "tmp");
        params.put("file", realFileName);
        params.put("filename", fileName);
        return DynamicUtil.assembleUrl("/downloadfile.do", params).replaceAll("\\+", "%20");
    }

    public static String generateExcelXlsxFileNameWithTimestamp(String fileName) {
        SecureRandom rd = new SecureRandom();
        int rdValue = rd.nextInt(1000);
        String random = "";
        random = rdValue >= 100 ? random + rdValue : (rdValue >= 10 && rdValue < 100 ? random + "0" + rdValue : random + "00" + rdValue);
        return MessageFormat.format("{0}_{1}{2}.xlsx", fileName, DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"), random);
    }

    public static String generateFileNameWithTimestamp(String fileName, String fileExt) {
        SecureRandom rd = new SecureRandom();
        int rdValue = rd.nextInt(1000);
        String random = "";
        random = rdValue >= 100 ? random + rdValue : (rdValue >= 10 && rdValue < 100 ? random + "0" + rdValue : random + "00" + rdValue);
        return MessageFormat.format("{0}_{1}{2}.{3}", fileName, DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"), random, fileExt);
    }
}

