/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.openid;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.eas.base.weibo.shr.app.PersonRegisterInfo;
import com.kingdee.eas.cp.eip.sso.IEasAuthHandler;
import com.kingdee.eas.cp.eip.sso.shr.ltap.ShrLtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.wechart.OTPTokenFactory;
import com.kingdee.eas.cp.eip.sso.wechart.WeChartConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;

public class OpenidAuthHandler
implements IEasAuthHandler {
    public String getEasUserNumber(Context ctx, String externalUserNumber) {
        return ctx.getUserName();
    }

    public boolean isVerifyEasUserPwd() {
        return false;
    }

    public boolean authenticate(UserContextCallback userCtxCallback, String userNumber, String token) throws BOSLoginException {
        Context ctx = userCtxCallback.getUserContext();
        ShrLtpaTokenManager.loadDefaultConfig();
        if (token == null || StringUtils.isEmpty((String)token)) {
            return false;
        }
        boolean result = false;
        if (ShrLtpaTokenManager.isValid(token, (String)ctx.get((Object)"userAuthPattern"))) {
            if (!ShrLtpaTokenManager.compare(token, userNumber)) {
                throw new BOSLoginException("token expired");
            }
        } else {
            throw new BOSLoginException("token invalid");
        }
        try {
            if (!OTPTokenFactory.getInstance(ctx).checkIsOneTime(ctx, token)) {
                throw new BOSLoginException("token already used ");
            }
            OTPTokenFactory.getInstance(ctx).registerToken(ctx, userNumber, token);
        }
        catch (BOSException e) {
            throw new BOSLoginException("token already used ");
        }
        PersonRegisterInfo personInfo = null;
        try {
            personInfo = this.getUserByEMail(ctx, userNumber);
        }
        catch (Exception e) {
            throw new BOSLoginException("find user faild ");
        }
        if (personInfo == null) {
            throw new BOSLoginException("no user match ");
        }
        ctx.put((Object)WeChartConstant.WeChartUser, (Object)userNumber);
        ctx.setUserName(personInfo.getUserNumber());
        ctx.put((Object)WeChartConstant.WeChartAccessToken, (Object)token);
        return true;
    }

    public PersonRegisterInfo getUserByEMail(Context ctx, String email) throws BOSException, SQLException {
        String sql = "select a.fnumber fnumber,a.fid fid from t_pm_user a,t_pm_easxtusermap c  where  c.fpersonid=a.fpersonid  and c.Fxtid = ? and a.fisdelete=0 ";
        Object[] params = new Object[]{email};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        PersonRegisterInfo info = null;
        if (rs.next()) {
            info = new PersonRegisterInfo();
            info.setUserNumber(rs.getString("fnumber"));
            info.setUserId(rs.getString("fid"));
        }
        return info;
    }
}

