/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.otp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.eas.cp.eip.sso.IEasAuthHandler;
import com.kingdee.eas.cp.eip.sso.otp.MessageWrapper;
import com.kingdee.eas.cp.eip.sso.shr.ltap.ShrLtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.wechart.OTPTokenFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class OTPAuthHandler
implements IEasAuthHandler {
    private static Logger logger = Logger.getLogger(OTPAuthHandler.class);

    public String getEasUserNumber(Context ctx, String externalUserNumber) {
        boolean res = this.checkUserExist(ctx, externalUserNumber);
        if (res) {
            return externalUserNumber;
        }
        return null;
    }

    private boolean checkUserExist(Context ctx, String externalUserNumber) {
        String existSql = "select 1 from T_PM_USER where FNumber = ? and FisDelete = 0 and FIsLocked = 0 and FForbidden = 0";
        Object[] param = new Object[]{externalUserNumber};
        try {
            logger.error((Object)("query userInfo from t_pm_user, number=" + externalUserNumber));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)existSql, (Object[])param);
            return rowSet.next();
        }
        catch (Exception e) {
            logger.error((Object)"query whether username exist in table t_pm_user or not failed!", (Throwable)e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean isVerifyEasUserPwd() {
        return false;
    }

    public boolean authenticate(UserContextCallback userCtxCallback, String userNumber, String token) throws BOSLoginException {
        Context ctx = userCtxCallback.getUserContext();
        ShrLtpaTokenManager.loadDefaultConfig();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("authenticate--token: " + token));
        }
        if (StringUtils.isEmpty((String)token)) {
            return false;
        }
        MessageWrapper message = null;
        if (ShrLtpaTokenManager.isValidSecret("OTP")) {
            message = new MessageWrapper(1, ctx);
            throw new BOSLoginException("sso access error:" + JSONUtils.convertObjectToJson((Context)ctx, (Object)message));
        }
        if (ShrLtpaTokenManager.isValid(token, "OTP")) {
            if (!ShrLtpaTokenManager.compare(token, userNumber)) {
                message = new MessageWrapper(4, ctx);
                throw new BOSLoginException("sso access error:" + JSONUtils.convertObjectToJson((Context)ctx, (Object)message));
            }
        } else {
            message = new MessageWrapper(3, ctx);
            throw new BOSLoginException("sso access error:" + JSONUtils.convertObjectToJson((Context)ctx, (Object)message));
        }
        try {
            if (!OTPTokenFactory.getInstance(ctx).checkIsOneTime(ctx, token)) {
                message = new MessageWrapper(2, ctx);
                throw new BOSLoginException("sso access error:" + JSONUtils.convertObjectToJson((Context)ctx, (Object)message));
            }
            OTPTokenFactory.getInstance(ctx).registerToken(ctx, userNumber, token);
        }
        catch (BOSException e) {
            message = new MessageWrapper(2, ctx);
            throw new BOSLoginException("sso access error:" + JSONUtils.convertObjectToJson((Context)ctx, (Object)message));
        }
        return true;
    }
}

