/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.otp;

import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.cp.eip.sso.ltpa.ConfigurationError;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

public class OTPManager {
    private static Properties properties = null;
    private static boolean isConfigLoaded = false;

    private static boolean isConfigLoaded() {
        return isConfigLoaded;
    }

    public static void loadConfig(String configFile) {
        if (!OTPManager.isConfigLoaded()) {
            properties = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(SHRCheck.checkFilePath((String)configFile));
                properties.load(is);
                isConfigLoaded = true;
            }
            catch (IOException ioe) {
                throw new ConfigurationError("LtpaToken.properties not found. file = " + configFile);
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getDefaultLtpaConfig() {
        return System.getProperty("EAS_INSTANCE_CONFIG_PATH").trim() + "/portalConfig/autoLoginConfig.properties";
    }

    public static String getAutoLoginDataCenter() {
        OTPManager.loadConfig(OTPManager.getDefaultLtpaConfig());
        return properties.getProperty("datacenter");
    }

    public static DCInfo getDCInfo(String dataCenter) {
        DCInfo dcInfo = null;
        try {
            ArrayList dcList = DCManager.getInstance().getDCList();
            for (int i = 0; i < dcList.size() && !(dcInfo = (DCInfo)dcList.get(i)).getNumber().equals(dataCenter); ++i) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcInfo;
    }
}

