/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.shr.ltap;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.eas.cp.eip.sso.ltpa.ConfigurationError;
import com.kingdee.eas.cp.eip.sso.shr.ltap.ShrLtpaToken;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.cp.eip.sso.util.LMBCSUtil;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShrLtpaTokenManager {
    public static final String COOKIE_DOMAIN = "cookie.domain";
    public static final String COOKIE_NAME = "LtpaToken";
    public static final String DOMINO_SECRET = "domino.secret";
    public static final String TOKEN_EXPIRATION = "token.expiration";
    public static final String ISLMBCSENCODE = "isLMBCSEncode";
    public static final String OTP_DOMINO_SECRET_VALUE = "erewqreqr876";
    public static final String SDK_PROPERTIS_PATH = "shr_sso_client.jar:com.kingdee.shr.sso.client.ltpa.LtpaToken.properties";
    public static final String ALGORITHM = "algorithm";
    private static Logger logger = LoggerFactory.getLogger(ShrLtpaTokenManager.class);
    private static Properties properties = null;
    private static boolean isConfigLoaded = false;
    private static long lastModifiedTime = 0L;

    private ShrLtpaTokenManager() {
        throw new IllegalStateException("Utility class");
    }

    public static void loadConfig(String configFile) {
        if (!ShrLtpaTokenManager.isConfigLoaded()) {
            properties = new Properties();
            FileInputStream is = null;
            File file = new File(SHRCheck.checkFilePath((String)configFile));
            if (!file.exists()) {
                InputStream input = ShrLtpaTokenManager.class.getResourceAsStream("LtpaToken.properties");
                try {
                    properties.load(input);
                    isConfigLoaded = true;
                }
                catch (IOException e) {
                    throw new ConfigurationError("LtpaToken.properties not found. file = " + configFile);
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                is = new FileInputStream(SHRCheck.checkFilePath((String)configFile));
                properties.load(is);
                isConfigLoaded = true;
                lastModifiedTime = file.lastModified();
            }
            catch (IOException ioe) {
                throw new ConfigurationError("LtpaToken.properties not found. file = " + configFile);
            }
            finally {
                try {
                    if (null != is) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null == properties.getProperty(DOMINO_SECRET) || null == properties.getProperty(COOKIE_DOMAIN) || null == properties.getProperty(TOKEN_EXPIRATION)) {
                throw new ConfigurationError("LtpaToken.properties not configured properly. file = " + configFile);
            }
        }
    }

    public static ShrLtpaToken generate(String canonicalUser) {
        String configFile = ShrLtpaTokenManager.getDefaultConfigFile();
        return ShrLtpaTokenManager.generate(canonicalUser, configFile);
    }

    public static ShrLtpaToken generate(String canonicalUser, String configFile) {
        ShrLtpaTokenManager.initConfig(configFile);
        Date creationDate = new Date();
        Date expirationDate = new Date();
        int interval = Integer.parseInt(properties.getProperty(TOKEN_EXPIRATION));
        expirationDate.setTime(creationDate.getTime() + (long)(60000 * interval));
        return ShrLtpaTokenManager.generate(canonicalUser, creationDate, expirationDate, configFile, null);
    }

    public static ShrLtpaToken generate(String canonicalUser, String configFile, String authPattern) {
        ShrLtpaTokenManager.initConfig(configFile);
        Date creationDate = new Date();
        Date expirationDate = new Date();
        int interval = 0;
        interval = properties.containsKey(authPattern.toLowerCase() + "." + TOKEN_EXPIRATION) ? Integer.parseInt(authPattern.toLowerCase() + "." + TOKEN_EXPIRATION) : Integer.parseInt(properties.getProperty(TOKEN_EXPIRATION));
        expirationDate.setTime(creationDate.getTime() + (long)(60000 * interval));
        return ShrLtpaTokenManager.generate(canonicalUser, creationDate, expirationDate, configFile, authPattern);
    }

    public static ShrLtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires) {
        String configFile = ShrLtpaTokenManager.getDefaultConfigFile();
        return ShrLtpaTokenManager.generate(canonicalUser, tokenCreation, tokenExpires, configFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultConfigFile() {
        Properties prop = new Properties();
        String configFile = "";
        String defaultConfigFileName = "config.properties";
        InputStream is = ShrLtpaTokenManager.class.getResourceAsStream(defaultConfigFileName);
        try {
            prop.load(is);
            configFile = prop.getProperty("config.path");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return configFile;
    }

    public static ShrLtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires, String configFile, String authPattern) {
        String isLMBC;
        boolean isLMBCSEncode = false;
        if (properties != null && (isLMBC = properties.getProperty(ISLMBCSENCODE)) != null && "true".equals(isLMBC)) {
            isLMBCSEncode = true;
        }
        return ShrLtpaTokenManager.generate(canonicalUser, tokenCreation, tokenExpires, configFile, isLMBCSEncode, authPattern);
    }

    public static ShrLtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires, String configFile, boolean isLMBCSEncode, String authPattern) {
        ShrLtpaTokenManager.initConfig(configFile);
        ShrLtpaToken ltpa = new ShrLtpaToken();
        Calendar calendar = Calendar.getInstance();
        MessageDigest md = ltpa.getMessageDigest();
        ltpa.setHeader(new byte[]{0, 1, 2, 3});
        if (isLMBCSEncode) {
            ltpa.setUser(LMBCSUtil.getLMBCSLocalGroupBytes((String)canonicalUser));
        } else {
            try {
                ltpa.setUser(canonicalUser.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                ltpa.setUser(canonicalUser.getBytes());
            }
        }
        byte[] token = null;
        calendar.setTime(tokenCreation);
        ltpa.setCreation(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        calendar.setTime(tokenExpires);
        ltpa.setExpires(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        token = LMBCSUtil.concatenate(token, (byte[])ltpa.getHeader());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])ltpa.getCreation());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])ltpa.getExpires());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])ltpa.getUser());
        md.update(token);
        String secret = null;
        secret = authPattern != null && properties.containsKey(authPattern.toLowerCase() + "." + DOMINO_SECRET) ? properties.getProperty(authPattern.toLowerCase() + "." + DOMINO_SECRET) : properties.getProperty(DOMINO_SECRET);
        byte[] digest = md.digest(BASE64Util.decodeAsBytes((String)secret));
        String di = ShrLtpaTokenManager.byte2hex(digest);
        ltpa.setDigest(di.getBytes());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])di.getBytes());
        String tokenStr = BASE64Util.encode((byte[])token);
        String result = "";
        StringTokenizer st = new StringTokenizer(tokenStr);
        while (st.hasMoreTokens()) {
            result = result + st.nextToken();
        }
        return new ShrLtpaToken(result);
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs.toUpperCase();
    }

    private static void initConfig(String configFile) {
        ShrLtpaTokenManager.loadConfig(configFile);
    }

    public static boolean isValid(String ltpaToken) {
        ShrLtpaTokenManager.checkConfig();
        ShrLtpaToken ltpa = new ShrLtpaToken(ShrLtpaToken.decodeToken(ltpaToken));
        boolean result = ltpa.isValid(properties.getProperty(DOMINO_SECRET));
        if (!result) {
            logger.error(MessageFormat.format("shr LTPA token compare false, token: {0}", ltpaToken));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(MessageFormat.format("shr compare result:{0}", result));
        }
        return result;
    }

    public static boolean isValid(String ltpaToken, String authPattern) {
        ShrLtpaTokenManager.checkConfig();
        ShrLtpaToken ltpa = new ShrLtpaToken(ShrLtpaToken.decodeToken(ltpaToken));
        String secret = null;
        secret = properties.containsKey(authPattern.toLowerCase() + "." + DOMINO_SECRET) ? properties.getProperty(authPattern.toLowerCase() + "." + DOMINO_SECRET) : properties.getProperty(DOMINO_SECRET);
        boolean result = ltpa.isValid(secret);
        if (!result) {
            logger.error(MessageFormat.format("shr LTPA token compare false, token: {0}", ltpaToken));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(MessageFormat.format("shr compare result:{0}", result));
        }
        return result;
    }

    public static boolean isValidSecret(String authPattern) {
        boolean isEnableInitSecret;
        boolean bl = isEnableInitSecret = null != properties.getProperty("otp.isEnableInitSecret") ? Boolean.parseBoolean(properties.getProperty("otp.isEnableInitSecret")) : true;
        if (!isEnableInitSecret) {
            return false;
        }
        if (properties.containsKey(authPattern.toLowerCase() + "." + DOMINO_SECRET)) {
            String secret = properties.getProperty(authPattern.toLowerCase() + "." + DOMINO_SECRET);
            return OTP_DOMINO_SECRET_VALUE.equals(secret);
        }
        return false;
    }

    public static Cookie toCookie(String ltpaToken) {
        ShrLtpaTokenManager.checkConfig();
        Cookie cookie = new Cookie(COOKIE_NAME, ltpaToken);
        String domain = properties.getProperty(COOKIE_DOMAIN);
        if (domain != null && !"".equals(domain)) {
            cookie.setDomain(domain);
        }
        cookie.setPath("/ltpa");
        cookie.setSecure(false);
        cookie.setMaxAge(-1);
        return cookie;
    }

    private static void checkConfig() {
        if (!ShrLtpaTokenManager.isConfigLoaded()) {
            throw new ConfigurationError("LtpaToken properties is unloaded properly. ");
        }
    }

    private static boolean isConfigLoaded() {
        return isConfigLoaded;
    }

    public static String getDefaultLtpaConfig() {
        String portalConfig = System.getProperty("portal.config");
        if (portalConfig == null || "".equals(portalConfig)) {
            logger.info("[Eas Portal] please set system property [portal.config].");
            return "LtpaToken.properties";
        }
        File portalConfigFile = new File(SHRCheck.checkFilePath((String)portalConfig));
        if (!portalConfigFile.exists()) {
            return "LtpaToken.properties";
        }
        return portalConfigFile.getParentFile().getAbsolutePath() + "/LtpaToken.properties";
    }

    public static synchronized void loadDefaultConfig() {
        String config = ShrLtpaTokenManager.getDefaultLtpaConfig();
        File file = new File(SHRCheck.checkFilePath((String)config));
        if (file.exists() && file.lastModified() > lastModifiedTime) {
            isConfigLoaded = false;
        }
        ShrLtpaTokenManager.loadConfig(config);
    }

    public static boolean compare(String token, String userNumber) {
        boolean result = false;
        ShrLtpaToken lt = new ShrLtpaToken(ShrLtpaToken.decodeToken(token));
        String username = lt.getUsername();
        boolean bl = result = username == null ? false : username.equals(userNumber);
        if (logger.isDebugEnabled()) {
            logger.debug(MessageFormat.format("shr LTPA token compare result:{0}", result));
        }
        if (!result) {
            logger.error(MessageFormat.format("shr LTPA token compare false, token:{0}", token));
        }
        return result;
    }

    public static boolean verifyToken(String path, String token, String userNumber) {
        boolean result = false;
        if (path == null || path.trim().length() == 0) {
            ShrLtpaTokenManager.loadDefaultConfig();
        } else {
            ShrLtpaTokenManager.loadConfig(path);
        }
        boolean isValid = ShrLtpaTokenManager.isValid(ShrLtpaToken.decodeToken(token));
        if (isValid) {
            result = ShrLtpaTokenManager.compare(ShrLtpaToken.decodeToken(token), userNumber);
            if (!result) {
                logger.error("shr LTPA token compare false, token:" + token);
            }
        } else {
            logger.error("shr LTPA token isValid false, token:" + token);
        }
        return result;
    }

    public static boolean verifyToken(String path, String token, String userNumber, String authPattern) throws BOSLoginException {
        boolean result = false;
        if (path == null || path.trim().length() == 0) {
            ShrLtpaTokenManager.loadDefaultConfig();
        } else {
            ShrLtpaTokenManager.loadConfig(path);
        }
        boolean isValid = ShrLtpaTokenManager.isValid(ShrLtpaToken.decodeToken(token), authPattern);
        if (isValid) {
            result = ShrLtpaTokenManager.compare(ShrLtpaToken.decodeToken(token), userNumber);
            if (!result) {
                logger.error("shr LTPA token compare false, token:" + token);
            }
        } else {
            logger.error("shr LTPA token isValid false, token:" + token);
        }
        return result;
    }

    public static String getVerifyMsg(Context ctx, String line, String param) {
        String msg = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSystemResource", (String)"otp_domino_secret_check", (Context)ctx);
        String msg2 = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSystemResource", (String)"sso_secret_check", (Context)ctx);
        String server = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonplateResourse", (String)"sso_server_provider", (Context)ctx);
        String client = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonplateResourse", (String)"sso_client_caller", (Context)ctx);
        String configPath = ShrLtpaTokenManager.getDefaultLtpaConfig();
        String cilentConfigPath = SDK_PROPERTIS_PATH;
        StringBuilder sb = new StringBuilder();
        sb.append("{0}: ").append(param).append(line).append(server).append("{1},").append(line).append(client).append("{2},").append(line).append("{3}");
        return MessageFormat.format(sb.toString(), msg, configPath, cilentConfigPath, msg2);
    }

    public static String getVerifyMsgByClient(Context ctx) {
        String msg1 = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSystemResource", (String)"sso_secret_check_client", (Context)ctx);
        String msg2 = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSystemResource", (String)"sso_ltpa_client", (Context)ctx);
        String cilentConfigPath = SDK_PROPERTIS_PATH;
        return MessageFormat.format("{0}{1}{2}", msg1, msg2, cilentConfigPath);
    }

    protected static String getAlgorithm() {
        if (!isConfigLoaded) {
            ShrLtpaTokenManager.loadDefaultConfig();
        }
        if (properties != null) {
            return properties.getProperty(ALGORITHM);
        }
        return null;
    }
}

