/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/personPhoto"})
public class PersonPhotoController {
    private static final String DEFAULT_PHOTO = "/images/default_headsmall.png";

    @RequestMapping(method={RequestMethod.GET})
    public String getPhoto(HttpServletRequest request, HttpServletResponse response) throws BOSException, IOException {
        String personId = request.getParameter("personId");
        if (StringUtils.isEmpty((String)personId)) {
            personId = this.getCurrentPersonId();
        }
        return this.getPhoto(request, response, personId);
    }

    private String getCurrentPersonId() {
        Context ctx = SHRContext.getInstance().getContext();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String personId = null;
        if (userInfo.getPerson() != null) {
            personId = userInfo.getPerson().getId().toString();
        }
        return personId;
    }

    private String getPhoto(HttpServletRequest request, HttpServletResponse response, String personId) throws BOSException, IOException {
        if (StringUtils.isEmpty((String)personId)) {
            return "redirect:" + DEFAULT_PHOTO;
        }
        IPersonPhoto personPhoto = PersonPhotoFactory.getRemoteInstance();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        try {
            CoreBaseCollection coll = personPhoto.getCollection(entityViewInfo);
            PersonPhotoInfo personPhotoInfo = null;
            if (coll.size() > 0 && (personPhotoInfo = (PersonPhotoInfo)coll.get(0)).getImageData() != null) {
                byte[] fileContent = personPhotoInfo.getImageData();
                String ContentType = personPhotoInfo.getImageContentType();
                byte[] imageData = this.handleImageData(fileContent, ContentType);
                this.setResponseHeader(request, response, imageData);
                this.writeResponse(response, ContentType, imageData);
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "redirect:" + DEFAULT_PHOTO;
    }

    protected byte[] handleImageData(byte[] data, String imageType) throws IOException {
        return data;
    }

    protected void setResponseHeader(HttpServletRequest request, HttpServletResponse response, byte[] imageData) {
    }

    protected void writeResponse(HttpServletResponse response, String contentType, byte[] result) throws IOException {
        response.setHeader("charset", "UTF-8");
        response.setContentType(contentType);
        response.getOutputStream().write(result);
    }
}

