/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.guilogin.web.wechart;

import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.cp.eip.sso.EasDefaultAuthHandler;
import com.kingdee.eas.cp.eip.sso.EasMultiAuthManager;
import com.kingdee.eas.cp.eip.sso.IEasAuthHandler;
import com.kingdee.eas.cp.eip.sso.otp.OTPAuthHandler;
import com.kingdee.eas.cp.eip.sso.util.LoginUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class WeChartUtil {
    private static Logger logger = Logger.getLogger(WeChartUtil.class);

    public static String authenWechart(HttpServletRequest request, String authPattern, String userNumber, String token, String datacenter, String easSessionId, String locale) throws BOSLoginException {
        if (StringUtils.isEmpty((String)locale)) {
            locale = LocaleUtils.getDefaultLocale().getLanguage();
        }
        Context ctx = WeChartUtil.initRPC(datacenter, easSessionId, locale);
        if ("BaseDB".equals(authPattern)) {
            throw new BOSLoginException("BaseDB not enable");
        }
        IEasAuthHandler authHandler = WeChartUtil.getAuthHandler(authPattern);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("OTP AuthHandler: " + authHandler));
        }
        ctx.put((Object)"userAuthPattern", (Object)authPattern);
        UserContextCallback userCtxCallback = new UserContextCallback("UserContext: ");
        userCtxCallback.setUserContext(ctx);
        if (authHandler instanceof EasDefaultAuthHandler && "OTP".equalsIgnoreCase(authPattern)) {
            authHandler = new OTPAuthHandler();
        }
        String msg = null;
        try {
            boolean validate = authHandler.authenticate(userCtxCallback, userNumber, token);
            if (validate) {
                msg = authHandler.getEasUserNumber(ctx, userNumber);
            }
        }
        catch (BOSLoginException e) {
            if (!StringUtils.isEmpty((String)e.getMessage()) && e.getMessage().contains("sso access error:")) {
                msg = e.getMessage();
                logger.error((Object)("OTP msg: " + msg));
            }
            throw new BOSLoginException(e.getMessage(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("OTP msg: " + msg));
        }
        return msg;
    }

    protected static Context initRPC(String dataCenter, String easSessionId, String locale) {
        DCInfo dcInfo = WeChartUtil.getDCInfo(dataCenter);
        Locale lan = LocaleUtils.getLocale((String)locale);
        String dSoluName = "";
        String dnumber = "";
        if (dcInfo != null) {
            dnumber = dcInfo.getNumber();
            dSoluName = dcInfo.getSolutionName();
        }
        Context ctx = new Context(null, dSoluName, dnumber, lan);
        LoginUtil.initRpcConfig((Context)ctx, (String)easSessionId);
        return ctx;
    }

    public static DCInfo getDCInfo(String dataCenter) {
        DCInfo dcInfo = null;
        try {
            ArrayList dcList = DCManager.getInstance().getDCList();
            for (int i = 0; i < dcList.size() && !(dcInfo = (DCInfo)dcList.get(i)).getNumber().equals(dataCenter); ++i) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcInfo;
    }

    private static IEasAuthHandler getAuthHandler(String authPattern) {
        if (EasMultiAuthManager.isApplicationScope() || StringUtils.isEmpty((String)authPattern)) {
            authPattern = EasMultiAuthManager.getDefaultAuthPattern().getName();
        }
        return EasMultiAuthManager.getAuthHandler((String)authPattern);
    }

    private static boolean isRegisterAuthHandler(String serverName) {
        boolean isRegisterAuthHandler = false;
        String otpPathReal = SHRSyssettingUtil.getEasAuthPatternsPath((String)serverName);
        File file = new File(otpPathReal);
        SAXBuilder builder = new SAXBuilder();
        try {
            Document otpDoc = builder.build(file);
            Element rootElement = otpDoc.getRootElement();
            List children = rootElement.getChildren("authPattern");
            String filePatternName = null;
            if (children != null && children.size() > 0) {
                for (int i = 0; i < children.size(); ++i) {
                    filePatternName = ((Element)children.get(i)).getChildText("name");
                    if (!filePatternName.equals("OTP")) continue;
                    String fileAuthHandler = ((Element)children.get(i)).getChildText("authHandler");
                    Class<?> authPatternClass = Class.forName(fileAuthHandler);
                    IEasAuthHandler authHandlerReload = (IEasAuthHandler)authPatternClass.newInstance();
                    EasMultiAuthManager.registerAuthHandler((String)filePatternName, (IEasAuthHandler)authHandlerReload);
                    isRegisterAuthHandler = true;
                }
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | JDOMException e) {
            e.printStackTrace();
        }
        return isRegisterAuthHandler;
    }

    private static List<File> getServerList() {
        String serverPath = SHRSyssettingUtil.getProfilesPath();
        File[] fileDirs = new File(serverPath).listFiles();
        ArrayList<File> retrunFolders = new ArrayList<File>();
        for (File f : fileDirs) {
            if (!f.isDirectory() || f.listFiles().length == 0) continue;
            retrunFolders.add(f);
        }
        if (retrunFolders.isEmpty()) {
            logger.error((Object)"init server lib error!");
        }
        return retrunFolders;
    }
}

