/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.lightapp.wx;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.lightapp.wx.AccessTokenCache;
import com.kingdee.shr.lightapp.xt.XTServiceConfig;
import com.kingdee.shr.lightapp.xt.dto.XtParamsDTO;
import com.kingdee.shr.lightapp.xt.util.LoginHelper;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.contrib.ssl.StrictSSLProtocolSocketFactory;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WXUtil {
    private static final Logger logger = LoggerFactory.getLogger(WXUtil.class);
    private static final String accessTokenUrl = "https://qyapi.weixin.qq.com/cgi-bin/gettoken";
    private static final String sendMessageUrl = "https://qyapi.weixin.qq.com/cgi-bin/message/send";
    private static final String getUserInfoURL = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo";
    private static final String URL_GetUserInfo = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN&userid=USERID";
    private static final String URL_GETCODE = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=CORPID&redirect_uri=URL&response_type=code&scope=snsapi_base&state=CORPID#wechat_redirect";
    private static String[] wxConfigs = null;
    private static Object lock = new Object();
    private static HashMap openid2avatar = new HashMap();
    private static String RESOURCE = "com.kingdee.shr.base.syssetting.SHRSystemResource";

    public static String getSendMessageUrl() throws Exception {
        return "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + AccessTokenCache.getAccessToken();
    }

    public static XtParamsDTO getXtParamsDTO(HttpSession session, String code, String state) throws Exception {
        long t1 = System.currentTimeMillis();
        String[] configs = WXUtil.getWXConfig();
        XtParamsDTO xtParamsDTO = new XtParamsDTO();
        xtParamsDTO.setEid(state);
        String openid = (String)session.getAttribute("openid");
        if (openid == null) {
            openid = WXUtil.getUserIDFromWX(session, configs, code);
        }
        xtParamsDTO.setOpenid(openid);
        xtParamsDTO.setWx(true);
        logger.info(" get openid from WX timout : " + (System.currentTimeMillis() - t1));
        return xtParamsDTO;
    }

    private static String getUserIDFromWX(HttpSession session, String[] configs, String code) throws Exception {
        String userId = "";
        String access_token = AccessTokenCache.getAccessToken();
        String agentid = configs[2];
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token=" + URLEncoder.encode(access_token, "UTF-8") + "&code=" + URLEncoder.encode(code, "UTF-8") + "&agentid=" + URLEncoder.encode(agentid, "UTF-8");
        String result = WXUtil.getResponse(url);
        JSONObject jb = new JSONObject(result);
        if (!jb.isNull("UserId")) {
            userId = jb.getString("UserId");
            session.setAttribute("openid", (Object)userId);
        } else if (!jb.isNull("errcode") && "42001".equals(jb.get("errcode"))) {
            AccessTokenCache.refreshAccessToken();
            userId = WXUtil.getUserIDFromWX(session, configs, code);
            session.setAttribute("openid", (Object)userId);
        } else {
            if (!jb.isNull("errcode") && "40029".equals(jb.get("errcode"))) {
                throw new Exception(SHRWebResource.getString((String)RESOURCE, (String)"relogin"));
            }
            throw new Exception(SHRWebResource.getString((String)RESOURCE, (String)"get_userid_fail") + result);
        }
        return userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getWXConfig() {
        if (wxConfigs != null) {
            return wxConfigs;
        }
        Object object = lock;
        synchronized (object) {
            if (wxConfigs != null) {
                return wxConfigs;
            }
            ConfigurationItem ci = XTServiceConfig.getInstance().getConfiguration().getConfigItem("WX");
            wxConfigs = new String[3];
            WXUtil.wxConfigs[0] = ci.getProperty("corpid", "");
            WXUtil.wxConfigs[1] = ci.getProperty("corpsecret", "");
            WXUtil.wxConfigs[2] = ci.getProperty("agentid", "");
        }
        return wxConfigs;
    }

    public static Map doGetUserPic(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        String type = request.getParameter("type");
        String[] ids = request.getParameter("ids").split(",");
        Map idsMap = null;
        if ("openid".equalsIgnoreCase(type)) {
            idsMap = new HashMap();
            for (int i = 0; i < ids.length; ++i) {
                idsMap.put(ids[i], ids[i]);
            }
        } else if ("userid".equalsIgnoreCase(type)) {
            idsMap = WXUtil.getOpenIdByUserIds(session, ids);
        } else if ("procinstid".equalsIgnoreCase(type)) {
            idsMap = WXUtil.getOpenIdByProcInstIds(session, ids);
        }
        HashMap<String, String> retMap = new HashMap<String, String>();
        if (idsMap != null && idsMap.size() > 0) {
            String access_token = AccessTokenCache.getAccessToken();
            String tempUrl = URL_GetUserInfo.replace("ACCESS_TOKEN", access_token);
            String path = System.getProperty("EAS_HOME");
            File file = new File(SHRCheck.checkFilePath((String)(path = path + "/server/deploy/eas.ear/light_app_bas.war/avatar/")));
            if (!file.exists()) {
                file.mkdirs();
            }
            int i = 0;
            File outFile = null;
            String url = null;
            Iterator iter = idsMap.entrySet().iterator();
            while (iter.hasNext()) {
                String avatar;
                url = tempUrl;
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String openid = (String)entry.getValue();
                outFile = new File(SHRCheck.checkFilePath((String)(path + openid + ".jpeg")));
                long da = outFile.lastModified();
                Date date = new Date(da);
                Date now = new Date();
                Calendar c = Calendar.getInstance();
                c.setTime(date);
                int day = c.get(5);
                c.set(5, day + 1);
                String dayBefore = new SimpleDateFormat("yyyy/MM/dd").format(c.getTime());
                Date date2 = new Date(dayBefore);
                boolean flag = date2.before(now);
                if (outFile.exists() && !flag && openid2avatar.containsKey(openid)) {
                    avatar = (String)openid2avatar.get(openid);
                    if (avatar != null) {
                        retMap.put(key, avatar);
                    }
                } else {
                    avatar = "";
                    if (openid != null && openid.length() > 0) {
                        try {
                            url = url.replace("USERID", openid);
                            String result = WXUtil.getResponse(url);
                            JSONObject jb = new JSONObject(result);
                            if (!jb.isNull("avatar")) {
                                avatar = jb.getString("avatar");
                            }
                        }
                        catch (Throwable t) {
                            logger.error("Error when getUserPic", t);
                        }
                    }
                    avatar = WXUtil.saveAvatarToLocal(path, openid, avatar);
                    openid2avatar.put(openid, avatar);
                    if (avatar != null) {
                        retMap.put(key, avatar);
                    }
                }
                ++i;
            }
            return retMap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String saveAvatarToLocal(String path, String openid, String avatar) {
        OutputStream os = null;
        InputStream is = null;
        try {
            File outFile = new File(SHRCheck.checkFilePath((String)(path + openid + ".jpeg")));
            long da = outFile.lastModified();
            Date date = new Date(da);
            Date now = new Date();
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            int day = c.get(5);
            c.set(5, day + 1);
            String dayBefore = new SimpleDateFormat("yyyy/MM/dd").format(c.getTime());
            Date date2 = new Date(dayBefore);
            boolean flag = date2.before(now);
            if (!outFile.exists() && flag) {
                URL url = new URL(avatar);
                os = new FileOutputStream(outFile);
                is = url.openStream();
                byte[] buff = new byte[1024];
                int length = 0;
                while ((length = is.read(buff)) > 0) {
                    os.write(buff, 0, length);
                }
            }
            String string = "/lightapp/avatar/" + openid + ".jpeg";
            return string;
        }
        catch (Exception e) {
            logger.error("saveAvatarToLocal", (Throwable)e);
            return null;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                logger.error("saveAvatarToLocal", (Throwable)e);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception e) {
                        logger.error("saveAvatarToLocal", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map getOpenIdByProcInstIds(HttpSession session, String[] ids) {
        HashMap<String, String> hashMap;
        String str = "";
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                str = str + ",";
            }
            str = str + "'" + ids[i] + "'";
        }
        String sql = " select A.fprocinstid ,B.fxtid from t_wfr_procinst A ,t_pm_easwxusermap B where   A. finitiatorid=B.fuserid and A.fprocinstid in ( ?)";
        Context ctx = (Context)session.getAttribute("XTContext");
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.prepareStatement(sql);
            stmt.setString(1, str);
            rs = stmt.executeQuery();
            HashMap<String, String> idsMap = new HashMap<String, String>();
            while (rs.next()) {
                String procinstid = rs.getString(1);
                String wxid = rs.getString(2);
                if (wxid == null || wxid.length() <= 0) continue;
                idsMap.put(procinstid, wxid);
            }
            hashMap = idsMap;
        }
        catch (SQLException e) {
            try {
                logger.error("getOpenIdByProcInstIds error: ", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            return null;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map getOpenIdByUserIds(HttpSession session, String[] ids) {
        HashMap<String, String> hashMap;
        String str = "";
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                str = str + ",";
            }
            str = str + "'" + ids[i] + "'";
        }
        String sql = " select fuserid, fxtid from t_pm_easwxusermap  where   fuserid in (?)";
        Context ctx = (Context)session.getAttribute("XTContext");
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.prepareStatement(sql);
            stmt.setString(1, str);
            rs = stmt.executeQuery();
            HashMap<String, String> idsMap = new HashMap<String, String>();
            while (rs.next()) {
                String procinstid = rs.getString(1);
                String wxid = rs.getString(2);
                if (wxid == null || wxid.length() <= 0) continue;
                idsMap.put(procinstid, wxid);
            }
            hashMap = idsMap;
        }
        catch (SQLException e) {
            try {
                logger.error("getOpenIdByUserIds error: ", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            return null;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return hashMap;
    }

    public static String getResponse(String url) throws Exception {
        String respStr = "";
        Protocol myhttps = new Protocol("https", (SecureProtocolSocketFactory)new StrictSSLProtocolSocketFactory(false), 443);
        Protocol.registerProtocol((String)"https", (Protocol)myhttps);
        HttpClient client = new HttpClient();
        int charIndex = url.indexOf("?");
        String urlParams = url.substring(charIndex + 1);
        url = url.substring(0, charIndex);
        String[] paramStrings = urlParams.split("&");
        GetMethod get = new GetMethod(url);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (String p : paramStrings) {
            String name = p.substring(0, p.indexOf("="));
            String value = p.substring(p.indexOf("=") + 1);
            params.add(new NameValuePair(name, value));
        }
        get.setQueryString(params.toArray(new NameValuePair[0]));
        try {
            client.executeMethod((HttpMethod)get);
            respStr = get.getResponseBodyAsString();
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(respStr.toString().getBytes("UTF-8"), "UTF-8");
    }

    public static Map doBind(HttpServletRequest httpRequest) {
        HttpSession session = httpRequest.getSession();
        String user = httpRequest.getParameter("user");
        String password = httpRequest.getParameter("password");
        HashMap<String, String> result = new HashMap<String, String>();
        String openid = (String)session.getAttribute("openid");
        String eid = (String)session.getAttribute("eid");
        boolean isFromXT = true;
        if (session.getAttribute("isWX") != null && session.getAttribute("isWX").toString().equalsIgnoreCase("true")) {
            isFromXT = false;
        }
        try {
            Context ctx = LoginHelper.loginEAS(eid, URLDecoder.decode(user), password);
            session.setAttribute("XTContext", (Object)ctx);
            WXUtil.bind0(ctx, openid, isFromXT);
            result.put("result", "ok");
        }
        catch (Exception e) {
            logger.debug("WXUtil error:", (Throwable)e);
            result.put("result", e.getMessage());
            result.put("error", "11");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bind0(Context ctx, String openid, boolean isFromXT) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block12: {
            con = null;
            ps = null;
            rs = null;
            String userid = ctx.getCaller().toString();
            String tableName = " T_PM_EASWXUSERMAP ";
            String sql = null;
            if (isFromXT) {
                tableName = " T_PM_EASXTUSERMAP ";
            }
            String l = LocaleUtils.getShortCode((Context)ctx);
            sql = "SELECT FID FROM " + tableName + " WHERE FUserID = ? ";
            try {
                con = EJBFactory.getConnection((Context)ctx);
                ps = con.prepareStatement(sql);
                ps.setString(1, userid);
                rs = ps.executeQuery();
                if (rs.next()) {
                    sql = "UPDATE " + tableName + " SET FXTID = ? WHERE FUserID = ? ";
                    ps.close();
                    ps = con.prepareStatement(sql);
                    ps.setString(1, openid);
                    ps.setString(2, userid);
                    ps.executeUpdate();
                    break block12;
                }
                sql = "select fid,  fpersonid, fnumber, fname_" + l + " from t_pm_user where fid = ?";
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement(sql);
                ps.setString(1, userid);
                rs = ps.executeQuery();
                String fpersonid = null;
                String fnumber = null;
                String fname = null;
                if (rs.next()) {
                    fpersonid = rs.getString(2);
                    fnumber = rs.getString(3);
                    fname = rs.getString(4);
                }
                sql = "insert into " + tableName + " (fid, fpersonid, fuserid, fxtid, fusernumber,fusername,fpersonname)  values(newbosid('ABCD8899'),?,?,?,?,?,'" + SHRWebResource.getString((String)RESOURCE, (String)"assis_bind") + "')";
                logger.debug("WXUtils sql :" + sql);
                ps.close();
                ps = con.prepareStatement(sql);
                ps.setString(1, fpersonid);
                ps.setString(2, userid);
                ps.setString(3, openid);
                ps.setString(4, fnumber);
                ps.setString(5, fname);
                ps.execute();
            }
            catch (Exception e) {
                try {
                    logger.debug("WXUtils error: ", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)con);
                    throw throwable;
                }
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
    }

    public static String encodeWXGetCodeUrl(String url) {
        String[] config = WXUtil.getWXConfig();
        url = URLEncoder.encode(url);
        String ret = URL_GETCODE.replaceAll("CORPID", config[0]);
        ret = ret.replace("URL", url);
        return ret;
    }
}

