/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet;

import com.kingdee.bos.autoupdate.JNLPException;
import com.kingdee.bos.autoupdate.dl.RSDownloadListener;
import com.kingdee.bos.autoupdate.dl.RSDownloaderFactory;
import com.kingdee.bos.ctrl.easprogressbar.KDProgressBar;
import com.kingdee.eas.applet.AppletDownloadCacheUpdater;
import com.kingdee.eas.applet.RSDownloaderHttpImpl;
import com.kingdee.eas.webutil.JnlpUtil;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JApplet;
import javax.swing.JProgressBar;
import netscape.javascript.JSObject;

public class AppletDownload
extends JApplet {
    private static int downloadedFileCount = 0;
    private static JProgressBar progressBar = null;
    private static int fileTotalCount = 100;
    private AppletDownloadCacheUpdater updater = null;
    private URL jnlpURL = null;
    private static final String DEFAULTCLIENTHOME = "C:/kingdee/eas/client";
    private String localDirName = null;

    public void init() {
        long start = System.currentTimeMillis();
        super.init();
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(new Color(63, 136, 189));
        progressBar = new KDProgressBar(0, fileTotalCount);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        progressBar.setString("0%");
        this.getContentPane().setBackground(new Color(63, 136, 189));
        this.getContentPane().add((Component)progressBar, "Center");
        Thread threadDetectNewEdition = new Thread(new Runnable(){

            public void run() {
                AppletDownload.this.updatePluginParams();
                AppletDownload.this.preUpdate();
                AppletDownload.this.checkDownloadFiles();
            }
        });
        threadDetectNewEdition.start();
        System.out.println("applet init, used time[" + (System.currentTimeMillis() - start) + " ms ]");
    }

    private void updatePluginParams() {
        long start = System.currentTimeMillis();
        File deploymentFile = new File(System.getProperty("user.home") + "\\" + "Application Data\\Sun\\Java\\Deployment\\deployment.properties");
        if (deploymentFile.exists()) {
            try {
                FileInputStream is = new FileInputStream(deploymentFile);
                Properties prop = new Properties();
                prop.load(is);
                String params = (String)prop.get("javaplugin.jre.params");
                if (params == null || params.indexOf("-Xmx") == -1) {
                    prop.put("javaplugin.jre.params", "-Xms64m -Xmx192m");
                    FileOutputStream os = new FileOutputStream(deploymentFile);
                    prop.store(os, "Kingdee modified");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        long cost = System.currentTimeMillis() - start;
        System.out.println("Update plugin params : " + cost + "ms!");
    }

    private void preUpdate() {
        String localUpdateServerUrl;
        long start = System.currentTimeMillis();
        Preferences pref = Preferences.systemRoot().node("kingdee/eas");
        String easClientHome = pref.get("easclienthome", null);
        System.out.println("Eas client home : " + easClientHome);
        if (easClientHome == null || easClientHome.trim().length() == 0) {
            easClientHome = DEFAULTCLIENTHOME;
            pref.put("easclienthome", DEFAULTCLIENTHOME);
        }
        if ((localUpdateServerUrl = JnlpUtil.getUpdateServer(easClientHome)) != null) {
            String remoteUpdateServerUrl = this.getParameter("jnlpURL");
            System.out.println("Remote update server url : " + remoteUpdateServerUrl);
            System.out.println("Local update server url : " + localUpdateServerUrl);
            if (!remoteUpdateServerUrl.startsWith(localUpdateServerUrl)) {
                System.out.println("Begin set updater server url!");
                int length = remoteUpdateServerUrl.length() - "eas.jnlp".length();
                String remoteUpdateServerDirUrl = remoteUpdateServerUrl.substring(0, length);
                JnlpUtil.setUpdateServer(easClientHome, remoteUpdateServerDirUrl);
                System.out.println("End set updater server url!");
                String newUrl = JnlpUtil.getUpdateServer(easClientHome);
                System.out.println("New client update server url : " + newUrl);
            }
        }
        this.localDirName = easClientHome;
        long cost = System.currentTimeMillis() - start;
        System.out.println("Pre update : " + cost + "ms!");
    }

    private void autoUpdate() {
        try {
            URL jnlpURL = new URL(this.getParameter("jnlpURL"));
            if (this.localDirName == null) {
                this.localDirName = this.getParameter("localDir");
            }
            File localDir = new File(this.localDirName);
            if (jnlpURL == null || localDir == null) {
                throw new IllegalArgumentException("Please set jnlpURL and localDir!");
            }
            if (!localDir.exists()) {
                localDir.mkdirs();
            }
            if (!localDir.isDirectory()) {
                throw new IllegalArgumentException("The localDir is not a directory!");
            }
            long start = System.currentTimeMillis();
            AppletDownloadCacheUpdater updater = new AppletDownloadCacheUpdater(jnlpURL, localDir);
            fileTotalCount = updater.getUpdateFileCount();
            progressBar.setMaximum(fileTotalCount);
            RSDownloaderFactory.getRSDownloader((String)jnlpURL.getProtocol()).addRSDownloadListener(new RSDownloadListener(){

                public void beginDownload(URL url) {
                    System.out.println("URL begin downloaded: " + url);
                }

                public void downloadProgress(URL url, long length, long totalRead) {
                }

                public void finishDownload(URL url) {
                    downloadedFileCount++;
                    progressBar.setValue(downloadedFileCount);
                    long currPercent = Math.round(new Integer(downloadedFileCount).doubleValue() / new Integer(fileTotalCount).doubleValue() * 100.0);
                    if (currPercent > 100L) {
                        currPercent = 100L;
                    }
                    progressBar.setString(currPercent + "%");
                    System.out.println("URL downloaded: " + url + ";downloaded file count:" + downloadedFileCount);
                }
            });
            updater.update();
            System.out.println("Update from http used time[" + (System.currentTimeMillis() - start) + "]");
            this.redirect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (JNLPException e) {
            e.printStackTrace();
        }
    }

    private void checkDownloadFiles() {
        long start = System.currentTimeMillis();
        try {
            this.jnlpURL = new URL(this.getParameter("jnlpURL"));
            if (this.localDirName == null) {
                this.localDirName = this.getParameter("localDir");
            }
            File localDir = new File(this.localDirName);
            if (this.jnlpURL == null || localDir == null) {
                throw new IllegalArgumentException("Please set jnlpURL and localDir!");
            }
            if (!localDir.exists()) {
                localDir.mkdirs();
            }
            if (!localDir.isDirectory()) {
                throw new IllegalArgumentException("The localDir is not a directory!");
            }
            this.updater = new AppletDownloadCacheUpdater(this.jnlpURL, localDir);
            fileTotalCount = this.updater.getUpdateFileCount();
            System.out.println("check new version, used time[" + (System.currentTimeMillis() - start) + " ms ]");
            if (fileTotalCount > 0) {
                progressBar.setMaximum(fileTotalCount);
                Thread threadPrompt = new Thread(new Runnable(){

                    public void run() {
                        AppletDownload.this.existNewEdition();
                    }
                });
                threadPrompt.start();
                this.downloadFiles();
            } else {
                System.out.println("Open Url Connection times:" + RSDownloaderHttpImpl.getInstance().getUrlConnCount());
                this.redirect(null);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (JNLPException e) {
            e.printStackTrace();
        }
    }

    private void downloadFiles() {
        long start = System.currentTimeMillis();
        RSDownloaderHttpImpl.getInstance().addRSDownloadListener(new RSDownloadListener(){

            public void beginDownload(URL url) {
                System.out.println("URL begin downloaded: " + url);
            }

            public void downloadProgress(URL url, long length, long totalRead) {
            }

            public void finishDownload(URL url) {
                downloadedFileCount++;
                progressBar.setValue(downloadedFileCount);
                long currPercent = Math.round(new Integer(downloadedFileCount).doubleValue() / new Integer(fileTotalCount).doubleValue() * 100.0);
                if (currPercent > 100L) {
                    currPercent = 100L;
                }
                progressBar.setString(currPercent + "%");
                System.out.println("URL downloaded: " + url + ";downloaded file count:" + downloadedFileCount);
            }
        });
        try {
            HashMap hashMap = this.updater.update();
            System.out.println("download files, used time[" + (System.currentTimeMillis() - start) + " ms ]");
            System.out.println("Open Url Connection is " + RSDownloaderHttpImpl.getInstance().getUrlConnCount());
            if (hashMap != null && hashMap.size() > 0) {
                this.redirect(hashMap);
            } else {
                this.redirect(null);
            }
        }
        catch (JNLPException e) {
            e.printStackTrace();
        }
    }

    private void redirect() {
        JSObject win = JSObject.getWindow((Applet)this);
        win.eval("redirect(\"\")");
    }

    private void existNewEdition() {
        JSObject win = JSObject.getWindow((Applet)this);
        win.eval("existNewEdition()");
    }

    private void redirect(HashMap hashMap) {
        StringBuffer strErr = new StringBuffer();
        int n = 0;
        if (hashMap != null) {
            n = hashMap.size();
            Iterator i = hashMap.keySet().iterator();
            while (i.hasNext()) {
                strErr.append(i.next()).append("\\n");
            }
        }
        JSObject win = JSObject.getWindow((Applet)this);
        win.eval("redirect(" + n + ",\"" + strErr + "\")");
    }
}

