/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet;

import com.kingdee.bos.autoupdate.dl.RSDownloadListener;
import com.kingdee.bos.ctrl.easprogressbar.KDProgressBar;
import com.kingdee.eas.applet.EasClientDownloaderFactory;
import com.kingdee.eas.applet.IEasClientDownloader;
import com.kingdee.eas.webutil.PropertiesUtil;
import java.applet.Applet;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JApplet;
import javax.swing.JProgressBar;
import netscape.javascript.JSObject;

public class AppletSecondaryResxDownload
extends JApplet {
    private int downloadedFileCount = 0;
    private JProgressBar progressBar = null;
    private int fileTotalCount = 100;
    private int fileTotalSize = 100;
    private String fileBasePath = null;
    private String filesDownloaded = null;
    private String separator = ",";
    private String localBasePath = "";
    private Thread threadDownload = null;
    private boolean autoStart = false;
    private boolean isNotified = false;
    private JSObject win = null;
    private String fileNameChecked = null;
    private boolean checkResult = false;
    private String downloadTraceFile = "";
    private final String UPDATE_ATTRIBUTE = "downloadCompleted";
    private final String LAST_FILES_DOWNLOADED = "lastFilesDownloaded";
    private boolean lastDownloadTraceFlag = false;
    private String lastFilesDownloaded;

    public void init() {
        super.init();
        this.initParameter();
        this.initProgress();
        this.loadDownloadTraceLog();
        this.checkLocalFileExists();
        this.threadDownload = new Thread(new Runnable(){

            public void run() {
                AppletSecondaryResxDownload.this.downloadFiles();
            }
        });
        if (this.autoStart) {
            this.startDownloadThread();
        }
    }

    public void startDownloadThread() {
        this.threadDownload.start();
    }

    private void initProgress() {
        this.progressBar = new KDProgressBar(0, this.fileTotalCount);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.getContentPane().add((Component)this.progressBar, "Center");
        this.repaint();
        this.progressBar.setMaximum(this.fileTotalSize);
    }

    private void downloadFiles() {
        try {
            URL baseUrl = new URL(this.fileBasePath);
            File baseDir = new File(this.localBasePath);
            if (!this.lastDownloadTraceFlag) {
                System.out.println("lastFilesDownloaded=" + this.lastFilesDownloaded);
                System.out.println("filesDownloaded=" + this.filesDownloaded);
                if (this.lastFilesDownloaded != null && !"".equals(this.lastFilesDownloaded)) {
                    this.filesDownloaded = this.filtFilesLasgDownloaed();
                }
                System.out.println("after filted,filesDownloaded=" + this.filesDownloaded);
                if (this.filesDownloaded != null && !"".equals(this.filesDownloaded)) {
                    URL[] urlsDownloaded = this.toURLs(this.fileBasePath, this.filesDownloaded, this.separator);
                    IEasClientDownloader downloader = EasClientDownloaderFactory.getDownloader("http");
                    downloader.addRSDownloadListener(new RSDownloadListener(){

                        public void beginDownload(URL url) {
                            System.out.println("URL begin downloaded: " + url);
                        }

                        public void downloadProgress(URL url, long length, long totalRead) {
                            long currPercent = Math.round(new Long(totalRead).doubleValue() / new Long(length).doubleValue() * 100.0);
                            if (currPercent > 100L) {
                                currPercent = 100L;
                            }
                            AppletSecondaryResxDownload.this.progressBar.setValue(new Long(currPercent).intValue());
                            String msgStr = currPercent + "%";
                            AppletSecondaryResxDownload.this.progressBar.setString(msgStr);
                        }

                        public void finishDownload(URL url) {
                            AppletSecondaryResxDownload.this.downloadedFileCount++;
                            String fileStr = url.toString();
                            fileStr = fileStr.toLowerCase().replaceAll(AppletSecondaryResxDownload.this.fileBasePath.toLowerCase(), "");
                            AppletSecondaryResxDownload.this.lastFilesDownloaded = AppletSecondaryResxDownload.this.lastFilesDownloaded + (fileStr + AppletSecondaryResxDownload.this.separator);
                            AppletSecondaryResxDownload.this.storeDownloadTraceLog();
                            if (AppletSecondaryResxDownload.this.isNotified) {
                                AppletSecondaryResxDownload.this.notifyWhenFinishDownload(url);
                            }
                            System.out.println("URL downloaded: " + url + ";downloaded file count:" + AppletSecondaryResxDownload.this.downloadedFileCount);
                        }
                    });
                    HashMap errMsgMap = downloader.downloadFiles(baseUrl, urlsDownloaded, baseDir);
                    if (errMsgMap != null && errMsgMap.size() > 0) {
                        this.lastDownloadTraceFlag = false;
                        this.prompt(errMsgMap);
                    } else {
                        this.lastDownloadTraceFlag = true;
                    }
                    this.storeDownloadTraceLog();
                }
            }
        }
        catch (MalformedURLException e) {
            this.prompt(e);
            e.printStackTrace();
        }
    }

    private String filtFilesLasgDownloaed() {
        String result = this.filesDownloaded;
        if (this.lastFilesDownloaded != null || !"".equals(this.lastFilesDownloaded)) {
            StringBuffer sb = new StringBuffer("");
            String[] files = this.filesDownloaded.split(this.separator);
            String lastFiles = this.separator + this.lastFilesDownloaded + this.separator;
            String searchStr = "";
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null || "".equals(files[i])) continue;
                searchStr = this.separator + files[i] + this.separator;
                if (lastFiles.toLowerCase().indexOf(searchStr.toLowerCase()) > -1) continue;
                sb.append(files[i]);
                sb.append(this.separator);
            }
            result = sb.toString();
        }
        return result;
    }

    private void loadDownloadTraceLog() {
        Properties prop = PropertiesUtil.load(this.localBasePath, this.downloadTraceFile);
        if (prop != null) {
            String lastDownloadTraceFlagStr = prop.getProperty("downloadCompleted");
            this.lastDownloadTraceFlag = new Boolean(lastDownloadTraceFlagStr);
            this.lastFilesDownloaded = prop.getProperty("lastFilesDownloaded");
        } else {
            this.lastDownloadTraceFlag = false;
            this.lastFilesDownloaded = "";
            this.storeDownloadTraceLog();
        }
    }

    private void storeDownloadTraceLog() {
        boolean bflag = this.lastDownloadTraceFlag;
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("downloadCompleted", "" + bflag);
        hash.put("lastFilesDownloaded", this.lastFilesDownloaded);
        PropertiesUtil.store(this.localBasePath, this.downloadTraceFile, hash);
    }

    private void initParameter() {
        String autoStartFlag;
        this.win = JSObject.getWindow((Applet)this);
        this.fileBasePath = this.getParameter("fileBasePath");
        this.filesDownloaded = this.getParameter("filesDownloaded");
        this.separator = this.getParameter("separator");
        if (this.separator == null || "".equals(this.separator)) {
            this.separator = ",";
        }
        Preferences pref = Preferences.systemRoot().node("kingdee/eas");
        this.localBasePath = pref.get("easclienthome", null);
        if (this.localBasePath == null || "".equals(this.localBasePath)) {
            this.localBasePath = this.getParameter("localBasePath");
        }
        this.autoStart = (autoStartFlag = this.getParameter("autoStartDownload")) != null && "true".equalsIgnoreCase(autoStartFlag);
        String isNotifiedFlag = this.getParameter("isNotifiedWhenFinishDownloading");
        this.isNotified = isNotifiedFlag != null && "true".equalsIgnoreCase(isNotifiedFlag);
        this.fileNameChecked = this.getParameter("fileNameChecked");
        this.downloadTraceFile = this.getParameter("downloadTraceFile");
        if (this.downloadTraceFile == null || "".equals(this.downloadTraceFile)) {
            this.downloadTraceFile = "updateSecondaryResx.properties";
        }
    }

    private void checkLocalFileExists() {
        if (this.lastDownloadTraceFlag || !this.lastDownloadTraceFlag && this.lastFilesDownloaded.indexOf(this.fileNameChecked) > -1) {
            File fileHandle = new File(this.localBasePath, this.fileNameChecked);
            this.checkResult = fileHandle.exists();
        } else {
            this.checkResult = false;
        }
    }

    public boolean checkLocalResx() {
        return this.checkResult;
    }

    private void prompt(Exception e) {
        String strErr = e.toString();
        JSObject win = JSObject.getWindow((Applet)this);
        win.eval("promptResult(\"" + strErr + "\")");
    }

    private void prompt(HashMap errMsgMap) {
        StringBuffer strErr = new StringBuffer();
        int n = 0;
        if (errMsgMap != null) {
            n = errMsgMap.size();
            Iterator i = errMsgMap.keySet().iterator();
            while (i.hasNext()) {
                strErr.append(i.next()).append("\\n");
            }
        }
        JSObject win = JSObject.getWindow((Applet)this);
        win.eval("promptResult(" + n + ",\"" + strErr + "\")");
    }

    private void notifyWhenFinishDownload(URL url) {
        this.win.eval("notifyWhenFinishDownload('" + url.toString() + "')");
    }

    private URL[] toURLs(String fileBasePath, String filesDownloaded, String separator) {
        String[] filesUrlStr = filesDownloaded.split(separator);
        int size = filesUrlStr.length;
        URL[] result = new URL[size];
        for (int i = 0; i < size; ++i) {
            try {
                result[i] = new URL(fileBasePath + filesUrlStr[i]);
                continue;
            }
            catch (MalformedURLException e) {
                System.out.println(fileBasePath + filesUrlStr[i] + " is invalid URL.");
                e.printStackTrace();
            }
        }
        return result;
    }

    public void destroy() {
        super.destroy();
        this.win = null;
        this.autoStart = false;
        this.isNotified = false;
    }
}

