/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class FileAccessI
implements Serializable {
    RandomAccessFile oSavedFile;
    File tmpFile;
    DataOutputStream output;
    long nPos = 0L;
    String fileName = null;

    public FileAccessI(String sName) throws IOException {
        this.fileName = sName;
        this.tmpFile = new File(this.fileName + ".info");
    }

    public boolean existsInfoFile() {
        return this.tmpFile.exists();
    }

    public long getDLFileSize() {
        long nLong = 0L;
        File file = new File(this.fileName + ".dl");
        if (file.exists()) {
            nLong = file.length();
        }
        return nLong;
    }

    public boolean delDLFile() throws FileNotFoundException {
        File file = new File(this.fileName + ".dl");
        boolean bDel = true;
        if (file.exists()) {
            bDel = file.delete();
        }
        return bDel;
    }

    public boolean delInfoFile() {
        return this.tmpFile.delete();
    }

    public void setPos(long nPos) throws IOException {
        this.nPos = nPos;
        this.oSavedFile = new RandomAccessFile(this.fileName + ".dl", "rw");
        this.oSavedFile.seek(nPos);
    }

    public synchronized int write(byte[] b, int nStart, int nLen) {
        int n = -1;
        try {
            this.oSavedFile.write(b, nStart, nLen);
            n = nLen;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return n;
    }

    public void close() {
        if (this.oSavedFile != null) {
            try {
                this.oSavedFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void write_nPos(long lastAccessTime, long nStartPos, long nEndPos) {
        try {
            this.output = new DataOutputStream(new FileOutputStream(this.tmpFile));
            this.output.writeLong(lastAccessTime);
            this.output.writeLong(nStartPos);
            this.output.writeLong(nEndPos);
            this.output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long[] read_nPos() {
        long[] nData = null;
        try {
            DataInputStream input = new DataInputStream(new FileInputStream(this.tmpFile));
            nData = new long[]{input.readLong(), input.readLong(), input.readLong()};
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nData;
    }
}

