/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.autoupdate;

import com.kingdee.bos.autoupdate.cache.CacheException;
import com.kingdee.bos.autoupdate.util.URLUtil;
import com.kingdee.eas.applet.EASCacheEntryInfo;
import com.kingdee.eas.applet.EASJNLPCacheEntryInfo;
import com.kingdee.eas.applet.autoupdate.ICacheState;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractCacheStateImpl
implements ICacheState {
    protected boolean isLocalNoCache = false;
    protected boolean isNeedUpdate = false;
    protected boolean isNeedDelete = false;
    protected List dirtyResources = new ArrayList();
    protected List deletedResources = new ArrayList();
    protected List pack200Resources = new ArrayList();
    protected EASJNLPCacheEntryInfo serverCache = null;
    protected EASJNLPCacheEntryInfo localCache = null;
    protected File baseDir = null;
    protected URL jnlp = null;

    public AbstractCacheStateImpl(String jnlpUrl, String localPath) {
        this.baseDir = new File(localPath);
        try {
            this.jnlp = URLUtil.getURL(null, (String)jnlpUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public boolean isLocalNoCache() {
        return this.isLocalNoCache;
    }

    public boolean isNeedUpdate() {
        return this.isNeedUpdate;
    }

    public EASJNLPCacheEntryInfo getLocalCacheEntryInfo() {
        return this.localCache;
    }

    public EASJNLPCacheEntryInfo getServerCacheEntryInfo() {
        return this.serverCache;
    }

    public boolean isNeedDelete() {
        return this.isNeedDelete;
    }

    public List getUpdatedResources() {
        return this.dirtyResources;
    }

    public List getDeletedResources() {
        return this.deletedResources;
    }

    public List getPack200Resources() {
        return this.pack200Resources;
    }

    public URL getCodebase() {
        return this.getServerCacheEntryInfo().getCodebase();
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public abstract void storeCacheState(HashMap var1) throws CacheException;

    public abstract void startTrace();

    protected Map toMap(EASJNLPCacheEntryInfo cacheEntry) {
        HashMap<String, EASCacheEntryInfo> map = new HashMap<String, EASCacheEntryInfo>();
        map.put(URLUtil.getRelativePath((URL)cacheEntry.getCodebase(), (URL)cacheEntry.getHref()), cacheEntry);
        Iterator it = cacheEntry.getCacheEntries().iterator();
        EASCacheEntryInfo entry = null;
        while (it.hasNext()) {
            entry = (EASCacheEntryInfo)((Object)it.next());
            map.put(URLUtil.getRelativePath((URL)cacheEntry.getCodebase(), (URL)entry.getHref()), entry);
        }
        return map;
    }
}

