/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.autoupdate;

import com.kingdee.bos.autoupdate.LogException;
import com.kingdee.bos.autoupdate.config.ConfigInfo;
import com.kingdee.bos.autoupdate.config.ConfigManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;

public class Logger {
    private static final int INFO = 1;
    private static final int DEBUG = 2;
    private static final int ERROR = 3;
    private static Logger logger;
    private static final String KD_AUTOUPDATE_LOG = "autoupdate.log";
    private static final long MAX_SIZE = 0x100000L;
    private PrintStream ps = null;
    private static File fileLog;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Logger getInstance() {
        if (logger == null) {
            try {
                logger = new Logger();
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
        return logger;
    }

    private Logger() throws LogException {
        this.openStream();
    }

    private void openStream() throws LogException {
        try {
            if (fileLog.exists() && fileLog.length() > 0x100000L) {
                long current = System.currentTimeMillis();
                fileLog.renameTo(new File(fileLog.toString() + "." + current));
                fileLog = ConfigManager.getConfigFile((String)KD_AUTOUPDATE_LOG);
            }
            if (!fileLog.exists()) {
                fileLog.createNewFile();
            }
            this.ps = new PrintStream(new FileOutputStream(fileLog, true));
        }
        catch (Exception fnfe) {
            System.out.println(fnfe + ":errror to system.out output!");
            this.ps = new PrintStream(System.out);
        }
    }

    public static File getLogFile() {
        return fileLog;
    }

    public void info(Object o) {
        this.output(1, o);
    }

    public void debug(Object o) {
        this.output(2, o);
    }

    public void error(Object o) {
        this.output(3, o);
    }

    private void output(int type, Object o) {
        if (o == null) {
            return;
        }
        if (1 == type) {
            this.printLogHeader(this.toStr(type));
        } else if (3 == type) {
            this.printLogHeader(this.toStr(type));
        } else if (2 == type && ConfigInfo.isDebug) {
            this.printLogHeader(this.toStr(type));
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unsupported type[" + type + "]"));
            }
            return;
        }
        if (o instanceof Throwable) {
            ((Throwable)o).printStackTrace(this.ps);
        } else {
            this.ps.print(o);
        }
        if (!(o instanceof String)) {
            this.ps.println();
        } else {
            String tmp = (String)o;
            if (tmp.lastIndexOf(10) < 0) {
                this.ps.println();
            }
        }
        this.ps.flush();
    }

    private String toStr(int type) {
        String result = "INFO";
        if (3 == type) {
            result = "ERROR";
        } else if (2 == type) {
            result = "DEBUG";
        }
        return result;
    }

    private void printLogHeader(String type) {
        this.ps.print("[" + DateFormat.getDateTimeInstance().format(new Date()) + "] ");
        this.ps.print(type + ": ");
    }

    static {
        $assertionsDisabled = !Logger.class.desiredAssertionStatus();
        logger = null;
        fileLog = ConfigManager.getConfigFile((String)KD_AUTOUPDATE_LOG);
    }
}

