/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.httpdownload;

import com.kingdee.eas.applet.httpdownload.DownloadTask;
import com.kingdee.eas.applet.httpdownload.HttpSiteInfo;
import com.kingdee.eas.applet.httpdownload.util.DebugLogger;
import com.kingdee.eas.applet.httpdownload.util.LimitedInputStream;
import com.kingdee.eas.applet.httpdownload.xml.XMLElement;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DownloadFromJnlp {
    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                System.setOut(new PrintStream(new FileOutputStream("./download.log"), true));
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            String jnlpUrl = args[0];
            DebugLogger.getDebugLogger().info("Get jnlp from [" + args[0] + "].......");
            long startTime = System.currentTimeMillis();
            StringBuffer jnlpBuf = new StringBuffer();
            try {
                Socket clientSocket = DownloadFromJnlp.getHttpSocket(jnlpUrl);
                Properties requetProps = new Properties();
                DownloadFromJnlp.sendRequest(clientSocket, requetProps, jnlpUrl, false);
                InputStream is = DownloadFromJnlp.getHttpInputStream(clientSocket);
                BufferedReader bufReader = new BufferedReader(new InputStreamReader(is));
                String ret = null;
                while ((ret = bufReader.readLine()) != null) {
                    jnlpBuf.append(ret);
                }
                bufReader.close();
                is.close();
                clientSocket.close();
                DebugLogger.getDebugLogger().info("[Time:" + (System.currentTimeMillis() - startTime) + "ms] get jnlp!");
                DebugLogger.getDebugLogger().debug("jnlpSize:" + jnlpBuf.length());
                startTime = System.currentTimeMillis();
                XMLElement jnlpDoc = new XMLElement();
                jnlpDoc.parseString(jnlpBuf.toString());
                String contextRoot = jnlpDoc.getStringAttribute("CODEBASE");
                ArrayList<String> fileDownloadList = new ArrayList<String>();
                Vector rootChild = jnlpDoc.getChildren();
                for (int i = 0; i < rootChild.size(); ++i) {
                    XMLElement childEle = (XMLElement)rootChild.get(i);
                    if (!"resources".equals(childEle.getName())) continue;
                    Vector filesUrl = childEle.getChildren();
                    for (int ind = 0; ind < filesUrl.size(); ++ind) {
                        fileDownloadList.add(((XMLElement)filesUrl.get(ind)).getStringAttribute("HREF"));
                    }
                }
                DebugLogger.getDebugLogger().info("[Time:" + (System.currentTimeMillis() - startTime) + "ms] parse jnlp!");
                try {
                    URI serverURI = new URI(contextRoot);
                    HttpSiteInfo siteInfo = new HttpSiteInfo(serverURI.getScheme(), serverURI.getHost(), serverURI.getPort(), serverURI.getPath());
                    startTime = System.currentTimeMillis();
                    DownloadTask task = new DownloadTask(siteInfo, new File("./").getCanonicalFile(), fileDownloadList);
                    task.start();
                    long totalDownloadSize = task.getDownloadBytes();
                    long totalDownloadTime = System.currentTimeMillis() - startTime;
                    DebugLogger.getDebugLogger().info("finish ====[Time:" + totalDownloadTime + "ms] [downloadSize:" + totalDownloadSize + "bytes], speed[" + totalDownloadSize * 1000L / (totalDownloadTime * 1024L) + "kB/s]");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Socket IO Exception, " + e.getMessage(), e);
            }
        }
        System.exit(0);
    }

    private static void sendRequest(final Socket clientSocket, Properties requetProps, String url, boolean useHttpV11) {
        try {
            OutputStream output = clientSocket.getOutputStream();
            BufferedOutputStream bufOut = new BufferedOutputStream(output){

                public void close() throws IOException {
                    this.flush();
                    clientSocket.shutdownOutput();
                }
            };
            String[] hostAndPort = DownloadFromJnlp.getHttpHostAndPort(url);
            url = url.substring(7);
            int index = url.indexOf("/");
            url = url.substring(index);
            DebugLogger.getDebugLogger().debug("Request url: [" + url + "]");
            if (useHttpV11) {
                bufOut.write(DownloadFromJnlp.toHTTPBytes("GET " + url + " HTTP/1.1\r\n"));
            } else {
                bufOut.write(DownloadFromJnlp.toHTTPBytes("GET " + url + " HTTP/1.0\r\n"));
            }
            DownloadFromJnlp.sendHeader(bufOut, "Accept", "*/*");
            DownloadFromJnlp.sendHeader(bufOut, "User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0)");
            DownloadFromJnlp.sendHeader(bufOut, "Host", hostAndPort[0] + ":" + hostAndPort[1]);
            DownloadFromJnlp.sendHeader(bufOut, "Connection", "close");
            Enumeration<Object> propsEN = requetProps.keys();
            while (propsEN.hasMoreElements()) {
                String propsName = (String)propsEN.nextElement();
                String value = requetProps.getProperty(propsName);
                DownloadFromJnlp.sendHeader(bufOut, propsName, value);
            }
            bufOut.write(DownloadFromJnlp.toHTTPBytes("\r\n"));
            bufOut.flush();
            clientSocket.shutdownOutput();
        }
        catch (Throwable ex) {
            throw new RuntimeException("Send request to url[" + url + "] failed, " + ex.getMessage(), ex);
        }
    }

    private static byte[] toHTTPBytes(String pValue) throws UnsupportedEncodingException {
        return pValue.getBytes("US-ASCII");
    }

    private static void sendHeader(OutputStream pOut, String pKey, String pValue) throws IOException {
        pOut.write(DownloadFromJnlp.toHTTPBytes(pKey + ": " + pValue + "\r\n"));
    }

    private static Socket getHttpSocket(String url) throws IOException {
        Socket socket = new Socket();
        socket.setKeepAlive(false);
        socket.setReceiveBufferSize(65535);
        socket.setSendBufferSize(65535);
        socket.setSoLinger(false, 1);
        socket.setSoTimeout(5000);
        socket.setTcpNoDelay(false);
        socket.setTrafficClass(8);
        String[] hostAndPort = DownloadFromJnlp.getHttpHostAndPort(url);
        DebugLogger.getDebugLogger().info("Try connect to [" + hostAndPort[0] + ":" + hostAndPort[1] + "] revBuf[" + socket.getReceiveBufferSize() + "] sendBuf[" + socket.getSendBufferSize() + "]...");
        try {
            socket.connect(new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1])));
        }
        catch (ConnectException ce) {
            if (ce.getMessage().indexOf("timed out") > 0) {
                throw new SocketTimeoutException("connect to [" + hostAndPort[0] + ":" + hostAndPort[1] + "] timed out!");
            }
            throw ce;
        }
        System.out.println("Connected!");
        return socket;
    }

    public static InputStream getHttpInputStream(Socket httpSocket) throws IOException {
        byte[] buffer = new byte[2048];
        BufferedInputStream input = new BufferedInputStream(httpSocket.getInputStream());
        String line = DownloadFromJnlp.readLine(input, buffer);
        StringTokenizer tokens = new StringTokenizer(line);
        tokens.nextToken();
        String statusCode = tokens.nextToken();
        String statusMsg = tokens.nextToken("\n\r");
        if (!"200".equals(statusCode) && !"206".equals(statusCode)) {
            throw new IOException("Unexpected Response from Server[" + statusCode + "] : " + statusMsg);
        }
        int contentLength = -1;
        while ((line = DownloadFromJnlp.readLine(input, buffer)) != null && !"".equals(line)) {
            if (!(line = line.toLowerCase()).startsWith("content-length:")) continue;
            contentLength = Integer.parseInt(line.substring("content-length:".length()).trim());
        }
        InputStream result = contentLength == -1 ? input : new LimitedInputStream(input, contentLength);
        return result;
    }

    public static String readLine(InputStream pIn, byte[] pBuffer) throws IOException {
        int next;
        int count = 0;
        while ((next = pIn.read()) >= 0 && next != 10) {
            if (next != 13) {
                pBuffer[count++] = (byte)next;
            }
            if (count < pBuffer.length) continue;
            throw new IOException("HTTP Header too long");
        }
        return new String(pBuffer, 0, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long downloadFile(String contextRoot, String fileToDownload) {
        File destFile = new File("./" + fileToDownload);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        File downloadTemp = new File("./" + fileToDownload + ".tmp");
        try {
            boolean downloadFailed = false;
            downloadTemp.createNewFile();
            long hasDownloaded = 0L;
            long downloadSize = 0L;
            for (int i = 1; i < 20; ++i) {
                RandomAccessFile tmpFile = new RandomAccessFile(downloadTemp, "rw");
                try {
                    Socket clientSocket = DownloadFromJnlp.getHttpSocket(contextRoot);
                    Properties requetProps = new Properties();
                    hasDownloaded = tmpFile.length();
                    if (hasDownloaded > 0L) {
                        DebugLogger.getDebugLogger().info("Continue download file[" + fileToDownload + "] from break point [" + hasDownloaded + "]......");
                        tmpFile.seek(hasDownloaded - 1L);
                        requetProps.setProperty("Range", "bytes=" + (hasDownloaded - 1L) + "-");
                    }
                    DownloadFromJnlp.sendRequest(clientSocket, requetProps, contextRoot + fileToDownload, true);
                    InputStream is = DownloadFromJnlp.getHttpInputStream(clientSocket);
                    byte[] buf = new byte[1536];
                    BufferedInputStream bufInput = new BufferedInputStream(is);
                    int ret = 0;
                    while ((ret = bufInput.read(buf, 0, buf.length)) != -1) {
                        tmpFile.write(buf, 0, ret);
                        hasDownloaded += (long)ret;
                        downloadSize += (long)ret;
                    }
                    is.close();
                    downloadFailed = false;
                    clientSocket.close();
                    break;
                }
                catch (SocketTimeoutException ste) {
                    DebugLogger.getDebugLogger().error("Socket timeout, retry [" + i + "] ......");
                    downloadFailed = true;
                    continue;
                }
                finally {
                    tmpFile.close();
                }
            }
            if (!downloadFailed) {
                if (destFile.exists()) {
                    destFile.delete();
                }
                downloadTemp.renameTo(destFile);
            }
            return downloadSize;
        }
        catch (IOException e) {
            throw new RuntimeException("Socket IO Exception, " + e.getMessage(), e);
        }
    }

    private static String[] getHttpHostAndPort(String url) {
        int index = (url = url.substring(7)).indexOf("/");
        if (index > 0) {
            url = url.substring(0, index);
        }
        if (url.indexOf(":") > 0) {
            return url.split(":");
        }
        return new String[]{url, "80"};
    }
}

