/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.httpdownload.util;

import com.kingdee.eas.applet.httpdownload.util.ObjectFIFO;
import com.kingdee.eas.applet.httpdownload.util.ThreadPoolWorker;

public class ThreadPool {
    private ObjectFIFO idleWorkers;
    private ThreadPoolWorker[] workerList;

    public ThreadPool(int numberOfThreads) {
        numberOfThreads = Math.max(1, numberOfThreads);
        this.idleWorkers = new ObjectFIFO(numberOfThreads);
        this.workerList = new ThreadPoolWorker[numberOfThreads];
        for (int i = 0; i < this.workerList.length; ++i) {
            this.workerList[i] = new ThreadPoolWorker(this.idleWorkers);
        }
    }

    public void execute(Runnable target) throws InterruptedException {
        ThreadPoolWorker worker = (ThreadPoolWorker)this.idleWorkers.remove();
        worker.process(target);
    }

    public void stopRequestIdleWorkers() {
        try {
            Object[] idle = this.idleWorkers.removeAll();
            for (int i = 0; i < idle.length; ++i) {
                ((ThreadPoolWorker)idle[i]).stopRequest();
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    public void stopRequestAllWorkers() {
        this.stopRequestIdleWorkers();
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException x) {
            // empty catch block
        }
        for (int i = 0; i < this.workerList.length; ++i) {
            if (!this.workerList[i].isAlive()) continue;
            this.workerList[i].stopRequest();
        }
    }

    public void waitForAllThreadIdle() {
        try {
            this.idleWorkers.waitUntilFull();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

